/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.items.modular.impl.bow;

import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.item.ArrowItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.UseAction;
import net.minecraft.stats.Stats;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.registries.ObjectHolder;
import se.mickelus.tetra.ConfigHandler;
import se.mickelus.tetra.items.modular.ItemModular;
import se.mickelus.tetra.items.modular.impl.bow.RangedProgressOverlay;
import se.mickelus.tetra.module.ItemEffect;
import se.mickelus.tetra.module.ItemModule;
import se.mickelus.tetra.module.SchemaRegistry;
import se.mickelus.tetra.module.data.ModuleModel;
import se.mickelus.tetra.module.schema.RemoveSchema;
import se.mickelus.tetra.module.schema.RepairSchema;
import se.mickelus.tetra.util.CastOptional;

public class ModularBowItem
extends ItemModular {
    public static final String staveKey = "bow/stave";
    public static final String stringKey = "bow/string";
    public static final String riserKey = "bow/riser";
    public static final String unlocalizedName = "modular_bow";
    protected ModuleModel arrowModel0 = new ModuleModel("draw_0", new ResourceLocation("tetra", "items/module/bow/arrow_0"));
    protected ModuleModel arrowModel1 = new ModuleModel("draw_1", new ResourceLocation("tetra", "items/module/bow/arrow_1"));
    protected ModuleModel arrowModel2 = new ModuleModel("draw_2", new ResourceLocation("tetra", "items/module/bow/arrow_2"));
    protected ItemStack vanillaBow;
    @ObjectHolder(value="tetra:modular_bow")
    public static ModularBowItem instance;

    public ModularBowItem() {
        super(new Item.Properties().func_200917_a(1));
        this.setRegistryName(unlocalizedName);
        this.majorModuleKeys = new String[]{stringKey, staveKey};
        this.minorModuleKeys = new String[]{riserKey};
        this.requiredModules = new String[]{stringKey, staveKey};
        this.vanillaBow = new ItemStack((IItemProvider)Items.field_151031_f);
        this.updateConfig((Integer)ConfigHandler.honeBowBase.get(), (Integer)ConfigHandler.honeBowIntegrityMultiplier.get());
        SchemaRegistry.instance.registerSchema(new RepairSchema(this));
        RemoveSchema.registerRemoveSchemas(this);
    }

    public void updateConfig(int honeBase, int honeIntegrityMultiplier) {
        this.honeBase = honeBase;
        this.honeIntegrityMultiplier = honeIntegrityMultiplier;
    }

    @Override
    public void clientInit() {
        super.clientInit();
        MinecraftForge.EVENT_BUS.register((Object)new RangedProgressOverlay(Minecraft.func_71410_x()));
    }

    public void func_77615_a(ItemStack itemStack, World world, LivingEntity entity, int timeLeft) {
        this.fireArrow(itemStack, world, entity, timeLeft);
    }

    public void onUsingTick(ItemStack itemStack, LivingEntity player, int count) {
        if (this.getEffectLevel(itemStack, ItemEffect.releaseLatch) > 0 && this.getProgress(itemStack, player) >= 1.0f) {
            player.func_184597_cx();
        }
    }

    protected void fireArrow(ItemStack itemStack, World world, LivingEntity entity, int timeLeft) {
        if (entity instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)entity;
            boolean playerInfinite = player.field_71075_bZ.field_75098_d || EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185312_x, (ItemStack)itemStack) > 0;
            ItemStack ammoStack = player.func_213356_f(this.vanillaBow);
            int drawProgress = Math.round(this.getProgress(itemStack, entity) * 20.0f);
            if ((drawProgress = ForgeEventFactory.onArrowLoose((ItemStack)itemStack, (World)world, (PlayerEntity)player, (int)drawProgress, (!ammoStack.func_190926_b() || playerInfinite ? 1 : 0) != 0)) < 0) {
                return;
            }
            if (!ammoStack.func_190926_b() || playerInfinite) {
                float projectileVelocity;
                if (ammoStack.func_190926_b()) {
                    ammoStack = new ItemStack((IItemProvider)Items.field_151032_g);
                }
                if ((projectileVelocity = ModularBowItem.getArrowVelocity(drawProgress, this.getOverbowCap(itemStack), (float)this.getOverbowRate(itemStack))) > 0.1f) {
                    boolean infiniteAmmo;
                    ArrowItem ammoItem = CastOptional.cast(ammoStack.func_77973_b(), ArrowItem.class).orElse((ArrowItem)Items.field_151032_g);
                    boolean bl = infiniteAmmo = player.field_71075_bZ.field_75098_d || ammoItem.isInfinite(ammoStack, itemStack, player);
                    if (!world.field_72995_K) {
                        AbstractArrowEntity projectile = ammoItem.func_200887_a(world, ammoStack, (LivingEntity)player);
                        projectile.func_184547_a((Entity)player, player.field_70125_A, player.field_70177_z, 0.0f, projectileVelocity * 3.0f, 1.0f);
                        if (projectileVelocity == 1.0f) {
                            projectile.func_70243_d(true);
                        }
                        projectile.func_70239_b(projectile.func_70242_d() + this.getDamageModifier(itemStack) / 5.0 - 2.0);
                        int punchLevel = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185310_v, (ItemStack)itemStack);
                        if (punchLevel > 0) {
                            projectile.func_70240_a(punchLevel);
                        }
                        if (EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185311_w, (ItemStack)itemStack) > 0) {
                            projectile.func_70015_d(100);
                        }
                        itemStack.func_222118_a(1, (LivingEntity)player, p_220009_1_ -> p_220009_1_.func_213334_d(player.func_184600_cs()));
                        if (infiniteAmmo || player.field_71075_bZ.field_75098_d && (ammoStack.func_77973_b() == Items.field_185166_h || ammoStack.func_77973_b() == Items.field_185167_i)) {
                            projectile.field_70251_a = AbstractArrowEntity.PickupStatus.CREATIVE_ONLY;
                        }
                        world.func_217376_c((Entity)projectile);
                        this.applyUsageEffects(entity, itemStack, 1.0);
                    }
                    world.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187737_v, SoundCategory.PLAYERS, 1.0f, 1.0f / (field_77697_d.nextFloat() * 0.4f + 1.2f) + projectileVelocity * 0.5f);
                    if (!infiniteAmmo && !player.field_71075_bZ.field_75098_d) {
                        ammoStack.func_190918_g(1);
                        if (ammoStack.func_190926_b()) {
                            player.field_71071_by.func_184437_d(ammoStack);
                        }
                    }
                    player.func_71029_a(Stats.field_75929_E.func_199076_b((Object)this));
                }
            }
        }
    }

    public double getDamageModifier(ItemStack itemStack) {
        if (this.isBroken(itemStack)) {
            return 0.0;
        }
        double damageModifier = this.getAllModules(itemStack).stream().mapToDouble(itemModule -> itemModule.getDamageModifier(itemStack)).sum();
        damageModifier = Arrays.stream(this.getSynergyData(itemStack)).mapToDouble(synergyData -> synergyData.damage).reduce(damageModifier, Double::sum);
        damageModifier = Arrays.stream(this.getSynergyData(itemStack)).mapToDouble(synergyData -> synergyData.damageMultiplier).reduce(damageModifier, (a, b) -> a * b);
        return this.getAllModules(itemStack).stream().map(itemModule -> itemModule.getDamageMultiplierModifier(itemStack)).reduce(damageModifier, (a, b) -> a * b);
    }

    public double getSpeedModifier(ItemStack itemStack) {
        double speedModifier = this.getAllModules(itemStack).stream().map(itemModule -> itemModule.getSpeedModifier(itemStack)).reduce(0.0, Double::sum);
        speedModifier = Arrays.stream(this.getSynergyData(itemStack)).mapToDouble(synergyData -> synergyData.attackSpeed).reduce(speedModifier, Double::sum);
        speedModifier = Arrays.stream(this.getSynergyData(itemStack)).mapToDouble(synergyData -> synergyData.attackSpeedMultiplier).reduce(speedModifier, (a, b) -> a * b);
        speedModifier = this.getAllModules(itemStack).stream().map(itemModule -> itemModule.getSpeedMultiplierModifier(itemStack)).reduce(speedModifier, (a, b) -> a * b);
        return Math.max(0.001, speedModifier);
    }

    public static float getArrowVelocity(int charge, float overbowCap, float overbowRate) {
        float f = (float)charge / 20.0f;
        f = (f * f + f * 2.0f) / 3.0f;
        if (overbowCap > 0.0f && f > 1.0f) {
            f = ModularBowItem.getProgressOverbowed(f, overbowCap, overbowRate);
        } else if (f > 1.0f) {
            f = 1.0f;
        }
        return f;
    }

    public int getDrawDuration(ItemStack itemStack) {
        return (int)(20.0 * this.getSpeedModifier(itemStack));
    }

    public float getProgress(ItemStack itemStack, @Nullable LivingEntity entity) {
        return Optional.ofNullable(entity).filter(e -> e.func_184605_cv() > 0).filter(e -> itemStack.equals(e.func_184607_cu())).map(e -> Float.valueOf((float)(this.func_77626_a(itemStack) - e.func_184605_cv()) * 1.0f / (float)this.getDrawDuration(itemStack))).orElse(Float.valueOf(0.0f)).floatValue();
    }

    public float getOverbowCap(ItemStack itemStack) {
        return 0.01f * (float)this.getEffectLevel(itemStack, ItemEffect.overbowed);
    }

    public double getOverbowRate(ItemStack itemStack) {
        return this.getEffectEfficiency(itemStack, ItemEffect.overbowed);
    }

    public static float getProgressOverbowed(float drawProgress, float overbowCap, float overbowRate) {
        return drawProgress > 1.0f ? 1.0f - MathHelper.func_76131_a((float)((drawProgress - 1.0f) * overbowRate), (float)0.0f, (float)overbowCap) : drawProgress;
    }

    public int func_77626_a(ItemStack stack) {
        return 37000;
    }

    public UseAction func_77661_b(ItemStack stack) {
        return UseAction.BOW;
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        boolean hasAmmo;
        ItemStack bowStack = player.func_184586_b(hand);
        ActionResult ret = ForgeEventFactory.onArrowNock((ItemStack)bowStack, (World)world, (PlayerEntity)player, (Hand)hand, (boolean)(hasAmmo = !player.func_213356_f(this.vanillaBow).func_190926_b()));
        if (ret != null) {
            return ret;
        }
        if (!player.field_71075_bZ.field_75098_d && !hasAmmo) {
            return hasAmmo ? new ActionResult(ActionResultType.PASS, (Object)bowStack) : new ActionResult(ActionResultType.FAIL, (Object)bowStack);
        }
        player.func_184598_c(hand);
        return new ActionResult(ActionResultType.SUCCESS, (Object)bowStack);
    }

    private String getDrawVariant(ItemStack itemStack, @Nullable LivingEntity entity) {
        float progress = ModularBowItem.getProgressOverbowed(this.getProgress(itemStack, entity), this.getOverbowCap(itemStack), (float)this.getOverbowRate(itemStack));
        if (progress == 0.0f) {
            return "item";
        }
        if ((double)progress < 0.65) {
            return "draw_0";
        }
        if ((double)progress < 0.9) {
            return "draw_1";
        }
        return "draw_2";
    }

    private ModuleModel getArrowModel(String drawVariant) {
        switch (drawVariant) {
            case "draw_0": {
                return this.arrowModel0;
            }
            case "draw_1": {
                return this.arrowModel1;
            }
            case "draw_2": {
                return this.arrowModel2;
            }
        }
        return this.arrowModel0;
    }

    @Override
    public String getModelCacheKey(ItemStack itemStack, LivingEntity entity) {
        return super.getModelCacheKey(itemStack, entity) + ":" + this.getDrawVariant(itemStack, entity);
    }

    @Override
    public ImmutableList<ModuleModel> getModels(ItemStack itemStack, @Nullable LivingEntity entity) {
        String modelType = this.getDrawVariant(itemStack, entity);
        ImmutableList models = this.getAllModules(itemStack).stream().sorted(Comparator.comparing(ItemModule::getRenderLayer)).flatMap(itemModule -> Arrays.stream(itemModule.getModels(itemStack))).filter(Objects::nonNull).filter(model -> model.type.equals(modelType) || model.type.equals("static")).collect(Collectors.collectingAndThen(Collectors.toList(), ImmutableList::copyOf));
        if (!modelType.equals("item")) {
            return ImmutableList.builder().addAll((Iterable)models).add((Object)this.getArrowModel(modelType)).build();
        }
        return models;
    }
}

