/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.items.modular.impl.toolbelt;

import java.util.Collection;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.ToolType;
import se.mickelus.tetra.blocks.salvage.BlockInteraction;
import se.mickelus.tetra.blocks.salvage.IBlockCapabilityInteractive;
import se.mickelus.tetra.capabilities.ICapabilityProvider;
import se.mickelus.tetra.items.modular.impl.toolbelt.ItemToolbeltModular;
import se.mickelus.tetra.items.modular.impl.toolbelt.inventory.InventoryPotions;
import se.mickelus.tetra.items.modular.impl.toolbelt.inventory.InventoryQuickslot;
import se.mickelus.tetra.items.modular.impl.toolbelt.inventory.InventoryQuiver;
import se.mickelus.tetra.items.modular.impl.toolbelt.inventory.InventoryStorage;
import se.mickelus.tetra.items.modular.impl.toolbelt.inventory.InventoryToolbelt;
import se.mickelus.tetra.items.modular.impl.toolbelt.inventory.ToolbeltSlotType;
import se.mickelus.tetra.module.ItemEffect;
import se.mickelus.tetra.util.CastOptional;

public class ToolbeltHelper {
    public static void equipItemFromToolbelt(PlayerEntity player, ToolbeltSlotType slotType, int index, Hand hand) {
        InventoryToolbelt inventory = null;
        ItemStack toolbeltStack = ToolbeltHelper.findToolbelt(player);
        if (!(toolbeltStack.func_77973_b() instanceof ItemToolbeltModular)) {
            return;
        }
        switch (slotType) {
            case quickslot: {
                inventory = new InventoryQuickslot(toolbeltStack);
                break;
            }
            case potion: {
                inventory = new InventoryPotions(toolbeltStack);
                break;
            }
            case quiver: {
                inventory = new InventoryQuiver(toolbeltStack);
                break;
            }
            case storage: {
                inventory = new InventoryStorage(toolbeltStack);
            }
        }
        if (inventory.func_70302_i_() <= index || inventory.func_70301_a(index).func_190926_b()) {
            return;
        }
        ItemStack heldItemStack = player.func_184586_b(hand);
        player.func_184611_a(hand, inventory.takeItemStack(index));
        if (!(heldItemStack.func_190926_b() || ToolbeltHelper.storeItemInToolbelt(toolbeltStack, heldItemStack) || player.field_71071_by.func_70441_a(heldItemStack))) {
            inventory.storeItemInInventory(player.func_184586_b(hand));
            player.func_184611_a(hand, heldItemStack);
            player.func_146105_b((ITextComponent)new TranslationTextComponent("toolbelt.blocked", new Object[0]), true);
        }
    }

    public static boolean storeItemInToolbelt(PlayerEntity player) {
        ItemStack toolbeltStack = ToolbeltHelper.findToolbelt(player);
        ItemStack itemStack = player.func_184586_b(Hand.OFF_HAND);
        Hand sourceHand = Hand.OFF_HAND;
        if (itemStack.func_190926_b()) {
            itemStack = player.func_184586_b(Hand.MAIN_HAND);
            sourceHand = Hand.MAIN_HAND;
        }
        if (toolbeltStack.func_190926_b() || itemStack.func_190926_b() || itemStack.func_77973_b() == ItemToolbeltModular.instance) {
            return true;
        }
        if (ToolbeltHelper.storeItemInToolbelt(toolbeltStack, itemStack)) {
            player.func_184611_a(sourceHand, ItemStack.field_190927_a);
            return true;
        }
        return false;
    }

    public static boolean storeItemInToolbelt(ItemStack toolbeltStack, ItemStack itemStack) {
        if (new InventoryPotions(toolbeltStack).storeItemInInventory(itemStack)) {
            return true;
        }
        if (new InventoryQuiver(toolbeltStack).storeItemInInventory(itemStack)) {
            return true;
        }
        if (new InventoryQuickslot(toolbeltStack).storeItemInInventory(itemStack)) {
            return true;
        }
        return new InventoryStorage(toolbeltStack).storeItemInInventory(itemStack);
    }

    public static ItemStack findToolbelt(PlayerEntity player) {
        PlayerInventory inventoryPlayer = player.field_71071_by;
        for (int i = 0; i < inventoryPlayer.field_70462_a.size(); ++i) {
            ItemStack itemStack = inventoryPlayer.func_70301_a(i);
            if (!ItemToolbeltModular.instance.equals(itemStack.func_77973_b())) continue;
            return itemStack;
        }
        return ItemStack.field_190927_a;
    }

    public static void emptyOverflowSlots(ItemStack itemStack, PlayerEntity player) {
        new InventoryQuickslot(itemStack).emptyOverflowSlots(player);
        new InventoryPotions(itemStack).emptyOverflowSlots(player);
        new InventoryStorage(itemStack).emptyOverflowSlots(player);
        new InventoryQuiver(itemStack).emptyOverflowSlots(player);
    }

    public static int getQuickAccessSlotIndex(PlayerEntity player, RayTraceResult traceResult, BlockState blockState) {
        ItemStack toolbeltStack = ToolbeltHelper.findToolbelt(player);
        InventoryQuickslot inventory = new InventoryQuickslot(toolbeltStack);
        List<Collection<ItemEffect>> effects = inventory.getSlotEffects();
        if (traceResult instanceof BlockRayTraceResult) {
            BlockRayTraceResult trace = (BlockRayTraceResult)traceResult;
            Vec3d hitVector = trace.func_216347_e();
            BlockPos blockPos = trace.func_216350_a();
            BlockInteraction blockInteraction = CastOptional.cast(blockState.func_177230_c(), IBlockCapabilityInteractive.class).map(block -> BlockInteraction.getInteractionAtPoint(player, blockState, blockPos, trace.func_216354_b(), (float)hitVector.field_72450_a - (float)blockPos.func_177958_n(), (float)hitVector.field_72448_b - (float)blockPos.func_177956_o(), (float)hitVector.field_72449_c - (float)blockPos.func_177952_p())).orElse(null);
            for (int i = 0; i < inventory.func_70302_i_(); ++i) {
                ICapabilityProvider providerItem;
                ItemStack itemStack = inventory.func_70301_a(i);
                if (!effects.get(i).contains((Object)ItemEffect.quickAccess) || itemStack.func_190926_b()) continue;
                ToolType requiredTool = blockState.getHarvestTool();
                if (requiredTool != null && itemStack.func_77973_b().getHarvestLevel(itemStack, requiredTool, player, blockState) > -1) {
                    return i;
                }
                if (blockInteraction == null || !(itemStack.func_77973_b() instanceof ICapabilityProvider) || (providerItem = (ICapabilityProvider)itemStack.func_77973_b()).getCapabilityLevel(itemStack, blockInteraction.requiredCapability) < blockInteraction.requiredLevel) continue;
                return i;
            }
        }
        return -1;
    }
}

