/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.items.modular.impl.toolbelt.gui;

import java.util.Arrays;
import java.util.Objects;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import se.mickelus.mgui.gui.GuiElement;
import se.mickelus.mgui.gui.GuiRect;
import se.mickelus.mgui.gui.GuiTexture;
import se.mickelus.mgui.gui.animation.Applier;
import se.mickelus.mgui.gui.animation.KeyframeAnimation;
import se.mickelus.tetra.items.modular.impl.toolbelt.gui.OverlayGuiQuickslot;
import se.mickelus.tetra.items.modular.impl.toolbelt.inventory.InventoryQuickslot;

public class OverlayGuiQuickslotGroup
extends GuiElement {
    private static final ResourceLocation toolbeltTexture = new ResourceLocation("tetra", "textures/gui/toolbelt-inventory.png");
    private KeyframeAnimation showAnimation;
    private KeyframeAnimation hideAnimation;
    private OverlayGuiQuickslot[] slots = new OverlayGuiQuickslot[0];

    public OverlayGuiQuickslotGroup(int x, int y) {
        super(x, y, 200, 0);
        this.isVisible = false;
        this.opacity = 0.0f;
        this.showAnimation = new KeyframeAnimation(200, (GuiElement)this).applyTo(new Applier[]{new Applier.TranslateX((float)(this.getX() + 10)), new Applier.Opacity(1.0f)}).onStop(isFinished -> {
            if (isFinished.booleanValue()) {
                Arrays.stream(this.slots).filter(Objects::nonNull).forEach(item -> item.setVisible(true));
            }
        });
        this.hideAnimation = new KeyframeAnimation(100, (GuiElement)this).applyTo(new Applier[]{new Applier.TranslateX((float)this.getX()), new Applier.Opacity(0.0f)}).onStop(isFinished -> {
            if (isFinished.booleanValue()) {
                this.isVisible = false;
            }
        });
    }

    public void setInventory(InventoryQuickslot inventory) {
        this.clearChildren();
        int numSlots = inventory.func_70302_i_();
        this.slots = new OverlayGuiQuickslot[numSlots];
        this.addChild((GuiElement)new GuiTexture(0, numSlots * -20 / 2 - 7, 22, 7, 0, 28, toolbeltTexture));
        this.addChild((GuiElement)new GuiTexture(0, numSlots * 20 / 2, 22, 7, 0, 35, toolbeltTexture));
        this.addChild((GuiElement)new GuiRect(0, numSlots * -20 / 2, 22, numSlots * 20, -872415232));
        for (int i = 0; i < numSlots; ++i) {
            ItemStack itemStack = inventory.func_70301_a(i);
            if (itemStack.func_190926_b()) continue;
            this.slots[i] = new OverlayGuiQuickslot(-35, numSlots * -20 / 2 + i * 20, itemStack, i);
            this.addChild(this.slots[i]);
        }
    }

    protected void onShow() {
        if (this.hideAnimation.isActive()) {
            this.hideAnimation.stop();
        }
        if (this.slots.length > 0) {
            this.showAnimation.start();
        }
    }

    protected boolean onHide() {
        if (this.showAnimation.isActive()) {
            this.showAnimation.stop();
        }
        this.hideAnimation.start();
        Arrays.stream(this.slots).filter(Objects::nonNull).forEach(item -> item.setVisible(false));
        return false;
    }

    public int getFocus() {
        for (int i = 0; i < this.slots.length; ++i) {
            OverlayGuiQuickslot element = this.slots[i];
            if (this.slots[i] == null || !element.hasFocus()) continue;
            return element.getSlot();
        }
        return -1;
    }
}

