/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.items.modular.impl.toolbelt.gui;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.client.config.GuiUtils;
import se.mickelus.mgui.gui.GuiElement;
import se.mickelus.mgui.gui.GuiTexture;
import se.mickelus.tetra.gui.GuiKeybinding;
import se.mickelus.tetra.items.modular.impl.toolbelt.OverlayToolbelt;
import se.mickelus.tetra.items.modular.impl.toolbelt.ToolbeltContainer;
import se.mickelus.tetra.items.modular.impl.toolbelt.gui.GuiPotionsBackdrop;
import se.mickelus.tetra.items.modular.impl.toolbelt.gui.GuiQuickSlotBackdrop;
import se.mickelus.tetra.items.modular.impl.toolbelt.gui.GuiQuiverBackdrop;
import se.mickelus.tetra.items.modular.impl.toolbelt.gui.GuiStorageBackdrop;

@OnlyIn(value=Dist.CLIENT)
public class ToolbeltGui
extends ContainerScreen<ToolbeltContainer> {
    private static ToolbeltGui instance;
    private static final ResourceLocation playerInventoryTexture;
    private GuiElement defaultGui;

    public ToolbeltGui(ToolbeltContainer container, PlayerInventory playerInventory, ITextComponent title) {
        super((Container)container, playerInventory, title);
        this.field_146999_f = 179;
        this.field_147000_g = 176;
        int numQuickslots = container.getQuickslotInventory().func_70302_i_();
        int numStorageSlots = container.getStorageInventory().func_70302_i_();
        int numPotionSlots = container.getPotionInventory().func_70302_i_();
        int numQuiverSlots = container.getQuiverInventory().func_70302_i_();
        int offset = 0;
        this.defaultGui = new GuiElement(0, 0, this.field_146999_f, this.field_147000_g);
        this.defaultGui.addChild((GuiElement)new GuiTexture(0, 103, 179, 106, playerInventoryTexture));
        if (numPotionSlots > 0) {
            this.defaultGui.addChild((GuiElement)new GuiPotionsBackdrop(0, 55 - 30 * offset, numPotionSlots, container.getPotionInventory().getSlotEffects()));
            ++offset;
        }
        if (numQuiverSlots > 0) {
            this.defaultGui.addChild((GuiElement)new GuiQuiverBackdrop(0, 55 - 30 * offset, numQuiverSlots, container.getQuiverInventory().getSlotEffects()));
            ++offset;
        }
        if (numQuickslots > 0) {
            this.defaultGui.addChild((GuiElement)new GuiQuickSlotBackdrop(0, 55 - 30 * offset, numQuickslots, container.getQuickslotInventory().getSlotEffects()));
            ++offset;
        }
        if (numStorageSlots > 0) {
            this.defaultGui.addChild((GuiElement)new GuiStorageBackdrop(0, 55 - 30 * offset, numStorageSlots, container.getStorageInventory().getSlotEffects()));
        }
        this.defaultGui.addChild((GuiElement)new GuiKeybinding(166, 85, OverlayToolbelt.instance.accessBinding));
        this.defaultGui.addChild((GuiElement)new GuiKeybinding(166, 100, OverlayToolbelt.instance.restockBinding));
        instance = this;
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        this.renderBackground();
        super.render(mouseX, mouseY, partialTicks);
        this.func_191948_b(mouseX, mouseY);
        this.func_146979_b(mouseX, mouseY);
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        int x = (this.width - this.field_146999_f) / 2;
        int y = (this.height - this.field_147000_g) / 2;
        this.defaultGui.draw(x, y, this.width, this.height, mouseX, mouseY, 1.0f);
    }

    protected void func_191948_b(int mouseX, int mouseY) {
        super.func_191948_b(mouseX, mouseY);
        List tooltipLines = this.defaultGui.getTooltipLines();
        if (tooltipLines != null) {
            tooltipLines = tooltipLines.stream().map(line -> line.replace("\\n", "\n")).flatMap(line -> Arrays.stream(line.split("\n"))).collect(Collectors.toList());
            GuiUtils.drawHoveringText(tooltipLines, (int)mouseX, (int)mouseY, (int)this.width, (int)this.height, (int)-1, (FontRenderer)this.font);
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        return super.mouseClicked(mouseX, mouseY, mouseButton);
    }

    static {
        playerInventoryTexture = new ResourceLocation("tetra", "textures/gui/player-inventory.png");
    }
}

