/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.items.modular.impl.toolbelt.inventory;

import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.NonNullList;
import se.mickelus.tetra.NBTHelper;
import se.mickelus.tetra.items.modular.impl.toolbelt.ItemToolbeltModular;
import se.mickelus.tetra.items.modular.impl.toolbelt.SlotType;
import se.mickelus.tetra.items.modular.impl.toolbelt.inventory.InventoryToolbelt;

public class InventoryQuickslot
extends InventoryToolbelt {
    public static final int maxSize = 12;
    private static final String inventoryKey = "quickInventory";
    private static final String shadowsKey = "quickShadows";
    private NonNullList<ItemStack> inventoryShadows;

    public InventoryQuickslot(ItemStack stack) {
        super(inventoryKey, stack, 12, SlotType.quick);
        ItemToolbeltModular item = (ItemToolbeltModular)stack.func_77973_b();
        this.numSlots = item.getNumSlots(stack, SlotType.quick);
        this.inventoryShadows = NonNullList.func_191197_a((int)12, (Object)ItemStack.field_190927_a);
        this.readFromNBT(NBTHelper.getTag(stack));
    }

    @Override
    public void readFromNBT(CompoundNBT tagCompound) {
        super.readFromNBT(tagCompound);
        ListNBT shadows = tagCompound.func_150295_c(shadowsKey, 10);
        for (int i = 0; i < shadows.size(); ++i) {
            CompoundNBT item = shadows.func_150305_b(i);
            int slot = item.func_74762_e("slot");
            if (0 > slot || slot >= this.func_70302_i_()) continue;
            this.inventoryShadows.set(slot, (Object)ItemStack.func_199557_a((CompoundNBT)item));
        }
    }

    @Override
    public void writeToNBT(CompoundNBT tagcompound) {
        super.writeToNBT(tagcompound);
        ListNBT shadows = new ListNBT();
        for (int i = 0; i < 12; ++i) {
            CompoundNBT item = new CompoundNBT();
            item.func_74768_a("slot", i);
            this.getShadowOfSlot(i).func_77955_b(item);
            shadows.add((Object)item);
        }
        tagcompound.func_218657_a(shadowsKey, (INBT)shadows);
    }

    public ItemStack getShadowOfSlot(int index) {
        return (ItemStack)this.inventoryShadows.get(index);
    }

    @Override
    public void func_70296_d() {
        int i;
        for (i = 0; i < this.func_70302_i_(); ++i) {
            if (this.func_70301_a(i).func_190916_E() != 0) continue;
            this.inventoryContents.set(i, (Object)ItemStack.field_190927_a);
        }
        for (i = 0; i < this.func_70302_i_(); ++i) {
            if (this.func_70301_a(i).func_190926_b()) continue;
            this.inventoryShadows.set(i, (Object)this.func_70301_a(i).func_77946_l());
        }
        this.writeToNBT(NBTHelper.getTag(this.toolbeltItemStack));
    }

    private int getShadowIndex(ItemStack itemStack) {
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            if (!itemStack.func_77969_a(this.getShadowOfSlot(i)) || !this.func_70301_a(i).func_190926_b()) continue;
            return i;
        }
        return -1;
    }

    @Override
    public boolean storeItemInInventory(ItemStack itemStack) {
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            ItemStack storedStack = this.func_70301_a(i);
            if (!storedStack.func_77969_a(itemStack) || storedStack.func_190916_E() >= storedStack.func_77976_d()) continue;
            int moveCount = Math.min(itemStack.func_190916_E(), storedStack.func_77976_d() - storedStack.func_190916_E());
            storedStack.func_190917_f(moveCount);
            this.func_70299_a(i, storedStack);
            itemStack.func_190918_g(moveCount);
            if (!itemStack.func_190926_b()) continue;
            return true;
        }
        int restockIndex = this.getShadowIndex(itemStack);
        if (restockIndex != -1) {
            this.func_70299_a(restockIndex, itemStack);
            return true;
        }
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            if (!this.func_70301_a(i).func_190926_b()) continue;
            this.func_70299_a(i, itemStack);
            return true;
        }
        return false;
    }
}

