/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.module;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SPlaySoundEventPacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.GameType;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.event.entity.living.EnderTeleportEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingExperienceDropEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.ArrowNockEvent;
import net.minecraftforge.event.entity.player.CriticalHitEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import se.mickelus.tetra.RotationHelper;
import se.mickelus.tetra.ToolTypes;
import se.mickelus.tetra.capabilities.CapabilityHelper;
import se.mickelus.tetra.effects.EarthboundEffect;
import se.mickelus.tetra.items.modular.ItemModular;
import se.mickelus.tetra.items.modular.ItemModularHandheld;
import se.mickelus.tetra.items.modular.impl.toolbelt.ToolbeltHelper;
import se.mickelus.tetra.items.modular.impl.toolbelt.inventory.InventoryQuiver;
import se.mickelus.tetra.module.ItemEffect;
import se.mickelus.tetra.util.CastOptional;

public class ItemEffectHandler {
    private Cache<UUID, Integer> strikeCache = CacheBuilder.newBuilder().maximumSize(100L).expireAfterWrite(1L, TimeUnit.MINUTES).build();
    public static ItemEffectHandler instance;
    private static final BlockPos[] sweep1;
    private static final BlockPos[] sweep2;

    public ItemEffectHandler() {
        instance = this;
    }

    private int getEffectLevel(ItemStack itemStack, ItemEffect effect) {
        ItemModular item = (ItemModular)itemStack.func_77973_b();
        return item.getEffectLevel(itemStack, effect);
    }

    private double getEffectEfficiency(ItemStack itemStack, ItemEffect effect) {
        ItemModular item = (ItemModular)itemStack.func_77973_b();
        return item.getEffectEfficiency(itemStack, effect);
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onExperienceDrop(LivingExperienceDropEvent event) {
        Optional.ofNullable(event.getAttackingPlayer()).map(LivingEntity::func_184614_ca).filter(itemStack -> !itemStack.func_190926_b()).filter(itemStack -> itemStack.func_77973_b() instanceof ItemModular).ifPresent(itemStack -> {
            int intuitLevel = this.getEffectLevel((ItemStack)itemStack, ItemEffect.intuit);
            int xp = event.getDroppedExperience();
            if (intuitLevel > 0 && xp > 0) {
                ((ItemModular)itemStack.func_77973_b()).tickHoningProgression((LivingEntity)event.getAttackingPlayer(), (ItemStack)itemStack, intuitLevel * xp);
            }
        });
    }

    @SubscribeEvent
    public void onLivingHurt(LivingHurtEvent event) {
        Optional.ofNullable(event.getSource().func_76346_g()).filter(entity -> entity instanceof PlayerEntity).map(entity -> (LivingEntity)entity).map(LivingEntity::func_184614_ca).filter(itemStack -> !itemStack.func_190926_b()).filter(itemStack -> itemStack.func_77973_b() instanceof ItemModular).ifPresent(itemStack -> {
            int quickStrikeLevel = this.getEffectLevel((ItemStack)itemStack, ItemEffect.quickStrike);
            if (quickStrikeLevel > 0) {
                float maxDamage = (float)((LivingEntity)event.getSource().func_76346_g()).func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
                float multiplier = (float)quickStrikeLevel * 0.05f + 0.2f;
                if (event.getAmount() < multiplier * maxDamage) {
                    event.setAmount(multiplier * maxDamage);
                }
            }
        });
    }

    @SubscribeEvent
    public void onLivingDamage(LivingDamageEvent event) {
        Optional.ofNullable(event.getSource().func_76346_g()).filter(entity -> entity instanceof PlayerEntity).map(entity -> (LivingEntity)entity).map(LivingEntity::func_184614_ca).filter(itemStack -> !itemStack.func_190926_b()).filter(itemStack -> itemStack.func_77973_b() instanceof ItemModular).ifPresent(itemStack -> {
            int unarmoredBonusLevel;
            int penetratingLevel = this.getEffectLevel((ItemStack)itemStack, ItemEffect.armorPenetration);
            if (penetratingLevel > 0 && event.getAmount() < (float)penetratingLevel) {
                event.setAmount((float)penetratingLevel);
            }
            if ((unarmoredBonusLevel = this.getEffectLevel((ItemStack)itemStack, ItemEffect.unarmoredDamage)) > 0 && event.getEntityLiving().func_70658_aO() == 0) {
                event.setAmount(event.getAmount() + (float)unarmoredBonusLevel);
            }
        });
    }

    @SubscribeEvent
    public void onLivingJump(LivingEvent.LivingJumpEvent event) {
        Optional.ofNullable(event.getEntityLiving().func_70660_b((Effect)EarthboundEffect.instance)).ifPresent(effect -> event.getEntityLiving().func_213317_d(event.getEntityLiving().func_213322_ci().func_216372_d(1.0, 0.5, 1.0)));
    }

    @SubscribeEvent
    public void onCriticalHit(CriticalHitEvent event) {
        Optional.ofNullable(event.getEntityLiving()).filter(entity -> entity instanceof PlayerEntity).map(entity -> entity).map(LivingEntity::func_184614_ca).filter(itemStack -> !itemStack.func_190926_b()).filter(itemStack -> itemStack.func_77973_b() instanceof ItemModular).ifPresent(itemStack -> {
            int critLevel;
            int backstabLevel = this.getEffectLevel((ItemStack)itemStack, ItemEffect.backstab);
            if (backstabLevel > 0 && event.getTarget() instanceof LivingEntity) {
                LivingEntity attacker = event.getEntityLiving();
                LivingEntity target = (LivingEntity)event.getTarget();
                if (180.0f - Math.abs(Math.abs(attacker.field_70759_as - target.field_70759_as) % 360.0f - 180.0f) < 60.0f) {
                    event.setDamageModifier(Math.max(1.25f + 0.25f * (float)backstabLevel, event.getDamageModifier()));
                    event.setResult(Event.Result.ALLOW);
                }
            }
            if ((critLevel = this.getEffectLevel((ItemStack)itemStack, ItemEffect.criticalStrike)) > 0 && (double)event.getEntityLiving().func_70681_au().nextFloat() < (double)critLevel * 0.01) {
                event.setDamageModifier(Math.max((float)this.getEffectEfficiency((ItemStack)itemStack, ItemEffect.criticalStrike), event.getDamageModifier()));
                event.setResult(Event.Result.ALLOW);
            }
        });
    }

    @SubscribeEvent
    public void onLeftClickBlock(PlayerInteractEvent.LeftClickBlock event) {
        Optional.of(event.getItemStack()).filter(itemStack -> !itemStack.func_190926_b()).filter(itemStack -> itemStack.func_77973_b() instanceof ItemModularHandheld).ifPresent(itemStack -> {
            int critLevel;
            ItemModularHandheld item = (ItemModularHandheld)itemStack.func_77973_b();
            int strikingLevel = 0;
            BlockPos pos = event.getPos();
            World world = event.getWorld();
            BlockState blockState = world.func_180495_p(pos);
            PlayerEntity breakingPlayer = event.getPlayer();
            ToolType tool = null;
            if (ItemModularHandheld.isToolEffective(ToolType.AXE, blockState) && (strikingLevel = this.getEffectLevel((ItemStack)itemStack, ItemEffect.strikingAxe)) > 0) {
                tool = ToolType.AXE;
            }
            if (strikingLevel <= 0 && ItemModularHandheld.isToolEffective(ToolType.PICKAXE, blockState) && (strikingLevel = this.getEffectLevel((ItemStack)itemStack, ItemEffect.strikingPickaxe)) > 0) {
                tool = ToolType.PICKAXE;
            }
            if (strikingLevel <= 0 && ItemModularHandheld.isToolEffective(ToolTypes.cut, blockState) && (strikingLevel = this.getEffectLevel((ItemStack)itemStack, ItemEffect.strikingCut)) > 0) {
                tool = ToolTypes.cut;
            }
            if (strikingLevel <= 0 && ItemModularHandheld.isToolEffective(ToolType.SHOVEL, blockState) && (strikingLevel = this.getEffectLevel((ItemStack)itemStack, ItemEffect.strikingShovel)) > 0) {
                tool = ToolType.SHOVEL;
            }
            if (strikingLevel > 0) {
                int sweepingLevel = this.getEffectLevel((ItemStack)itemStack, ItemEffect.sweepingStrike);
                if ((double)breakingPlayer.func_184825_o(0.0f) > 0.9) {
                    if (sweepingLevel > 0) {
                        this.breakBlocksAround(world, breakingPlayer, (ItemStack)itemStack, pos, tool, sweepingLevel);
                    } else {
                        int toolLevel = itemStack.func_77973_b().getHarvestLevel(itemStack, tool, breakingPlayer, blockState);
                        if (toolLevel >= 0 && toolLevel >= blockState.func_177230_c().getHarvestLevel(blockState) || itemStack.func_150998_b(blockState)) {
                            ItemEffectHandler.breakBlock(world, breakingPlayer, itemStack, pos, blockState, true);
                        }
                    }
                    item.applyUsageEffects((LivingEntity)breakingPlayer, (ItemStack)itemStack, 1.0);
                    item.applyDamage(item.getBlockDestroyDamage(), (ItemStack)itemStack, (LivingEntity)breakingPlayer);
                }
                event.setCanceled(true);
                breakingPlayer.func_184821_cY();
            }
            if (!event.getWorld().field_72995_K && (critLevel = this.getEffectLevel((ItemStack)itemStack, ItemEffect.criticalStrike)) > 0 && this.critBlock(world, breakingPlayer, pos, blockState, (ItemStack)itemStack, tool, critLevel)) {
                event.setCanceled(true);
            }
        });
    }

    private boolean critBlock(World world, PlayerEntity breakingPlayer, BlockPos pos, BlockState blockState, ItemStack itemStack, ToolType tool, int critLevel) {
        int toolLevel;
        if ((double)breakingPlayer.func_70681_au().nextFloat() < (double)critLevel * 0.01 && itemStack.func_77973_b().func_150893_a(itemStack, blockState) > 2.0f * blockState.func_185887_b((IBlockReader)world, pos) && ((toolLevel = itemStack.func_77973_b().getHarvestLevel(itemStack, tool, breakingPlayer, blockState)) >= 0 && toolLevel >= blockState.func_177230_c().getHarvestLevel(blockState) || itemStack.func_150998_b(blockState))) {
            ItemEffectHandler.breakBlock(world, breakingPlayer, itemStack, pos, blockState, true);
            itemStack.func_222118_a(2, (LivingEntity)breakingPlayer, t -> {});
            ((ItemModular)itemStack.func_77973_b()).tickProgression((LivingEntity)breakingPlayer, itemStack, 1);
            if (breakingPlayer instanceof ServerPlayerEntity) {
                ItemEffectHandler.sendEventToPlayer((ServerPlayerEntity)breakingPlayer, 2001, pos, Block.func_196246_j((BlockState)blockState));
            }
            if (world instanceof ServerWorld) {
                ((ServerWorld)world).func_195598_a((IParticleData)ParticleTypes.field_197614_g, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, 12, (world.field_73012_v.nextDouble() * 2.0 - 1.0) * 0.3, 0.3 + world.field_73012_v.nextDouble() * 0.3, (world.field_73012_v.nextDouble() * 2.0 - 1.0) * 0.3, 0.3);
            }
            return true;
        }
        return false;
    }

    @SubscribeEvent
    public void onEnderTeleport(EnderTeleportEvent event) {
        if (!event.getEntity().func_130014_f_().field_72995_K) {
            AxisAlignedBB aabb = new AxisAlignedBB(event.getTargetX() - 24.0, event.getTargetY() - 24.0, event.getTargetZ() - 24.0, event.getTargetX() + 24.0, event.getTargetY() + 24.0, event.getTargetZ() + 24.0);
            event.getEntity().func_130014_f_().func_217357_a(PlayerEntity.class, aabb).forEach(player -> {
                double effectProbability;
                int reverbLevel = CapabilityHelper.getPlayerEffectLevel(player, ItemEffect.enderReverb);
                if (reverbLevel > 0 && (effectProbability = CapabilityHelper.getPlayerEffectEfficiency(player, ItemEffect.enderReverb)) > 0.0 && player.func_70681_au().nextDouble() < effectProbability * 2.0) {
                    player.func_213373_a(event.getTargetX(), event.getTargetY(), event.getTargetZ(), true);
                    player.func_195064_c(new EffectInstance(Effects.field_76431_k, 40 * reverbLevel));
                }
            });
        }
    }

    public static boolean canHarvestBlock(@Nonnull BlockState state, @Nonnull PlayerEntity player, @Nonnull IBlockReader world, @Nonnull BlockPos pos) {
        if (state.func_185904_a().func_76229_l()) {
            return true;
        }
        ItemStack stack = player.func_184614_ca();
        ToolType tool = state.getHarvestTool();
        if (stack.func_190926_b() || tool == null) {
            return player.func_184823_b(state);
        }
        int toolLevel = stack.func_77973_b().getHarvestLevel(stack, tool, player, state);
        if (toolLevel < 0) {
            return player.func_184823_b(state);
        }
        return toolLevel >= state.getHarvestLevel();
    }

    public static boolean breakBlock(World world, PlayerEntity breakingPlayer, ItemStack toolStack, BlockPos pos, BlockState blockState, boolean harvest) {
        if (!world.field_72995_K) {
            ServerPlayerEntity serverPlayer = (ServerPlayerEntity)breakingPlayer;
            GameType gameType = serverPlayer.field_71134_c.func_73081_b();
            int exp = ForgeHooks.onBlockBreakEvent((World)world, (GameType)gameType, (ServerPlayerEntity)serverPlayer, (BlockPos)pos);
            if (exp != -1) {
                boolean canRemove;
                boolean bl = canRemove = !toolStack.onBlockStartBreak(pos, breakingPlayer) && !breakingPlayer.func_223729_a(world, pos, gameType) && blockState.canHarvestBlock((IBlockReader)world, pos, breakingPlayer) && blockState.func_177230_c().removedByPlayer(blockState, world, pos, breakingPlayer, harvest, world.func_204610_c(pos));
                if (canRemove) {
                    blockState.func_177230_c().func_176206_d((IWorld)world, pos, blockState);
                    if (harvest) {
                        blockState.func_177230_c().func_180657_a(world, breakingPlayer, pos, blockState, world.func_175625_s(pos), toolStack);
                        if (exp > 0) {
                            blockState.func_177230_c().func_180637_b(world, pos, exp);
                        }
                    }
                }
                return canRemove;
            }
            return false;
        }
        return blockState.func_177230_c().removedByPlayer(blockState, world, pos, breakingPlayer, harvest, world.func_204610_c(pos));
    }

    private void breakBlocksAround(World world, PlayerEntity breakingPlayer, ItemStack toolStack, BlockPos originPos, ToolType tool, int sweepingLevel) {
        if (world.field_72995_K) {
            return;
        }
        Direction facing = breakingPlayer.func_174811_aO();
        int strikeCounter = this.getStrikeCounter(breakingPlayer.func_110124_au());
        boolean alternate = strikeCounter % 2 == 0;
        float efficiency = CastOptional.cast(toolStack.func_77973_b(), ItemModularHandheld.class).map(item -> Float.valueOf(item.getCapabilityEfficiency(toolStack, tool))).orElse(Float.valueOf(0.0f)).floatValue();
        breakingPlayer.func_184810_cG();
        List positions = Arrays.stream(strikeCounter / 2 % 2 == 0 ? sweep1 : sweep2).map(pos -> alternate ? new BlockPos(-pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()) : pos).map(pos -> RotationHelper.rotatePitch(pos, breakingPlayer.field_70125_A)).map(pos -> RotationHelper.rotateCardinal(pos, facing)).map(arg_0 -> ((BlockPos)originPos).func_177971_a(arg_0)).collect(Collectors.toList());
        for (BlockPos pos2 : positions) {
            BlockState blockState = world.func_180495_p(pos2);
            if (ItemModularHandheld.isToolEffective(tool, blockState)) {
                int toolLevel = toolStack.func_77973_b().getHarvestLevel(toolStack, tool, breakingPlayer, blockState);
                if ((toolLevel < 0 || toolLevel < blockState.func_177230_c().getHarvestLevel(blockState)) && !toolStack.func_150998_b(blockState)) break;
                if (breakingPlayer instanceof ServerPlayerEntity) {
                    ItemEffectHandler.sendEventToPlayer((ServerPlayerEntity)breakingPlayer, 2001, pos2, Block.func_196246_j((BlockState)blockState));
                }
                efficiency = (float)((double)efficiency - ((double)blockState.func_185887_b((IBlockReader)world, pos2) + 0.5));
                ItemEffectHandler.breakBlock(world, breakingPlayer, toolStack, pos2, blockState, true);
            } else if (blockState.func_200132_m()) {
                efficiency -= blockState.func_185887_b((IBlockReader)world, pos2);
            }
            if (!(efficiency <= 0.0f)) continue;
            break;
        }
    }

    public static void sendEventToPlayer(ServerPlayerEntity player, int type, BlockPos pos, int data) {
        player.field_71135_a.func_147359_a((IPacket)new SPlaySoundEventPacket(type, pos, data, false));
    }

    private int getStrikeCounter(UUID entityId) {
        int counter = 0;
        try {
            counter = (Integer)this.strikeCache.get((Object)entityId, () -> 0);
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
        this.strikeCache.put((Object)entityId, (Object)(counter + 1));
        return counter;
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onArrowNock(ArrowNockEvent event) {
        ItemStack itemStack;
        PlayerEntity player = event.getPlayer();
        if (!event.hasAmmo() && player.func_184586_b(Hand.OFF_HAND).func_190926_b() && !(itemStack = ToolbeltHelper.findToolbelt(player)).func_190926_b()) {
            InventoryQuiver inventory = new InventoryQuiver(itemStack);
            List<Collection<ItemEffect>> effects = inventory.getSlotEffects();
            for (int i = 0; i < inventory.func_70302_i_(); ++i) {
                if (!effects.get(i).contains((Object)ItemEffect.quickAccess) || inventory.func_70301_a(i).func_190926_b()) continue;
                player.func_184611_a(Hand.OFF_HAND, inventory.func_70301_a(i).func_77979_a(1));
                player.func_184598_c(event.getHand());
                inventory.func_70296_d();
                event.setAction(new ActionResult(ActionResultType.SUCCESS, (Object)event.getBow()));
                return;
            }
        }
    }

    static {
        sweep1 = new BlockPos[]{new BlockPos(-2, 0, 0), new BlockPos(-1, 0, 0), new BlockPos(0, 0, 0), new BlockPos(1, 0, 0), new BlockPos(2, 0, 0), new BlockPos(-1, 0, 1), new BlockPos(0, 0, 1), new BlockPos(1, 0, 1), new BlockPos(-3, 0, -1), new BlockPos(-2, 0, -1), new BlockPos(-1, 0, -1), new BlockPos(0, 0, -1), new BlockPos(3, 0, -1), new BlockPos(-3, 0, -2), new BlockPos(-2, 0, -2), new BlockPos(-1, 0, -2), new BlockPos(-1, 1, 0), new BlockPos(0, 1, 0), new BlockPos(-2, 1, -1), new BlockPos(-1, 1, -1), new BlockPos(-1, -1, 0), new BlockPos(0, -1, 0), new BlockPos(-2, -1, -1), new BlockPos(-1, -1, -1)};
        sweep2 = new BlockPos[]{new BlockPos(-2, 0, 0), new BlockPos(-1, 0, 0), new BlockPos(0, 0, 0), new BlockPos(1, 0, 0), new BlockPos(2, 0, 0), new BlockPos(3, 0, 0), new BlockPos(-1, 0, 1), new BlockPos(0, 0, 1), new BlockPos(1, 0, 1), new BlockPos(2, 0, 1), new BlockPos(-2, 0, -1), new BlockPos(-1, 0, -1), new BlockPos(0, 0, -1), new BlockPos(4, 0, -1), new BlockPos(-1, 1, 0), new BlockPos(0, 1, 0), new BlockPos(1, 1, 0), new BlockPos(-1, -1, 0), new BlockPos(0, -1, 0), new BlockPos(1, -1, 0)};
    }
}

