/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.module;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import se.mickelus.tetra.data.DataManager;
import se.mickelus.tetra.items.modular.ItemModular;
import se.mickelus.tetra.module.ItemModule;
import se.mickelus.tetra.module.ItemModuleMajor;
import se.mickelus.tetra.module.ModuleRegistry;
import se.mickelus.tetra.module.ReplacementDefinition;
import se.mickelus.tetra.module.SchemaRegistry;
import se.mickelus.tetra.module.data.EnchantmentMapping;
import se.mickelus.tetra.module.schema.UpgradeSchema;

public class ItemUpgradeRegistry {
    private static final Logger logger = LogManager.getLogger();
    public static ItemUpgradeRegistry instance;
    private List<Function<ItemStack, ItemStack>> replacementFunctions;
    private List<ReplacementDefinition> replacementDefinitions;

    public ItemUpgradeRegistry() {
        instance = this;
        this.replacementFunctions = new ArrayList<Function<ItemStack, ItemStack>>();
        this.replacementDefinitions = Collections.emptyList();
        DataManager.replacementData.onReload(() -> {
            this.replacementDefinitions = DataManager.replacementData.getData().values().stream().flatMap(Arrays::stream).filter(replacementDefinition -> replacementDefinition.predicate != null).collect(Collectors.toList());
        });
    }

    public UpgradeSchema[] getAvailableSchemas(PlayerEntity player, ItemStack itemStack) {
        return (UpgradeSchema[])SchemaRegistry.instance.getAllSchemas().stream().filter(upgradeSchema -> this.playerHasSchema(player, itemStack, (UpgradeSchema)upgradeSchema)).filter(upgradeSchema -> upgradeSchema.isApplicableForItem(itemStack)).toArray(UpgradeSchema[]::new);
    }

    public UpgradeSchema[] getSchemas(String slot) {
        return (UpgradeSchema[])SchemaRegistry.instance.getAllSchemas().stream().filter(upgradeSchema -> upgradeSchema.isApplicableForSlot(slot, ItemStack.field_190927_a)).toArray(UpgradeSchema[]::new);
    }

    public UpgradeSchema getSchema(String key) {
        return SchemaRegistry.instance.getSchema(new ResourceLocation("tetra", key));
    }

    public boolean playerHasSchema(PlayerEntity player, ItemStack targetStack, UpgradeSchema schema) {
        return schema.isVisibleForPlayer(player, targetStack);
    }

    public void registerReplacementFunction(Function<ItemStack, ItemStack> replacementFunction) {
        this.replacementFunctions.add(replacementFunction);
    }

    public ItemStack getReplacement(ItemStack itemStack) {
        for (ReplacementDefinition replacementDefinition : this.replacementDefinitions) {
            if (!replacementDefinition.predicate.func_192493_a(itemStack)) continue;
            ItemStack replacementStack = replacementDefinition.itemStack.func_77946_l();
            replacementStack.func_196085_b(itemStack.func_77952_i());
            this.transferEnchantments(itemStack, replacementStack);
            return replacementStack;
        }
        for (Function function : this.replacementFunctions) {
            ItemStack replacementStack = (ItemStack)function.apply(itemStack);
            if (replacementStack == null) continue;
            return replacementStack;
        }
        return ItemStack.field_190927_a;
    }

    private void transferEnchantments(ItemStack sourceStack, ItemStack modularStack) {
        if (modularStack.func_77973_b() instanceof ItemModular) {
            ItemModular item = (ItemModular)modularStack.func_77973_b();
            Map enchantments = EnchantmentHelper.func_82781_a((ItemStack)sourceStack);
            for (Map.Entry entry : enchantments.entrySet()) {
                for (EnchantmentMapping mapping : instance.getEnchantmentMappings((Enchantment)entry.getKey())) {
                    ItemModuleMajor[] modules = (ItemModuleMajor[])Arrays.stream(item.getMajorModules(modularStack)).filter(module -> module.acceptsImprovement(mapping.improvement)).toArray(ItemModuleMajor[]::new);
                    if (modules.length <= 0) continue;
                    float level = 1.0f * (float)((Integer)entry.getValue()).intValue() / (float)modules.length / mapping.multiplier;
                    for (int i = 0; i < modules.length; ++i) {
                        if (i == 0) {
                            if (!modules[i].acceptsImprovementLevel(mapping.improvement, (int)Math.ceil(level))) continue;
                            modules[i].addImprovement(modularStack, mapping.improvement, (int)Math.ceil(level));
                            continue;
                        }
                        if (!modules[i].acceptsImprovementLevel(mapping.improvement, (int)level)) continue;
                        modules[i].addImprovement(modularStack, mapping.improvement, (int)level);
                    }
                }
            }
        }
    }

    public EnchantmentMapping[] getEnchantmentMappings(String improvement) {
        return (EnchantmentMapping[])DataManager.enchantmentData.getData().values().stream().flatMap(Arrays::stream).filter(mapping -> mapping.enchantment != null).filter(mapping -> improvement.equals(mapping.improvement)).filter(mapping -> mapping.apply).toArray(EnchantmentMapping[]::new);
    }

    public EnchantmentMapping[] getEnchantmentMappings(Enchantment enchantment) {
        return (EnchantmentMapping[])DataManager.enchantmentData.getData().values().stream().flatMap(Arrays::stream).filter(mapping -> mapping.enchantment != null).filter(mapping -> enchantment.equals(mapping.enchantment)).filter(mapping -> mapping.extract).toArray(EnchantmentMapping[]::new);
    }

    public ItemModule getModule(String key) {
        return ModuleRegistry.instance.getModule(new ResourceLocation("tetra", key));
    }

    public Collection<ItemModule> getAllModules() {
        return ModuleRegistry.instance.getAllModules();
    }
}

