/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.module;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.concurrent.CompletableFuture;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.ISuggestionProvider;
import net.minecraft.command.arguments.ItemArgument;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemFrameEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import se.mickelus.tetra.items.modular.ItemModular;
import se.mickelus.tetra.module.ItemModule;
import se.mickelus.tetra.module.ItemUpgradeRegistry;
import se.mickelus.tetra.module.data.ModuleVariantData;

public class ModuleDevCommand {
    private static final Logger logger = LogManager.getLogger();

    public static void register(CommandDispatcher<CommandSource> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"tmdev").requires(source -> source.func_197034_c(2))).then(Commands.func_197056_a((String)"item", (ArgumentType)ItemArgument.func_197317_a()).then(Commands.func_197056_a((String)"module", (ArgumentType)StringArgumentType.greedyString()).suggests(ModuleDevCommand::getModuleSuggestions).executes(ModuleDevCommand::run))));
    }

    private static int run(CommandContext<CommandSource> context) throws CommandSyntaxException {
        BlockPos pos = new BlockPos(((CommandSource)context.getSource()).func_197036_d());
        ServerWorld world = ((CommandSource)context.getSource()).func_197023_e();
        ItemStack baseStack = ItemUpgradeRegistry.instance.getReplacement(ItemArgument.func_197316_a(context, (String)"item").func_197320_a(1, false));
        ItemModule module = ItemUpgradeRegistry.instance.getModule(StringArgumentType.getString(context, (String)"module"));
        ModuleVariantData[] data = module.getVariantData();
        for (int i = 0; i < data.length; ++i) {
            ItemStack itemStack = baseStack.func_77946_l();
            module.addModule(itemStack, data[i].key, (PlayerEntity)((CommandSource)context.getSource()).func_197035_h());
            ItemModular.updateIdentifier(itemStack);
            ModuleDevCommand.plopFrame((World)world, pos.func_177982_a(i / 5, i % 5, 0), itemStack, module.getName(itemStack));
        }
        return 1;
    }

    private static void plopFrame(World world, BlockPos pos, ItemStack itemStack, String label) {
        itemStack.func_200302_a((ITextComponent)new StringTextComponent(label));
        ItemFrameEntity itemFrame = new ItemFrameEntity(world, pos, Direction.SOUTH);
        itemFrame.func_82334_a(itemStack);
        world.func_217376_c((Entity)itemFrame);
    }

    private static CompletableFuture<Suggestions> getModuleSuggestions(CommandContext context, SuggestionsBuilder builder) {
        return ISuggestionProvider.func_197008_a((String[])((String[])ItemUpgradeRegistry.instance.getAllModules().stream().map(ItemModule::getKey).toArray(String[]::new)), (SuggestionsBuilder)builder);
    }
}

