/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.module;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import se.mickelus.tetra.data.DataManager;
import se.mickelus.tetra.module.RepairRegistry;
import se.mickelus.tetra.module.schema.ConfigSchema;
import se.mickelus.tetra.module.schema.InvalidSchemaException;
import se.mickelus.tetra.module.schema.SchemaDefinition;
import se.mickelus.tetra.module.schema.UpgradeSchema;

public class SchemaRegistry {
    private static final Logger logger = LogManager.getLogger();
    public static SchemaRegistry instance;
    private Map<ResourceLocation, UpgradeSchema> schemaMap;
    private Map<ResourceLocation, UpgradeSchema> dynamicSchemas;

    public SchemaRegistry() {
        instance = this;
        this.schemaMap = Collections.emptyMap();
        this.dynamicSchemas = new HashMap<ResourceLocation, UpgradeSchema>();
        DataManager.schemaData.onReload(() -> this.setupSchemas(DataManager.schemaData.getData()));
    }

    public void registerSchema(UpgradeSchema schema) {
        this.dynamicSchemas.put(new ResourceLocation("tetra", schema.getKey()), schema);
    }

    private void setupSchemas(Map<ResourceLocation, SchemaDefinition> data) {
        this.schemaMap = data.entrySet().stream().filter(entry -> this.validateSchemaDefinition((ResourceLocation)entry.getKey(), (SchemaDefinition)entry.getValue())).flatMap(entry -> this.createSchemas((ResourceLocation)entry.getKey(), (SchemaDefinition)entry.getValue()).stream()).filter(entry -> entry.getRight() != null).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        this.dynamicSchemas.forEach((identifier, schema) -> this.schemaMap.put((ResourceLocation)identifier, (UpgradeSchema)schema));
        RepairRegistry.instance.injectFromSchemas(data.values());
    }

    private boolean validateSchemaDefinition(ResourceLocation identifier, SchemaDefinition definition) {
        if (definition == null) {
            logger.warn("Failed to create schema from schema definition '{}': Data is null (probably due to it failing to parse)", (Object)identifier);
            return false;
        }
        if (definition.slots == null || definition.slots.length < 1) {
            logger.warn("Failed to create schema from schema definition '{}': Slots field is empty", (Object)identifier);
            return false;
        }
        return true;
    }

    private Collection<Pair<ResourceLocation, ConfigSchema>> createSchemas(ResourceLocation identifier, SchemaDefinition definition) {
        if (definition.slots.length == definition.keySuffixes.length) {
            ArrayList<Pair<ResourceLocation, ConfigSchema>> result = new ArrayList<Pair<ResourceLocation, ConfigSchema>>(definition.slots.length);
            for (int i = 0; i < definition.slots.length; ++i) {
                try {
                    ResourceLocation suffixedIdentifier = new ResourceLocation(identifier.func_110624_b(), identifier.func_110623_a() + definition.keySuffixes[i]);
                    result.add((Pair<ResourceLocation, ConfigSchema>)new ImmutablePair((Object)suffixedIdentifier, (Object)new ConfigSchema(definition, definition.keySuffixes[i], definition.slots[i])));
                    continue;
                }
                catch (InvalidSchemaException e) {
                    e.printMessage();
                }
            }
            return result;
        }
        try {
            return Collections.singletonList(new ImmutablePair((Object)identifier, (Object)new ConfigSchema(definition)));
        }
        catch (InvalidSchemaException e) {
            e.printMessage();
            return Collections.singletonList(new ImmutablePair((Object)identifier, null));
        }
    }

    public UpgradeSchema getSchema(ResourceLocation identifier) {
        return this.schemaMap.get(identifier);
    }

    public Collection<UpgradeSchema> getAllSchemas() {
        return this.schemaMap.values();
    }
}

