/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.module.schema;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.stream.Stream;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraftforge.common.Tags;
import org.apache.commons.lang3.ArrayUtils;
import se.mickelus.tetra.capabilities.Capability;
import se.mickelus.tetra.items.modular.ItemModular;
import se.mickelus.tetra.module.ItemModuleMajor;
import se.mickelus.tetra.module.data.GlyphData;
import se.mickelus.tetra.module.improvement.DestabilizationEffect;
import se.mickelus.tetra.module.schema.OutcomePreview;
import se.mickelus.tetra.module.schema.SchemaType;
import se.mickelus.tetra.module.schema.UpgradeSchema;
import se.mickelus.tetra.util.CastOptional;

public class CleanseSchema
implements UpgradeSchema {
    private static final String localizationPrefix = "tetra/schema/";
    private static final String key = "cleanse";
    private static final String nameSuffix = ".name";
    private static final String descriptionSuffix = ".description";
    private static final String slotLabel = "item.minecraft.lapis_lazuli";
    private GlyphData glyph = new GlyphData("textures/gui/workbench.png", 80, 32);

    @Override
    public String getKey() {
        return key;
    }

    @Override
    public String getName() {
        return I18n.func_135052_a((String)"tetra/schema/cleanse.name", (Object[])new Object[0]);
    }

    @Override
    public String getDescription(ItemStack itemStack) {
        return I18n.func_135052_a((String)"tetra/schema/cleanse.description", (Object[])new Object[0]);
    }

    @Override
    public int getNumMaterialSlots() {
        return 1;
    }

    @Override
    public String getSlotName(ItemStack itemStack, int index) {
        return I18n.func_135052_a((String)slotLabel, (Object[])new Object[0]);
    }

    @Override
    public ItemStack[] getSlotPlaceholders(ItemStack itemStack, int index) {
        return new ItemStack[]{Items.field_196128_bn.func_190903_i()};
    }

    @Override
    public int getRequiredQuantity(ItemStack itemStack, int index, ItemStack materialStack) {
        return 1;
    }

    @Override
    public boolean acceptsMaterial(ItemStack itemStack, String itemSlot, int index, ItemStack materialStack) {
        return materialStack.func_77973_b().func_206844_a(Tags.Items.GEMS_LAPIS);
    }

    @Override
    public boolean isMaterialsValid(ItemStack itemStack, String itemSlot, ItemStack[] materials) {
        return this.acceptsMaterial(itemStack, itemSlot, 0, materials[0]);
    }

    @Override
    public boolean isApplicableForItem(ItemStack itemStack) {
        return true;
    }

    @Override
    public boolean isApplicableForSlot(String slot, ItemStack targetStack) {
        String[] destabilizationKeys = DestabilizationEffect.getKeys();
        return CastOptional.cast(targetStack.func_77973_b(), ItemModular.class).map(item -> item.getModuleFromSlot(targetStack, slot)).filter(module -> module instanceof ItemModuleMajor).map(module -> (ItemModuleMajor)module).map(module -> Arrays.stream(module.getImprovements(targetStack))).orElse(Stream.empty()).anyMatch(improvement -> ArrayUtils.contains((Object[])destabilizationKeys, (Object)improvement.key));
    }

    @Override
    public boolean canApplyUpgrade(PlayerEntity player, ItemStack itemStack, ItemStack[] materials, String slot, int[] availableCapabilities) {
        return this.isMaterialsValid(itemStack, slot, materials) && (player.func_184812_l_() || player.field_71068_ca >= this.getExperienceCost(itemStack, materials, slot));
    }

    @Override
    public boolean isIntegrityViolation(PlayerEntity player, ItemStack itemStack, ItemStack[] materials, String slot) {
        return false;
    }

    @Override
    public ItemStack applyUpgrade(ItemStack itemStack, ItemStack[] materials, boolean consumeMaterials, String slot, PlayerEntity player) {
        ItemStack upgradedStack = itemStack.func_77946_l();
        String[] destabilizationKeys = DestabilizationEffect.getKeys();
        CastOptional.cast(itemStack.func_77973_b(), ItemModular.class).map(item -> item.getModuleFromSlot(itemStack, slot)).filter(module -> module instanceof ItemModuleMajor).map(module -> (ItemModuleMajor)module).ifPresent(module -> Arrays.stream(destabilizationKeys).forEach(key -> module.removeImprovement(upgradedStack, (String)key)));
        if (consumeMaterials) {
            materials[0].func_190918_g(1);
        }
        return upgradedStack;
    }

    @Override
    public boolean checkCapabilities(ItemStack targetStack, ItemStack[] materials, int[] availableCapabilities) {
        return true;
    }

    @Override
    public Collection<Capability> getRequiredCapabilities(ItemStack targetStack, ItemStack[] materials) {
        return Collections.emptyList();
    }

    @Override
    public int getRequiredCapabilityLevel(ItemStack targetStack, ItemStack[] materials, Capability capability) {
        return 0;
    }

    @Override
    public int getExperienceCost(ItemStack targetStack, ItemStack[] materials, String slot) {
        String[] destabilizationKeys = DestabilizationEffect.getKeys();
        int cost = CastOptional.cast(targetStack.func_77973_b(), ItemModular.class).map(item -> item.getModuleFromSlot(targetStack, slot)).filter(module -> module instanceof ItemModuleMajor).map(module -> (ItemModuleMajor)module).map(module -> Arrays.stream(module.getImprovements(targetStack))).orElse(Stream.empty()).filter(improvement -> ArrayUtils.contains((Object[])destabilizationKeys, (Object)improvement.key)).mapToInt(improvement -> improvement.level + 1).sum();
        return cost += CastOptional.cast(targetStack.func_77973_b(), ItemModular.class).map(item -> item.getModuleFromSlot(targetStack, slot)).filter(module -> module instanceof ItemModuleMajor).map(module -> (ItemModuleMajor)module).map(module -> Math.max(3, -module.getMagicCapacity(targetStack))).orElse(3).intValue();
    }

    @Override
    public SchemaType getType() {
        return SchemaType.other;
    }

    @Override
    public GlyphData getGlyph() {
        return this.glyph;
    }

    @Override
    public OutcomePreview[] getPreviews(ItemStack targetStack, String slot) {
        return new OutcomePreview[0];
    }

    @Override
    public float getSeverity(ItemStack itemStack, ItemStack[] materials, String slot) {
        return 0.0f;
    }
}

