/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.module.schema;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.lang.reflect.Type;
import net.minecraft.advancements.criterion.ItemPredicate;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class Material {
    public ItemPredicate predicate;
    public int count = 1;
    private ItemStack itemStack;
    private ResourceLocation tagLocation;

    @OnlyIn(value=Dist.CLIENT)
    public ITextComponent[] getDisplayNames() {
        if (this.itemStack != null) {
            return new ITextComponent[]{this.itemStack.func_200301_q()};
        }
        if (this.tagLocation != null) {
            return (ITextComponent[])ItemTags.func_199903_a().func_199915_b(this.tagLocation).func_199885_a().stream().map(item -> item.func_200295_i(item.func_190903_i())).toArray(ITextComponent[]::new);
        }
        return new ITextComponent[]{new StringTextComponent("Unknown material")};
    }

    @OnlyIn(value=Dist.CLIENT)
    public ItemStack[] getApplicableItemStacks() {
        if (this.itemStack != null && !this.itemStack.func_190926_b()) {
            return new ItemStack[]{this.itemStack};
        }
        if (this.tagLocation != null) {
            return (ItemStack[])ItemTags.func_199903_a().func_199915_b(this.tagLocation).func_199885_a().stream().map(Item::func_190903_i).map(this::setCount).toArray(ItemStack[]::new);
        }
        return new ItemStack[0];
    }

    private ItemStack setCount(ItemStack itemStack) {
        itemStack.func_190920_e(this.count);
        return itemStack;
    }

    public static class MaterialDeserializer
    implements JsonDeserializer<Material> {
        public Material deserialize(JsonElement element, Type typeOfT, JsonDeserializationContext context) {
            Material material = new Material();
            if (element != null && !element.isJsonNull()) {
                JsonObject jsonObject = JSONUtils.func_151210_l((JsonElement)element, (String)"material");
                material.count = JSONUtils.func_151208_a((JsonObject)jsonObject, (String)"count", (int)1);
                jsonObject.remove("count");
                if (jsonObject.has("item")) {
                    Item item = JSONUtils.func_188180_i((JsonObject)jsonObject, (String)"item");
                    material.itemStack = new ItemStack((IItemProvider)item, material.count);
                    if (jsonObject.has("nbt")) {
                        try {
                            CompoundNBT compoundnbt = JsonToNBT.func_180713_a((String)JSONUtils.func_151206_a((JsonElement)jsonObject.get("nbt"), (String)"nbt"));
                            material.itemStack.func_77982_d(compoundnbt);
                        }
                        catch (CommandSyntaxException exception) {
                            throw new JsonSyntaxException("Encountered invalid nbt tag when parsing material: " + exception.getMessage());
                        }
                    }
                } else if (jsonObject.has("tag")) {
                    material.tagLocation = new ResourceLocation(JSONUtils.func_151200_h((JsonObject)jsonObject, (String)"tag"));
                }
                try {
                    material.predicate = ItemPredicate.func_192492_a((JsonElement)element);
                }
                catch (JsonSyntaxException jsonSyntaxException) {
                    // empty catch block
                }
            }
            return material;
        }
    }
}

