/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.mgui.gui;

import com.mojang.blaze3d.platform.GlStateManager;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ResourceLocation;
import se.mickelus.mgui.gui.GuiElement;

public class GuiTextureOffset
extends GuiElement {
    private ResourceLocation textureLocation;
    private int textureX;
    private int textureY;
    protected int color = 0xFFFFFF;

    public GuiTextureOffset(int x, int y, int width, int height, String texture) {
        this(x, y, width, height, new ResourceLocation("mgui", texture));
    }

    public GuiTextureOffset(int x, int y, int width, int height, int textureX, int textureY, String texture) {
        this(x, y, width, height, textureX, textureY, new ResourceLocation("mgui", texture));
    }

    public GuiTextureOffset(int x, int y, int width, int height, ResourceLocation textureLocation) {
        this(x, y, width, height, 0, 0, textureLocation);
    }

    public GuiTextureOffset(int x, int y, int width, int height, int textureX, int textureY, ResourceLocation textureLocation) {
        super(x, y, width + 1, height + 1);
        this.textureX = textureX;
        this.textureY = textureY;
        this.textureLocation = textureLocation;
    }

    @Override
    public void draw(int refX, int refY, int screenWidth, int screenHeight, int mouseX, int mouseY, float opacity) {
        super.draw(refX, refY, screenWidth, screenHeight, mouseX, mouseY, opacity);
        GlStateManager.pushMatrix();
        Minecraft.func_71410_x().func_110434_K().func_110577_a(this.textureLocation);
        GlStateManager.color4f((float)((float)(this.color >> 16 & 0xFF) / 255.0f), (float)((float)(this.color >> 8 & 0xFF) / 255.0f), (float)((float)(this.color & 0xFF) / 255.0f), (float)(opacity * this.getOpacity() * 255.0f));
        GlStateManager.enableBlend();
        GlStateManager.translatef((float)0.5f, (float)0.5f, (float)0.0f);
        this.blit(refX + this.x, refY + this.y, this.textureX, this.textureY, this.width - 1, this.height - 1);
        GlStateManager.popMatrix();
    }

    public int getColor() {
        return this.color;
    }

    public void setColor(int color) {
        this.color = color;
    }
}

