/*
 * Decompiled with CFR 0.152.
 */
package tterrag.treesimulator;

import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.commons.lang3.tuple.Pair;
import tterrag.treesimulator.PacketHandlerTGS;
import tterrag.treesimulator.TickHandlerTGS;

@Mod(value="treegrowingsimulator")
public class TreeSimulator {
    static final ForgeConfigSpec serverSpec;
    public static final ServerConfigs SERVER_CONFIGS;
    static final ForgeConfigSpec commonSpec;
    public static final CommonConfigs COMMON_CONFIGS;
    public static final String CHANNEL = "treegrowingsimulator";

    public TreeSimulator() {
        IEventBus modBus = FMLJavaModLoadingContext.get().getModEventBus();
        modBus.addListener(this::init);
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, serverSpec);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, commonSpec);
    }

    private void init(FMLCommonSetupEvent event) {
        PacketHandlerTGS.init();
        MinecraftForge.EVENT_BUS.register((Object)new TickHandlerTGS());
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(ServerConfigs::new);
        serverSpec = (ForgeConfigSpec)specPair.getRight();
        SERVER_CONFIGS = (ServerConfigs)specPair.getLeft();
        specPair = new ForgeConfigSpec.Builder().configure(CommonConfigs::new);
        commonSpec = (ForgeConfigSpec)specPair.getRight();
        COMMON_CONFIGS = (CommonConfigs)specPair.getLeft();
    }

    public static class CommonConfigs {
        public final ForgeConfigSpec.BooleanValue showParticles;
        public final ForgeConfigSpec.BooleanValue allTheParticles;

        CommonConfigs(ForgeConfigSpec.Builder builder) {
            this.showParticles = builder.comment("Show bonemeal particles when appropriate. Not sure why you would turn this off, but eh.").define("showParticles", true);
            this.allTheParticles = builder.comment("Will spawn a LOT more particles for actions near saplings.").define("allTheParticles", true);
        }
    }

    public static class ServerConfigs {
        public final ForgeConfigSpec.IntValue waitTime;

        ServerConfigs(ForgeConfigSpec.Builder builder) {
            this.waitTime = builder.comment("The amount of ticks (times 5) you must be crouching or sprinting before bonemeal is applied.").defineInRange("waitTime", 25, 1, 1000000);
        }
    }
}

