/*
 * Decompiled with CFR 0.152.
 */
package cn.davidma.tinymobfarm.common.block;

import cn.davidma.tinymobfarm.client.gui.InteractionObjectMobFarm;
import cn.davidma.tinymobfarm.common.tileentity.TileEntityMobFarm;
import cn.davidma.tinymobfarm.core.EnumMobFarm;
import cn.davidma.tinymobfarm.core.Reference;
import io.netty.util.internal.shaded.org.jctools.queues.MessagePassingQueue;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IInteractionObject;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;

public class BlockMobFarm
extends Block {
    public static final DirectionProperty FACING = BlockHorizontal.field_185512_D;
    private static final VoxelShape BOUNDING_BOX = Block.func_208617_a((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)14.0, (double)15.0);
    private EnumMobFarm mobFarmData;

    public BlockMobFarm(EnumMobFarm mobFarmData) {
        super(Block.Properties.func_200950_a((Block)mobFarmData.getBaseBlock()));
        this.setRegistryName(Reference.getLocation(mobFarmData.getRegistryName()));
        this.func_180632_j((IBlockState)((IBlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)FACING, (Comparable)EnumFacing.NORTH));
        this.mobFarmData = mobFarmData;
    }

    public MessagePassingQueue.Consumer<List<ITextComponent>> getTooltipBuilder() {
        return this.mobFarmData::addTooltip;
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    protected void func_206840_a(StateContainer.Builder<Block, IBlockState> builder) {
        builder.func_206894_a(new IProperty[]{FACING});
    }

    public IBlockState func_196258_a(BlockItemUseContext context) {
        EnumFacing facing = context.func_195992_f().func_176734_d();
        return (IBlockState)this.func_176223_P().func_206870_a((IProperty)FACING, (Comparable)facing);
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        super.func_180633_a(world, pos, state, placer, stack);
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof TileEntityMobFarm) {
            TileEntityMobFarm tileEntityMobFarm = (TileEntityMobFarm)tileEntity;
            tileEntityMobFarm.setMobFarmData(this.mobFarmData);
            tileEntityMobFarm.updateRedstone();
        }
    }

    public boolean func_196250_a(IBlockState state, World world, BlockPos pos, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        TileEntity tileEntity;
        if (!world.func_201670_d() && player instanceof EntityPlayerMP && (tileEntity = world.func_175625_s(pos)) instanceof TileEntityMobFarm) {
            NetworkHooks.openGui((EntityPlayerMP)((EntityPlayerMP)player), (IInteractionObject)new InteractionObjectMobFarm((TileEntityMobFarm)tileEntity), buffer -> buffer.func_179255_a(pos));
        }
        return true;
    }

    public IBlockState func_196271_a(IBlockState state, EnumFacing facing, IBlockState facingState, IWorld world, BlockPos currentPos, BlockPos facingPos) {
        TileEntity tileEntity = world.func_175625_s(currentPos);
        if (tileEntity instanceof TileEntityMobFarm) {
            TileEntityMobFarm tileEntityMobFarm = (TileEntityMobFarm)tileEntity;
            tileEntityMobFarm.updateRedstone();
            tileEntityMobFarm.saveAndSync();
        }
        return state;
    }

    public void func_176208_a(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        ItemStack lasso;
        TileEntity tileEntity = world.func_175625_s(pos);
        if (!world.func_201670_d() && tileEntity instanceof TileEntityMobFarm && !(lasso = ((TileEntityMobFarm)tileEntity).getLasso()).func_190926_b()) {
            EntityItem drop = new EntityItem(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.3, (double)pos.func_177952_p() + 0.5, lasso);
            world.func_72838_d((Entity)drop);
        }
        super.func_176208_a(world, pos, state, player);
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public TileEntity createTileEntity(IBlockState state, IBlockReader world) {
        return new TileEntityMobFarm();
    }

    public VoxelShape func_196244_b(IBlockState state, IBlockReader worldIn, BlockPos pos) {
        return BOUNDING_BOX;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public int func_200011_d(IBlockState state, IBlockReader worldIn, BlockPos pos) {
        return 0;
    }

    public BlockFaceShape func_193383_a(IBlockReader worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }
}

