/*
 * Decompiled with CFR 0.152.
 */
package cn.davidma.tinymobfarm.common.item;

import cn.davidma.tinymobfarm.common.TinyMobFarm;
import cn.davidma.tinymobfarm.core.Reference;
import cn.davidma.tinymobfarm.core.util.Config;
import cn.davidma.tinymobfarm.core.util.EntityHelper;
import cn.davidma.tinymobfarm.core.util.Msg;
import cn.davidma.tinymobfarm.core.util.NBTHelper;
import java.util.List;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.INBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;

public class ItemLasso
extends Item {
    public ItemLasso(Item.Properties properties) {
        super(properties.func_200916_a(TinyMobFarm.creativeTab));
        this.setRegistryName(Reference.getLocation("lasso"));
    }

    public int getMaxDamage(ItemStack stack) {
        return Config.LASSO_DURABILITY;
    }

    public int getItemStackLimit(ItemStack stack) {
        return 1;
    }

    public boolean func_111207_a(ItemStack stack, EntityPlayer player, EntityLivingBase target, EnumHand hand) {
        if (NBTHelper.hasMob(stack) || !target.func_70089_S() || !(target instanceof EntityLiving)) {
            return false;
        }
        NBTTagCompound nbt = NBTHelper.getBaseTag(stack);
        if (!target.func_184222_aU()) {
            if (!player.field_70170_p.field_72995_K) {
                Msg.tellPlayer(player, "tinymobfarm.error.cannot_capture_boss");
            }
            return true;
        }
        if (EntityHelper.isMobBlacklisted((EntityLiving)target)) {
            if (!player.field_70170_p.field_72995_K) {
                Msg.tellPlayer(player, "tinymobfarm.error.blacklisted_mob");
            }
            return true;
        }
        if (!player.field_70170_p.func_201670_d()) {
            NBTTagCompound mobData = target.serializeNBT();
            mobData.func_74782_a("Rotation", (INBTBase)NBTHelper.createNBTList(new INBTBase[]{new NBTTagDouble(0.0), new NBTTagDouble(0.0)}));
            nbt.func_74782_a("mobData", (INBTBase)mobData);
            nbt.func_74778_a("mobName", target.func_200200_C_().func_150261_e());
            nbt.func_74778_a("mobLootTableLocation", EntityHelper.getLootTableLocation((EntityLiving)target));
            nbt.func_74780_a("mobHealth", (double)Math.round(target.func_110143_aJ() * 10.0f) / 10.0);
            nbt.func_74780_a("mobMaxHealth", (double)target.func_110138_aP());
            nbt.func_74757_a("mobHostile", target.isCreatureType(EnumCreatureType.MONSTER, false));
            if (player.func_184812_l_()) {
                ItemStack newLasso = new ItemStack((IItemProvider)this);
                NBTHelper.setBaseTag(newLasso, nbt);
                player.func_191521_c(newLasso);
            }
            target.func_70106_y();
            player.field_71071_by.func_70296_d();
        }
        return true;
    }

    public EnumActionResult func_195939_a(ItemUseContext context) {
        EntityPlayer player = context.func_195999_j();
        ItemStack stack = context.func_195996_i();
        EnumFacing facing = context.func_196000_l();
        BlockPos pos = context.func_195995_a().func_177972_a(facing);
        World world = context.func_195991_k();
        if (!NBTHelper.hasMob(stack)) {
            return EnumActionResult.FAIL;
        }
        if (!player.func_175151_a(pos, facing, stack)) {
            return EnumActionResult.FAIL;
        }
        if (!context.func_195991_k().func_201670_d()) {
            NBTTagCompound nbt = NBTHelper.getBaseTag(stack);
            NBTTagCompound mobData = nbt.func_74775_l("mobData");
            NBTTagDouble x = new NBTTagDouble((double)pos.func_177958_n() + 0.5);
            NBTTagDouble y = new NBTTagDouble((double)pos.func_177956_o());
            NBTTagDouble z = new NBTTagDouble((double)pos.func_177952_p() + 0.5);
            NBTTagList mobPos = NBTHelper.createNBTList(new INBTBase[]{x, y, z});
            mobData.func_74782_a("Pos", (INBTBase)mobPos);
            Entity mob = EntityType.func_200716_a((NBTTagCompound)mobData, (World)world);
            if (mob != null) {
                world.func_72838_d(mob);
            }
            stack.func_196083_e("capturedMob");
            stack.func_77972_a(1, (EntityLivingBase)player);
        }
        return EnumActionResult.SUCCESS;
    }

    public void func_77624_a(ItemStack stack, World world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        if (NBTHelper.hasMob(stack)) {
            NBTTagCompound nbt = NBTHelper.getBaseTag(stack);
            String name = nbt.func_74779_i("mobName");
            double health = nbt.func_74769_h("mobHealth");
            double maxHealth = nbt.func_74769_h("mobMaxHealth");
            tooltip.add((ITextComponent)Msg.tooltip("tinymobfarm.tooltip.release_mob.key", new Object[0]));
            tooltip.add((ITextComponent)Msg.tooltip("tinymobfarm.tooltip.mob_name.key", name));
            tooltip.add((ITextComponent)Msg.tooltip("tinymobfarm.tooltip.health.key", health, maxHealth));
            if (nbt.func_74767_n("mobHostile")) {
                tooltip.add((ITextComponent)Msg.tooltip("tinymobfarm.tooltip.hostile.key", new Object[0]));
            }
        } else {
            tooltip.add((ITextComponent)Msg.tooltip("tinymobfarm.tooltip.capture.key", new Object[0]));
        }
    }

    public boolean func_77636_d(ItemStack stack) {
        return NBTHelper.hasMob(stack);
    }
}

