/*
 * Decompiled with CFR 0.152.
 */
package cn.davidma.tinymobfarm.common.tileentity;

import cn.davidma.tinymobfarm.common.TinyMobFarm;
import cn.davidma.tinymobfarm.core.EnumMobFarm;
import cn.davidma.tinymobfarm.core.util.EntityHelper;
import cn.davidma.tinymobfarm.core.util.FakePlayerHelper;
import cn.davidma.tinymobfarm.core.util.NBTHelper;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.INBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;

public class TileEntityMobFarm
extends TileEntity
implements ITickable {
    private ItemStackHandler inventory = new ItemStackHandler(1);
    private EnumMobFarm mobFarmData;
    private EntityLiving model;
    private EnumFacing modelFacing;
    private int currProgress;
    private boolean powered;
    private boolean shouldUpdate;

    public TileEntityMobFarm(TileEntityType<?> tileEntityTypeIn) {
        super(tileEntityTypeIn);
    }

    public TileEntityMobFarm() {
        super(TinyMobFarm.tileEntityMobFarm);
    }

    public void func_73660_a() {
        if (this.shouldUpdate) {
            this.updateModel();
            this.updateRedstone();
            this.shouldUpdate = false;
        }
        if (this.isWorking()) {
            ++this.currProgress;
            if (!this.field_145850_b.func_201670_d() && this.mobFarmData != null && this.currProgress >= this.mobFarmData.getMaxProgress()) {
                this.currProgress = 0;
                this.generateDrops();
                FakePlayer daniel = FakePlayerHelper.getPlayer((WorldServer)this.field_145850_b);
                this.getLasso().func_77972_a(this.mobFarmData.getRandomDamage(this.field_145850_b.field_73012_v), (EntityLivingBase)daniel);
                this.saveAndSync();
            }
        } else {
            this.currProgress = 0;
        }
    }

    private void generateDrops() {
        ItemStack lasso = this.getLasso();
        String lootTableLocation = NBTHelper.getBaseTag(lasso).func_74779_i("mobLootTableLocation");
        if (lootTableLocation.isEmpty()) {
            return;
        }
        List<ItemStack> drops = EntityHelper.generateLoot(new ResourceLocation(lootTableLocation), this.field_145850_b);
        for (EnumFacing facing : EnumFacing.values()) {
            TileEntity tileEntity = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(facing));
            if (tileEntity == null) continue;
            LazyOptional capability = tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing.func_176734_d());
            capability.ifPresent(itemHandler -> {
                for (int i = 0; i < drops.size(); ++i) {
                    ItemStack remain = ItemHandlerHelper.insertItemStacked((IItemHandler)itemHandler, (ItemStack)((ItemStack)drops.get(i)), (boolean)false);
                    if (!remain.func_190926_b()) continue;
                    drops.remove(i);
                    --i;
                }
            });
            if (!drops.isEmpty()) continue;
            return;
        }
        for (ItemStack stack : drops) {
            EntityItem entityItem = new EntityItem(this.field_145850_b, (double)this.field_174879_c.func_177958_n() + 0.5, (double)(this.field_174879_c.func_177956_o() + 1), (double)this.field_174879_c.func_177952_p() + 0.5, stack);
            this.field_145850_b.func_72838_d((Entity)entityItem);
        }
    }

    private void updateModel() {
        if (this.field_145850_b.func_201670_d()) {
            if (this.getLasso().func_190926_b()) {
                this.model = null;
            } else {
                NBTTagCompound entityData;
                Entity newModel;
                NBTTagCompound nbt = NBTHelper.getBaseTag(this.getLasso());
                String mobName = nbt.func_74779_i("mobName");
                if ((this.model == null || !this.model.func_200200_C_().func_150261_e().equals(mobName)) && (newModel = EntityType.func_200716_a((NBTTagCompound)(entityData = nbt.func_74775_l("mobData")), (World)this.field_145850_b)) != null && newModel instanceof EntityLiving) {
                    this.model = (EntityLiving)newModel;
                    this.modelFacing = (EnumFacing)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)BlockHorizontal.field_185512_D);
                }
            }
        }
    }

    public boolean isWorking() {
        if (this.mobFarmData == null || this.getLasso().func_190926_b() || this.isPowered()) {
            return false;
        }
        return this.mobFarmData.isLassoValid(this.getLasso());
    }

    public void updateRedstone() {
        this.powered = this.field_145850_b.func_175687_A(this.field_174879_c) != 0;
    }

    public ItemStack getLasso() {
        return this.inventory.getStackInSlot(0);
    }

    public void setMobFarmData(EnumMobFarm mobFarmData) {
        this.mobFarmData = mobFarmData;
    }

    public boolean isPowered() {
        return this.powered;
    }

    @Deprecated
    public ItemStackHandler getInventory() {
        return this.inventory;
    }

    public double getScaledProgress() {
        if (this.mobFarmData == null) {
            return 0.0;
        }
        return (double)this.currProgress / (double)this.mobFarmData.getMaxProgress();
    }

    public EntityLiving getModel() {
        return this.model;
    }

    public EnumFacing getModelFacing() {
        return this.modelFacing;
    }

    public String getUnlocalizedName() {
        if (this.mobFarmData == null) {
            return "block.tinymobfarm.default_mob_farm";
        }
        return this.mobFarmData.getUnlocalizedName();
    }

    public void saveAndSync() {
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        this.field_145850_b.func_175704_b(this.field_174879_c, this.field_174879_c);
        this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 3);
        this.func_70296_d();
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.mobFarmData = EnumMobFarm.values()[nbt.func_74762_e("mobFarmData")];
        this.currProgress = nbt.func_74762_e("currProgress");
        this.inventory.deserializeNBT(nbt.func_74775_l("inventory"));
        this.shouldUpdate = true;
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        if (this.mobFarmData == null) {
            return nbt;
        }
        nbt.func_74768_a("mobFarmData", this.mobFarmData.ordinal());
        nbt.func_74768_a("currProgress", this.currProgress);
        nbt.func_74782_a("inventory", (INBTBase)this.inventory.serializeNBT());
        return super.func_189515_b(nbt);
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), 0, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        this.func_145839_a(packet.func_148857_g());
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public void handleUpdateTag(NBTTagCompound nbt) {
        this.func_145839_a(nbt);
    }
}

