/*
 * Decompiled with CFR 0.152.
 */
package cn.davidma.tinymobfarm.common.tileentity;

import cn.davidma.tinymobfarm.client.gui.ContainerMobFarm;
import cn.davidma.tinymobfarm.common.TinyMobFarm;
import cn.davidma.tinymobfarm.core.EnumMobFarm;
import cn.davidma.tinymobfarm.core.util.Config;
import cn.davidma.tinymobfarm.core.util.EntityHelper;
import cn.davidma.tinymobfarm.core.util.FakePlayerHelper;
import cn.davidma.tinymobfarm.core.util.NBTHelper;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;

public class TileEntityMobFarm
extends TileEntity
implements ITickableTileEntity,
INamedContainerProvider {
    private ItemStackHandler inventory = new ItemStackHandler(1);
    private EnumMobFarm mobFarmData;
    private LivingEntity model;
    private Direction modelFacing;
    private int currProgress;
    private boolean powered;
    private boolean shouldUpdate;

    public TileEntityMobFarm(TileEntityType<?> tileEntityTypeIn) {
        super(tileEntityTypeIn);
    }

    public TileEntityMobFarm() {
        super(TinyMobFarm.tileEntityMobFarm);
    }

    public void func_73660_a() {
        if (this.shouldUpdate) {
            this.updateModel();
            this.updateRedstone();
            this.shouldUpdate = false;
        }
        if (this.isWorking()) {
            ++this.currProgress;
            if (!this.field_145850_b.func_201670_d() && this.mobFarmData != null && this.currProgress >= this.mobFarmData.getMaxProgress()) {
                this.currProgress = 0;
                this.generateDrops();
                FakePlayer daniel = FakePlayerHelper.getPlayer((ServerWorld)this.field_145850_b);
                this.getLasso().func_222118_a(this.mobFarmData.getRandomDamage(this.field_145850_b.field_73012_v), (LivingEntity)daniel, wut -> {});
                this.saveAndSync();
            }
        } else {
            this.currProgress = 0;
        }
    }

    private void generateDrops() {
        ItemStack lasso = this.getLasso();
        String lootTableLocation = NBTHelper.getBaseTag(lasso).func_74779_i("mobLootTableLocation");
        if (lootTableLocation.isEmpty()) {
            return;
        }
        List<ItemStack> drops = EntityHelper.generateLoot(new ResourceLocation(lootTableLocation), this.field_145850_b, EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185304_p, (ItemStack)lasso));
        for (Direction facing : Direction.values()) {
            TileEntity tileEntity = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(facing));
            if (tileEntity == null) continue;
            LazyOptional capability = tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing.func_176734_d());
            capability.ifPresent(itemHandler -> {
                for (int i = 0; i < drops.size(); ++i) {
                    ItemStack remain = ItemHandlerHelper.insertItemStacked((IItemHandler)itemHandler, (ItemStack)((ItemStack)drops.get(i)), (boolean)false);
                    if (!remain.func_190926_b()) continue;
                    drops.remove(i);
                    --i;
                }
            });
            if (!drops.isEmpty()) continue;
            return;
        }
        if (Config.DISABLE_WHEN_CHEST_FULL) {
            return;
        }
        for (ItemStack stack : drops) {
            ItemEntity entityItem = new ItemEntity(this.field_145850_b, (double)this.field_174879_c.func_177958_n() + 0.5, (double)(this.field_174879_c.func_177956_o() + 1), (double)this.field_174879_c.func_177952_p() + 0.5, stack);
            this.field_145850_b.func_217376_c((Entity)entityItem);
        }
    }

    private void updateModel() {
        if (this.field_145850_b.func_201670_d()) {
            if (this.getLasso().func_190926_b()) {
                this.model = null;
            } else {
                CompoundNBT entityData;
                Entity newModel;
                CompoundNBT nbt = NBTHelper.getBaseTag(this.getLasso());
                String mobName = nbt.func_74779_i("mobName");
                if ((this.model == null || !this.model.func_200200_C_().func_150261_e().equals(mobName)) && (newModel = EntityType.func_220335_a((CompoundNBT)(entityData = nbt.func_74775_l("mobData")), (World)this.field_145850_b, entity -> entity)) != null && newModel instanceof LivingEntity) {
                    this.model = (LivingEntity)newModel;
                    this.modelFacing = (Direction)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)HorizontalBlock.field_185512_D);
                }
            }
        }
    }

    public boolean isWorking() {
        if (this.mobFarmData == null || this.getLasso().func_190926_b() || this.isPowered()) {
            return false;
        }
        return this.mobFarmData.isLassoValid(this.getLasso());
    }

    public void updateRedstone() {
        this.powered = this.field_145850_b.func_175687_A(this.field_174879_c) != 0;
    }

    public ItemStack getLasso() {
        return this.inventory.getStackInSlot(0);
    }

    public void setMobFarmData(EnumMobFarm mobFarmData) {
        this.mobFarmData = mobFarmData;
    }

    public boolean isPowered() {
        return this.powered;
    }

    public ItemStackHandler getInventory() {
        return this.inventory;
    }

    public double getScaledProgress() {
        if (this.mobFarmData == null) {
            return 0.0;
        }
        return (double)this.currProgress / (double)this.mobFarmData.getMaxProgress();
    }

    public LivingEntity getModel() {
        return this.model;
    }

    public Direction getModelFacing() {
        return this.modelFacing;
    }

    public String getUnlocalizedName() {
        if (this.mobFarmData == null) {
            return "block.tinymobfarm.default_mob_farm";
        }
        return this.mobFarmData.getUnlocalizedName();
    }

    public void saveAndSync() {
        BlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 3);
        this.func_70296_d();
    }

    public void func_145839_a(CompoundNBT nbt) {
        super.func_145839_a(nbt);
        this.mobFarmData = EnumMobFarm.values()[nbt.func_74762_e("mobFarmData")];
        this.currProgress = nbt.func_74762_e("currProgress");
        this.inventory.deserializeNBT(nbt.func_74775_l("inventory"));
        this.shouldUpdate = true;
    }

    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        if (this.mobFarmData == null) {
            return nbt;
        }
        nbt.func_74768_a("mobFarmData", this.mobFarmData.ordinal());
        nbt.func_74768_a("currProgress", this.currProgress);
        nbt.func_218657_a("inventory", (INBT)this.inventory.serializeNBT());
        return super.func_189515_b(nbt);
    }

    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.func_174877_v(), 0, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket packet) {
        this.func_145839_a(packet.func_148857_g());
    }

    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    public void handleUpdateTag(CompoundNBT nbt) {
        this.func_145839_a(nbt);
    }

    public Container createMenu(int windowId, PlayerInventory inv, PlayerEntity player) {
        return new ContainerMobFarm(windowId, inv, this);
    }

    public ITextComponent func_145748_c_() {
        return new StringTextComponent(this.mobFarmData.getUnlocalizedName());
    }
}

