/*
 * Decompiled with CFR 0.152.
 */
package tterrag.treesimulator;

import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.network.NetworkEvent;
import tterrag.treesimulator.MessageBonemealParticles;
import tterrag.treesimulator.TreeSimulator;

public class MessagePlayerParticle
extends MessageBonemealParticles {
    private final int playerID;

    public MessagePlayerParticle() {
        this.playerID = 0;
    }

    public MessagePlayerParticle(@Nonnull PlayerEntity player, @Nonnull BlockPos pos) {
        super(pos);
        this.playerID = player.func_145782_y();
    }

    MessagePlayerParticle(PacketBuffer buf) {
        super(buf);
        this.playerID = buf.readInt();
    }

    @Override
    void encode(PacketBuffer buf) {
        super.encode(buf);
        buf.writeInt(this.playerID);
    }

    @Override
    void handle(Supplier<NetworkEvent.Context> ctx) {
        if (((Boolean)TreeSimulator.COMMON_CONFIGS.allTheParticles.get()).booleanValue()) {
            ctx.get().enqueueWork(() -> {
                PlayerEntity player = (PlayerEntity)DistExecutor.callWhenOn((Dist)Dist.CLIENT, () -> () -> Minecraft.func_71410_x().field_71441_e.func_73045_a(this.playerID));
                if (player == null) {
                    return;
                }
                World world = player.func_130014_f_();
                Vec3d spawnPos = new Vec3d(player.func_226277_ct_() + world.field_73012_v.nextGaussian() * 0.25, player.func_226278_cu_() + world.field_73012_v.nextGaussian() * 0.75 + 0.8, player.func_226281_cx_() + world.field_73012_v.nextGaussian() * 0.25);
                Vec3d endPos = new Vec3d((Vec3i)this.pos).func_72441_c(world.field_73012_v.nextGaussian() * 0.3 + 0.5, world.field_73012_v.nextGaussian() * 0.25 + 0.3, world.field_73012_v.nextGaussian() * 0.3 + 0.5);
                Vec3d vel = spawnPos.func_178788_d(endPos).func_186678_a(-0.04);
                Particle p = Minecraft.func_71410_x().field_71438_f.func_195471_b((IParticleData)ParticleTypes.field_197632_y, true, spawnPos.field_72450_a, spawnPos.field_72448_b, spawnPos.field_72449_c, vel.field_72450_a, vel.field_72448_b, vel.field_72449_c);
                p.field_187129_i = vel.field_72450_a;
                p.field_187130_j = vel.field_72448_b;
                p.field_187131_k = vel.field_72449_c;
                p.field_190017_n = true;
                p.func_187114_a(25 + world.field_73012_v.nextInt(5));
            });
        }
        ctx.get().setPacketHandled(true);
    }
}

