/*
 * Decompiled with CFR 0.152.
 */
package tterrag.treesimulator;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.block.SaplingBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BoneMealItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.network.PacketDistributor;
import tterrag.treesimulator.MessageBonemealParticles;
import tterrag.treesimulator.MessagePlayerParticle;
import tterrag.treesimulator.PacketHandlerTGS;
import tterrag.treesimulator.TreeSimulator;

public class TickHandlerTGS {
    private Map<UUID, Integer> counters = new HashMap<UUID, Integer>();
    private Map<UUID, PlayerState> states = new HashMap<UUID, PlayerState>();

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        PlayerEntity player;
        int movementCounter;
        Integer temp = this.counters.get(event.player.func_146103_bH().getId());
        int n = movementCounter = temp == null ? 0 : temp;
        if (event.phase == TickEvent.Phase.END && !event.player.func_130014_f_().field_72995_K && (player = event.player).func_130014_f_().func_82737_E() % 5L == 0L) {
            List<BlockPos> coords = this.getNearestBlocks(player.func_130014_f_(), new BlockPos((Entity)player));
            if (coords.size() == 0) {
                return;
            }
            if (player.func_70051_ag()) {
                ++movementCounter;
                this.sendPlayerPacket(player, coords);
            }
            if (PlayerState.getState(player.func_213453_ef()) != this.getState(player)) {
                ++movementCounter;
                this.sendPlayerPacket(player, coords);
            }
            if (movementCounter > (Integer)TreeSimulator.SERVER_CONFIGS.waitTime.get()) {
                if (coords.size() == 0) {
                    --movementCounter;
                    return;
                }
                Collections.shuffle(coords);
                for (BlockPos pos : coords) {
                    Block block = player.func_130014_f_().func_180495_p(pos).func_177230_c();
                    if (!(block instanceof SaplingBlock)) continue;
                    BoneMealItem.applyBonemeal((ItemStack)new ItemStack((IItemProvider)Items.field_196106_bc), (World)player.func_130014_f_(), (BlockPos)pos, (PlayerEntity)player);
                    if (!((Boolean)TreeSimulator.COMMON_CONFIGS.showParticles.get()).booleanValue()) break;
                    this.sendBonemealPacket(player, pos);
                    break;
                }
                movementCounter = 0;
            }
            this.states.put(player.func_146103_bH().getId(), PlayerState.getState(player.func_213453_ef()));
            this.counters.put(event.player.func_146103_bH().getId(), movementCounter);
        }
    }

    private PlayerState getState(PlayerEntity player) {
        UUID user = player.func_146103_bH().getId();
        if (!this.states.containsKey(user)) {
            this.states.put(user, PlayerState.getState(player.func_213453_ef()));
        }
        return this.states.get(user);
    }

    private void sendBonemealPacket(PlayerEntity causedBy, BlockPos pos) {
        PacketHandlerTGS.INSTANCE.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> causedBy), (Object)new MessageBonemealParticles(pos));
    }

    private void sendPlayerPacket(PlayerEntity player, List<BlockPos> coords) {
        if (((Boolean)TreeSimulator.COMMON_CONFIGS.allTheParticles.get()).booleanValue()) {
            for (BlockPos pos : coords) {
                PacketHandlerTGS.INSTANCE.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> player), (Object)new MessagePlayerParticle(player, pos));
            }
        }
    }

    private List<BlockPos> getNearestBlocks(World world, BlockPos pos) {
        return BlockPos.func_218281_b((BlockPos)pos.func_177982_a(-5, -2, -5), (BlockPos)pos.func_177982_a(5, 2, 5)).filter(p -> world.func_180495_p(p).func_177230_c() instanceof SaplingBlock).map(BlockPos::func_185334_h).collect(Collectors.toList());
    }

    public static enum PlayerState {
        CROUCHED,
        STANDING;


        public static PlayerState getState(boolean bool) {
            return bool ? CROUCHED : STANDING;
        }
    }
}

