/*
 * Decompiled with CFR 0.152.
 */
package lykrast.voyage;

import lykrast.voyage.Voyage;
import lykrast.voyage.biomes.BogBiome;
import lykrast.voyage.biomes.DesertMixedBiome;
import lykrast.voyage.biomes.DesertMixedHillsBiome;
import lykrast.voyage.biomes.DesertMountainsBiome;
import lykrast.voyage.biomes.DesertPolarBiome;
import lykrast.voyage.biomes.FlowerPlainsBiome;
import lykrast.voyage.biomes.ForestLushBiome;
import lykrast.voyage.biomes.LagoonColdBiome;
import lykrast.voyage.biomes.LagoonLukewarmBiome;
import lykrast.voyage.biomes.LagoonWarmBiome;
import lykrast.voyage.biomes.MountBiome;
import lykrast.voyage.biomes.RockFieldBiome;
import lykrast.voyage.biomes.RockyPeaksBiome;
import lykrast.voyage.biomes.SteppeBiome;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.BiomeManager;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.IForgeRegistry;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class VoyageBiomes {
    @SubscribeEvent
    public static void registerBiomes(RegistryEvent.Register<Biome> event) {
        IForgeRegistry reg = event.getRegistry();
        VoyageBiomes.register((IForgeRegistry<Biome>)reg, new MountBiome(), "mount", 5, false, BiomeManager.BiomeType.COOL, BiomeDictionary.Type.MOUNTAIN, BiomeDictionary.Type.COLD);
        VoyageBiomes.register((IForgeRegistry<Biome>)reg, new BogBiome(), "bog", 10, false, BiomeManager.BiomeType.WARM, BiomeDictionary.Type.WET, BiomeDictionary.Type.SWAMP);
        VoyageBiomes.register((IForgeRegistry<Biome>)reg, new LagoonWarmBiome(), "lagoon_warm", 10, false, BiomeManager.BiomeType.WARM, BiomeDictionary.Type.BEACH, BiomeDictionary.Type.WET, BiomeDictionary.Type.HOT);
        VoyageBiomes.register((IForgeRegistry<Biome>)reg, new LagoonLukewarmBiome(), "lagoon_lukewarm", 10, false, BiomeManager.BiomeType.WARM, BiomeDictionary.Type.BEACH, BiomeDictionary.Type.WET);
        VoyageBiomes.register((IForgeRegistry<Biome>)reg, new LagoonColdBiome(), "lagoon_cold", 10, false, BiomeManager.BiomeType.COOL, BiomeDictionary.Type.BEACH, BiomeDictionary.Type.WET, BiomeDictionary.Type.COLD);
        VoyageBiomes.register((IForgeRegistry<Biome>)reg, new SteppeBiome(), "steppe", 10, false, BiomeManager.BiomeType.WARM, BiomeDictionary.Type.PLAINS, BiomeDictionary.Type.SPARSE, BiomeDictionary.Type.HOT, BiomeDictionary.Type.DRY);
        VoyageBiomes.register((IForgeRegistry<Biome>)reg, new RockyPeaksBiome(), "rocky_peaks", 8, false, BiomeManager.BiomeType.WARM, BiomeDictionary.Type.MOUNTAIN);
        VoyageBiomes.register((IForgeRegistry<Biome>)reg, new DesertMixedBiome(), "desert_mixed", 10, false, BiomeManager.BiomeType.DESERT, BiomeDictionary.Type.SANDY, BiomeDictionary.Type.HOT, BiomeDictionary.Type.DRY);
        VoyageBiomes.register((IForgeRegistry<Biome>)reg, new DesertMixedHillsBiome(), "desert_mixed_hills", 10, false, BiomeManager.BiomeType.DESERT, BiomeDictionary.Type.SANDY, BiomeDictionary.Type.HILLS, BiomeDictionary.Type.HOT, BiomeDictionary.Type.DRY);
        VoyageBiomes.register((IForgeRegistry<Biome>)reg, new FlowerPlainsBiome(), "flower_plains", 10, true, BiomeManager.BiomeType.WARM, BiomeDictionary.Type.PLAINS);
        VoyageBiomes.register((IForgeRegistry<Biome>)reg, new DesertMountainsBiome(), "desert_mountains", 10, false, BiomeManager.BiomeType.DESERT, BiomeDictionary.Type.SANDY, BiomeDictionary.Type.HILLS, BiomeDictionary.Type.MOUNTAIN, BiomeDictionary.Type.HOT, BiomeDictionary.Type.DRY);
        VoyageBiomes.register((IForgeRegistry<Biome>)reg, new DesertPolarBiome(), "desert_polar", 10, false, BiomeManager.BiomeType.ICY, BiomeDictionary.Type.SNOWY, BiomeDictionary.Type.WASTELAND, BiomeDictionary.Type.COLD, BiomeDictionary.Type.DRY);
        VoyageBiomes.register((IForgeRegistry<Biome>)reg, new ForestLushBiome(), "forest_lush", 5, true, BiomeManager.BiomeType.WARM, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.DENSE);
        VoyageBiomes.register((IForgeRegistry<Biome>)reg, new RockFieldBiome(), "rock_field", 10, false, BiomeManager.BiomeType.WARM, BiomeDictionary.Type.HILLS, BiomeDictionary.Type.DRY);
    }

    private static Biome register(IForgeRegistry<Biome> reg, Biome biome, String name, int weight, boolean canSpawn, BiomeManager.BiomeType managerType, BiomeDictionary.Type ... dictTypes) {
        reg.register(biome.setRegistryName(Voyage.loc(name)));
        BiomeManager.addBiome((BiomeManager.BiomeType)managerType, (BiomeManager.BiomeEntry)new BiomeManager.BiomeEntry(biome, weight));
        if (canSpawn) {
            BiomeManager.addSpawnBiome((Biome)biome);
        }
        BiomeDictionary.addTypes((Biome)biome, (BiomeDictionary.Type[])dictTypes);
        return biome;
    }
}

