/*
 * Decompiled with CFR 0.152.
 */
package lykrast.voyage;

import lykrast.voyage.Voyage;
import lykrast.voyage.biomes.BogBiome;
import lykrast.voyage.biomes.DesertMixedBiome;
import lykrast.voyage.biomes.DesertMixedHillsBiome;
import lykrast.voyage.biomes.DesertMountainsBiome;
import lykrast.voyage.biomes.DesertPolarBiome;
import lykrast.voyage.biomes.FlowerPlainsBiome;
import lykrast.voyage.biomes.ForestLushBiome;
import lykrast.voyage.biomes.LagoonColdBiome;
import lykrast.voyage.biomes.LagoonLukewarmBiome;
import lykrast.voyage.biomes.LagoonWarmBiome;
import lykrast.voyage.biomes.MountBiome;
import lykrast.voyage.biomes.RockFieldBiome;
import lykrast.voyage.biomes.RockyPeaksBiome;
import lykrast.voyage.biomes.SteppeBiome;
import lykrast.voyage.config.BiomeConfig;
import lykrast.voyage.config.ConfigManager;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.BiomeManager;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.IForgeRegistry;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class VoyageBiomes {
    @SubscribeEvent
    public static void registerBiomes(RegistryEvent.Register<Biome> event) {
        IForgeRegistry reg = event.getRegistry();
        VoyageBiomes.register((IForgeRegistry<Biome>)reg, new MountBiome(), ConfigManager.MOUNT, false, BiomeManager.BiomeType.COOL, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.MOUNTAIN, BiomeDictionary.Type.COLD);
        VoyageBiomes.register((IForgeRegistry<Biome>)reg, new BogBiome(), ConfigManager.BOG, false, BiomeManager.BiomeType.WARM, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.WET, BiomeDictionary.Type.SWAMP);
        VoyageBiomes.register((IForgeRegistry<Biome>)reg, new LagoonWarmBiome(), ConfigManager.LAGOON_WARM, false, BiomeManager.BiomeType.WARM, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.BEACH, BiomeDictionary.Type.WET, BiomeDictionary.Type.HOT);
        VoyageBiomes.register((IForgeRegistry<Biome>)reg, new LagoonLukewarmBiome(), ConfigManager.LAGOON_LUKEWARM, false, BiomeManager.BiomeType.WARM, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.BEACH, BiomeDictionary.Type.WET);
        VoyageBiomes.register((IForgeRegistry<Biome>)reg, new LagoonColdBiome(), ConfigManager.LAGOON_COLD, false, BiomeManager.BiomeType.COOL, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.BEACH, BiomeDictionary.Type.WET, BiomeDictionary.Type.COLD);
        VoyageBiomes.register((IForgeRegistry<Biome>)reg, new SteppeBiome(), ConfigManager.STEPPE, false, BiomeManager.BiomeType.WARM, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.PLAINS, BiomeDictionary.Type.SPARSE, BiomeDictionary.Type.HOT, BiomeDictionary.Type.DRY);
        VoyageBiomes.register((IForgeRegistry<Biome>)reg, new RockyPeaksBiome(), ConfigManager.ROCKY_PEAKS, false, BiomeManager.BiomeType.WARM, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.MOUNTAIN);
        VoyageBiomes.register((IForgeRegistry<Biome>)reg, new DesertMixedBiome(), ConfigManager.DESERT_MIXED, false, BiomeManager.BiomeType.DESERT, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.SANDY, BiomeDictionary.Type.HOT, BiomeDictionary.Type.DRY);
        VoyageBiomes.register((IForgeRegistry<Biome>)reg, new DesertMixedHillsBiome(), ConfigManager.DESERT_MIXED_HILLS, false, BiomeManager.BiomeType.DESERT, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.SANDY, BiomeDictionary.Type.HILLS, BiomeDictionary.Type.HOT, BiomeDictionary.Type.DRY);
        VoyageBiomes.register((IForgeRegistry<Biome>)reg, new FlowerPlainsBiome(), ConfigManager.FLOWER_PLAINS, true, BiomeManager.BiomeType.WARM, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.PLAINS);
        VoyageBiomes.register((IForgeRegistry<Biome>)reg, new DesertMountainsBiome(), ConfigManager.DESERT_MOUNTAINS, false, BiomeManager.BiomeType.DESERT, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.SANDY, BiomeDictionary.Type.HILLS, BiomeDictionary.Type.MOUNTAIN, BiomeDictionary.Type.HOT, BiomeDictionary.Type.DRY);
        VoyageBiomes.register((IForgeRegistry<Biome>)reg, new DesertPolarBiome(), ConfigManager.DESERT_POLAR, false, BiomeManager.BiomeType.ICY, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.SNOWY, BiomeDictionary.Type.WASTELAND, BiomeDictionary.Type.COLD, BiomeDictionary.Type.DRY);
        VoyageBiomes.register((IForgeRegistry<Biome>)reg, new ForestLushBiome(), ConfigManager.FOREST_LUSH, true, BiomeManager.BiomeType.WARM, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.DENSE);
        VoyageBiomes.register((IForgeRegistry<Biome>)reg, new RockFieldBiome(), ConfigManager.ROCK_FIELD, false, BiomeManager.BiomeType.WARM, BiomeDictionary.Type.OVERWORLD, BiomeDictionary.Type.HILLS, BiomeDictionary.Type.DRY);
    }

    private static Biome register(IForgeRegistry<Biome> reg, Biome biome, BiomeConfig config, boolean canSpawn, BiomeManager.BiomeType managerType, BiomeDictionary.Type ... dictTypes) {
        reg.register(biome.setRegistryName(Voyage.loc(config.name())));
        if (config.shouldSpawn()) {
            BiomeManager.addBiome((BiomeManager.BiomeType)managerType, (BiomeManager.BiomeEntry)new BiomeManager.BiomeEntry(biome, config.weight()));
            if (canSpawn) {
                BiomeManager.addSpawnBiome((Biome)biome);
            }
            BiomeDictionary.addTypes((Biome)biome, (BiomeDictionary.Type[])dictTypes);
        }
        return biome;
    }
}

