/*
 * Decompiled with CFR 0.152.
 */
package com._13rac1.erosion.common;

import com._13rac1.erosion.Translate;
import com._13rac1.erosion.common.BlockFlag;
import com._13rac1.erosion.common.ErodableBlocks;
import com._13rac1.erosion.common.ErosionWorld;
import com._13rac1.erosion.common.FluidLevel;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FluidBlock;
import net.minecraft.block.properties.IProperty;
import net.minecraft.tag.BlockTags;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;

public class Tasks {
    private static final Integer blockFlags = BlockFlag.PROPAGATE_CHANGE | BlockFlag.NOTIFY_LISTENERS;
    private static final List<Vec3i> posFourEdges = Arrays.asList(new Vec3i(1, 0, 0), new Vec3i(0, 0, -1), new Vec3i(-1, 0, 0), new Vec3i(0, 0, 1));
    private static final List<Vec3i> posEightAround = Arrays.asList(new Vec3i(1, 0, 1), new Vec3i(1, 0, 0), new Vec3i(1, 0, -1), new Vec3i(0, 0, -1), new Vec3i(-1, 0, -1), new Vec3i(-1, 0, 0), new Vec3i(-1, 0, 1), new Vec3i(0, 0, 1));
    private static final List<Vec3i> posEightAroundUp = Arrays.asList(new Vec3i(1, 1, 1), new Vec3i(1, 1, 0), new Vec3i(1, 1, -1), new Vec3i(0, 1, -1), new Vec3i(-1, 1, -1), new Vec3i(-1, 1, 0), new Vec3i(-1, 1, 1), new Vec3i(0, 1, 1));
    private static List<Integer> wallBreakers = Arrays.asList(FluidLevel.FLOW1, FluidLevel.FLOW2, FluidLevel.FLOW3, FluidLevel.FLOW4, FluidLevel.FLOW5, FluidLevel.FLOW6, FluidLevel.FLOW7);
    private static final int SOURCE_BREAKS_ABOVE_SEA_LEVEL = 0;

    public static void run(BlockState state, ErosionWorld world, BlockPos pos, Random rand) {
        Integer level = state.get(FluidBlock.field_176367_b);
        Tasks.maybeSourceBreak(state, world, pos, rand, level);
        if (Tasks.maybeAddMoss(state, world, pos, rand)) {
            return;
        }
        if (level == FluidLevel.SOURCE) {
            return;
        }
        if (Tasks.maybeFlowingWall(state, world, pos, rand, level)) {
            return;
        }
        Tasks.maybeErodeEdge(state, world, pos, rand, level);
        Tasks.maybeDecayUnder(state, world, pos, rand, level);
    }

    private static void maybeErodeEdge(BlockState state, ErosionWorld world, BlockPos pos, Random rand, Integer level) {
        BlockPos underPos = pos.func_177977_b();
        BlockState underState = world.getBlockState(underPos);
        Block underBlock = underState.getBlock();
        if (!ErodableBlocks.canErode(underBlock)) {
            return;
        }
        if (!ErodableBlocks.maybeErode(rand, underBlock)) {
            return;
        }
        if (!Tasks.isEdge(world, pos) && level != FluidLevel.FLOW7) {
            return;
        }
        Block decayBlock = ErodableBlocks.maybeDecay(rand, underBlock);
        if (decayBlock != Blocks.field_150350_a) {
            world.setBlockState(underPos, Translate.State(decayBlock.func_176223_P()), blockFlags);
            return;
        }
        Integer underBlocklevel = level < FluidLevel.FALLING7 ? level + 1 : FluidLevel.FALLING7;
        BlockState newState = Translate.State(Blocks.field_150355_j.func_176223_P().func_177226_a((IProperty)FluidBlock.field_176367_b, (Comparable)underBlocklevel));
        world.setBlockState(underPos, newState, blockFlags);
        if (state.get(FluidBlock.field_176367_b) == FluidLevel.SOURCE) {
            return;
        }
        world.setBlockState(pos, Translate.State(Blocks.field_150350_a.func_176223_P()), blockFlags);
        Integer upDeleteCount = 0;
        BlockPos posUp = pos.func_177984_a();
        while (world.isFluidBlock(world.getBlockState(posUp).getBlock()).booleanValue()) {
            Integer n = upDeleteCount;
            Integer n2 = upDeleteCount = Integer.valueOf(upDeleteCount + 1);
            if (upDeleteCount > 3 || world.getBlockState(posUp).get(FluidBlock.field_176367_b) == FluidLevel.SOURCE) break;
            world.setBlockState(posUp, Translate.State(Blocks.field_150350_a.func_176223_P()), blockFlags);
            posUp = posUp.func_177984_a();
        }
    }

    protected static boolean isEdge(ErosionWorld world, BlockPos pos) {
        List<BlockPos> listSidePos = Arrays.asList(pos.func_177978_c(), pos.func_177968_d(), pos.func_177974_f(), pos.func_177976_e());
        for (BlockPos sidePos : listSidePos) {
            BlockPos underPos = sidePos.func_177977_b();
            BlockState underState = world.getBlockState(underPos);
            Block underBlock = underState.getBlock();
            if (!world.isFluidBlock(underBlock).booleanValue()) continue;
            return true;
        }
        return false;
    }

    private static boolean maybeFlowingWall(BlockState state, ErosionWorld world, BlockPos pos, Random rand, Integer level) {
        BlockPos flowPos;
        BlockPos aboveFlowPos;
        BlockState aboveFlowState;
        Block aboveFlowBlock;
        if (!wallBreakers.contains(level)) {
            return false;
        }
        Vec3d velocity = world.getFlowVelocity(state, pos);
        if (Math.abs(velocity.field_72450_a) < 1.0 && Math.abs(velocity.field_72449_c) < 1.0) {
            return false;
        }
        Integer Flow7Adjust = 0;
        if (level == FluidLevel.FLOW7) {
            Flow7Adjust = 1;
        }
        if (BlockTags.LOGS.contains(aboveFlowBlock = (aboveFlowState = world.getBlockState(aboveFlowPos = (flowPos = pos.func_177971_a(new Vec3i(velocity.field_72450_a, velocity.field_72448_b - (double)Flow7Adjust.intValue(), velocity.field_72449_c))).func_177984_a())).getBlock())) {
            return false;
        }
        BlockState flowState = world.getBlockState(flowPos);
        Block wallBlock = flowState.getBlock();
        if (!ErodableBlocks.canErode(wallBlock)) {
            return false;
        }
        if (!ErodableBlocks.maybeErode(rand, wallBlock)) {
            return false;
        }
        world.setBlockState(flowPos, Translate.State(Blocks.field_150350_a.func_176223_P()), blockFlags);
        return true;
    }

    private static void maybeSourceBreak(BlockState state, ErosionWorld world, BlockPos pos, Random rand, Integer level) {
        if (level != FluidLevel.SOURCE) {
            return;
        }
        if (pos.func_177956_o() <= world.getSeaLevel() + 0) {
            return;
        }
        Block upBlock = world.getBlockState(pos.func_177984_a()).getBlock();
        if (upBlock != Blocks.field_150350_a) {
            return;
        }
        Vec3d velocity = world.getFlowVelocity(state, pos);
        if (velocity.func_72433_c() > 0.0) {
            return;
        }
        List<Vec3i> listDirection = Arrays.asList(new Vec3i(1, 0, 0), new Vec3i(-1, 0, 0), new Vec3i(0, 0, 1), new Vec3i(0, 0, -1));
        Collections.shuffle(listDirection);
        for (Vec3i dir : listDirection) {
            BlockPos sidePos = pos.func_177971_a(dir);
            Block sideBlock = world.getBlockState(sidePos).getBlock();
            if (sideBlock == Blocks.field_150355_j || !ErodableBlocks.canErode(sideBlock) || !ErodableBlocks.canSourceBreak(sideBlock) || !Tasks.airInFlowPath(world, pos, dir)) continue;
            int waterFound = 0;
            for (int waterMultipler : Arrays.asList(1, 2, 3)) {
                Vec3i waterDirection = new Vec3i(-dir.func_177958_n() * waterMultipler, dir.func_177956_o(), -dir.func_177952_p() * waterMultipler);
                BlockPos maybeWaterPos = pos.func_177971_a(waterDirection);
                BlockState maybeWaterState = world.getBlockState(maybeWaterPos);
                if (maybeWaterState.getBlock() != Blocks.field_150355_j && maybeWaterState.getBlock() != Blocks.field_150358_i) break;
                ++waterFound;
            }
            if (waterFound < 1) continue;
            if (!ErodableBlocks.maybeErode(rand, sideBlock)) {
                return;
            }
            world.setBlockState(sidePos, Translate.State(Blocks.field_150350_a.func_176223_P()), blockFlags);
            return;
        }
    }

    private static boolean isAir(Block block) {
        return block == Blocks.field_150350_a;
    }

    protected static boolean airInFlowPath(ErosionWorld world, BlockPos pos, Vec3i dir) {
        int yDeeper = 0;
        for (int airMultipler : Arrays.asList(7, 14)) {
            Vec3i airDirection = new Vec3i(dir.func_177958_n() * airMultipler, dir.func_177956_o() - yDeeper, dir.func_177952_p() * airMultipler);
            ++yDeeper;
            BlockPos maybeAirPos = pos.func_177971_a(airDirection);
            BlockState maybeAirState = world.getBlockState(maybeAirPos);
            Block maybeAirBlock = maybeAirState.getBlock();
            if (!Tasks.isAir(maybeAirBlock) && !BlockTags.LEAVES.contains(maybeAirBlock)) continue;
            return true;
        }
        return false;
    }

    protected static boolean maybeDecayUnder(BlockState state, ErosionWorld world, BlockPos pos, Random rand, Integer level) {
        if (level == FluidLevel.SOURCE || level > FluidLevel.FLOW7) {
            return false;
        }
        BlockPos underPos = pos.func_177977_b();
        BlockState underState = world.getBlockState(underPos);
        Block underBlock = underState.getBlock();
        if (!ErodableBlocks.canErode(underBlock)) {
            return false;
        }
        Block decayTo = ErodableBlocks.decayTo(underBlock);
        if (decayTo == Blocks.field_150350_a) {
            return false;
        }
        Vec3d velocity = world.getFlowVelocity(state, pos);
        if (Math.abs(velocity.field_72450_a) < 0.8 && Math.abs(velocity.field_72449_c) < 0.8) {
            return false;
        }
        BlockPos flowPos = underPos.func_177971_a(new Vec3i((double)Math.round(velocity.field_72450_a), 0.0, (double)Math.round(velocity.field_72449_c)));
        BlockState flowState = world.getBlockState(flowPos);
        Block flowBlock = flowState.getBlock();
        if (!ErodableBlocks.getDecayList(underBlock).contains(flowBlock)) {
            return false;
        }
        world.setBlockState(underPos, Translate.State(decayTo.func_176223_P()), blockFlags);
        return true;
    }

    private static boolean isCobbleStone(Block block) {
        return block == Blocks.field_150347_e || block == Blocks.field_150463_bK || block == Blocks.field_150463_bK;
    }

    private static boolean isStoneBricks(Block block) {
        return block == Blocks.field_150417_aV || block == Blocks.field_150390_bg;
    }

    private static boolean maybeAddMoss(BlockState state, ErosionWorld world, BlockPos pos, Random rand) {
        List<Vec3i> listDirection = posEightAround;
        Collections.shuffle(listDirection);
        Iterator<Vec3i> iterator = listDirection.iterator();
        if (iterator.hasNext()) {
            Vec3i dir = iterator.next();
            BlockPos sidePos = pos.func_177971_a(dir);
            Block sideBlock = world.getBlockState(sidePos).getBlock();
            if (!Tasks.isCobbleStone(sideBlock) && !Tasks.isStoneBricks(sideBlock)) {
                return false;
            }
            Block mossBlock = ErodableBlocks.maybeDecay(rand, sideBlock);
            if (mossBlock == Blocks.field_150350_a) {
                return false;
            }
            world.setBlockState(sidePos, Translate.State(mossBlock.func_176223_P()), blockFlags);
            return true;
        }
        return false;
    }
}

