/*
 * Decompiled with CFR 0.152.
 */
package com._13rac1.erosion.forge.mixin;

import com._13rac1.erosion.common.ErosionWorld;
import com._13rac1.erosion.common.Tasks;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.BlockState;
import net.minecraft.block.PublicBlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.spongepowered.asm.mixin.Mixin;

@Mixin(value={BlockLiquid.class})
public class FluidBlockMixin
extends Block {
    protected FluidBlockMixin(Material materialIn) {
        super(materialIn);
        this.field_149789_z = true;
    }

    public boolean func_149653_t() {
        return true;
    }

    public void func_180645_a(World worldIn, BlockPos pos, IBlockState state, Random random) {
        super.func_180645_a(worldIn, pos, state, random);
        if (this.field_149764_J != Material.field_151586_h) {
            return;
        }
        ForgeWorld forgeWorld = new ForgeWorld(worldIn);
        BlockState blockState = new BlockState(state);
        Tasks.run(blockState, forgeWorld, pos, random);
    }

    class ForgeWorld
    implements ErosionWorld {
        private World world;

        public ForgeWorld(World world) {
            this.world = world;
        }

        @Override
        public BlockState getBlockState(BlockPos pos) {
            return new BlockState(this.world.func_180495_p(pos));
        }

        @Override
        public Boolean setBlockState(BlockPos pos, BlockState newState, Integer flags) {
            IBlockState iState = newState.getIBlockState();
            return this.world.func_180501_a(pos, iState, flags.intValue());
        }

        @Override
        public int getSeaLevel() {
            return this.world.func_181545_F();
        }

        @Override
        public Vec3d getFlowVelocity(BlockState state, BlockPos pos) {
            IBlockState iState = state.getIBlockState();
            return PublicBlockLiquid.getFlow((IBlockAccess)this.world, pos, iState);
        }

        @Override
        public Boolean isFluidBlock(Block block) {
            return block instanceof BlockLiquid;
        }
    }
}

