/*
 * Decompiled with CFR 0.152.
 */
package com._13rac1.erosion.common;

import com._13rac1.erosion.common.BlockFlag;
import com._13rac1.erosion.common.ErodableBlocks;
import com._13rac1.erosion.common.ErosionWorld;
import com._13rac1.erosion.common.FluidLevel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FluidBlock;
import net.minecraft.state.IProperty;
import net.minecraft.tag.BlockTags;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;

public class Tasks {
    private static final Vec3i VECTOR_DOWN = new Vec3i(0, -1, 0);
    private static final Vec3i VECTOR_UP = new Vec3i(0, 1, 0);
    private static final Vec3i VECTOR_NORTH = new Vec3i(0, 0, -1);
    private static final Vec3i VECTOR_NORTH_EAST = new Vec3i(1, 0, -1);
    private static final Vec3i VECTOR_EAST = new Vec3i(1, 0, 0);
    private static final Vec3i VECTOR_SOUTH_EAST = new Vec3i(1, 0, 1);
    private static final Vec3i VECTOR_SOUTH = new Vec3i(0, 0, 1);
    private static final Vec3i VECTOR_SOUTH_WEST = new Vec3i(-1, 0, 1);
    private static final Vec3i VECTOR_WEST = new Vec3i(-1, 0, 0);
    private static final Vec3i VECTOR_NORTH_WEST = new Vec3i(-1, 0, -1);
    private static final Integer blockFlags = BlockFlag.PROPAGATE_CHANGE | BlockFlag.NOTIFY_LISTENERS;
    private static final List<Vec3i> posFourEdges = Arrays.asList(VECTOR_NORTH, VECTOR_EAST, VECTOR_SOUTH, VECTOR_WEST);
    private static final List<Vec3i> posEightAround = Arrays.asList(VECTOR_NORTH, VECTOR_NORTH_EAST, VECTOR_EAST, VECTOR_SOUTH_EAST, VECTOR_SOUTH, VECTOR_SOUTH_WEST, VECTOR_WEST, VECTOR_NORTH_WEST);
    private static final List<Vec3i> posEightAroundUp = Arrays.asList(new Vec3i(1, 1, 1), new Vec3i(1, 1, 0), new Vec3i(1, 1, -1), new Vec3i(0, 1, -1), new Vec3i(-1, 1, -1), new Vec3i(-1, 1, 0), new Vec3i(-1, 1, 1), new Vec3i(0, 1, 1));
    private static List<Integer> wallBreakers = Arrays.asList(FluidLevel.FLOW1, FluidLevel.FLOW2, FluidLevel.FLOW3, FluidLevel.FLOW4, FluidLevel.FLOW5, FluidLevel.FLOW6, FluidLevel.FLOW7);

    public void run(BlockState state, ErosionWorld world, BlockPos pos, Random rand) {
        Integer level = (Integer)state.func_177229_b((IProperty)FluidBlock.field_176367_b);
        this.maybeSourceBreak(state, world, pos, rand, level);
        if (this.maybeAddMoss(world, pos, rand)) {
            return;
        }
        if (level == FluidLevel.SOURCE) {
            return;
        }
        if (this.maybeFlowingWall(state, world, pos, rand, level)) {
            return;
        }
        this.maybeErodeEdge(state, world, pos, rand, level);
        this.maybeDecayUnder(state, world, pos, rand, level);
    }

    private void maybeErodeEdge(BlockState state, ErosionWorld world, BlockPos pos, Random rand, Integer level) {
        BlockPos underPos = pos.func_177977_b();
        Block underBlock = world.getBlock(underPos);
        if (!ErodableBlocks.canErode(underBlock)) {
            return;
        }
        if (!ErodableBlocks.maybeErode(rand, underBlock)) {
            return;
        }
        if (!this.isEdge(world, pos) && level != FluidLevel.FLOW7) {
            return;
        }
        Block decayBlock = ErodableBlocks.maybeDecay(rand, underBlock);
        if (decayBlock != Blocks.field_150350_a) {
            world.setBlockState(underPos, decayBlock.func_176223_P(), blockFlags);
            return;
        }
        Integer underBlocklevel = level < FluidLevel.FALLING7 ? level + 1 : FluidLevel.FALLING7;
        world.setBlockState(underPos, (BlockState)Blocks.field_150355_j.func_176223_P().func_206870_a((IProperty)FluidBlock.field_176367_b, (Comparable)underBlocklevel), blockFlags);
        if (state.func_177229_b((IProperty)FluidBlock.field_176367_b) == FluidLevel.SOURCE) {
            return;
        }
        world.setBlockState(pos, Blocks.field_150350_a.func_176223_P(), blockFlags);
        Integer upDeleteCount = 0;
        BlockPos posUp = pos.func_177984_a();
        while (world.isFluidBlock(world.getBlock(posUp)).booleanValue()) {
            Integer n = upDeleteCount;
            Integer n2 = upDeleteCount = Integer.valueOf(upDeleteCount + 1);
            if (upDeleteCount > 3 || world.getBlockState(posUp).func_177229_b((IProperty)FluidBlock.field_176367_b) == FluidLevel.SOURCE) break;
            world.setBlockState(posUp, Blocks.field_150350_a.func_176223_P(), blockFlags);
            posUp = posUp.func_177984_a();
        }
    }

    protected boolean isEdge(ErosionWorld world, BlockPos pos) {
        List<BlockPos> listSidePos = Arrays.asList(pos.func_177978_c(), pos.func_177968_d(), pos.func_177974_f(), pos.func_177976_e());
        for (BlockPos sidePos : listSidePos) {
            BlockPos underPos = sidePos.func_177977_b();
            Block underBlock = world.getBlock(underPos);
            if (!world.isFluidBlock(underBlock).booleanValue()) continue;
            return true;
        }
        return false;
    }

    protected Vec3i dirTurnLeft(Vec3i in) {
        return in.func_177955_d(VECTOR_DOWN);
    }

    protected Vec3i dirTurnRight(Vec3i in) {
        return in.func_177955_d(VECTOR_UP);
    }

    protected boolean treeInColumn(ErosionWorld world, BlockPos pos) {
        Integer MAX_UP = 5;
        Integer count = 0;
        BlockPos currentPos = pos.func_177984_a();
        while (count < MAX_UP) {
            Block currentBlock = world.getBlock(currentPos);
            if (BlockTags.field_200031_h.func_199685_a_((Object)currentBlock)) {
                return true;
            }
            if (this.isAir(currentBlock)) {
                return false;
            }
            Integer n = count;
            Integer n2 = count = Integer.valueOf(count + 1);
            currentPos = currentPos.func_177984_a();
        }
        return false;
    }

    private boolean maybeFlowingWall(BlockState state, ErosionWorld world, BlockPos pos, Random rand, Integer level) {
        wallBreakOption opt;
        Integer dist;
        Vec3i dirForward;
        BlockPos posForward;
        Block blockForward;
        if (!wallBreakers.contains(level)) {
            return false;
        }
        Vec3d velocity = world.getFlowVelocity(state, pos);
        if (Math.abs(velocity.field_72450_a) < 0.8 && Math.abs(velocity.field_72449_c) < 0.8) {
            return false;
        }
        Integer Flow7Adjust = 0;
        if (level == FluidLevel.FLOW7) {
            Flow7Adjust = -1;
        }
        if (this.isAir(blockForward = world.getBlock(posForward = pos.func_177971_a(dirForward = new Vec3i((double)Math.round(velocity.field_72450_a), velocity.field_72448_b + (double)Flow7Adjust.intValue(), (double)Math.round(velocity.field_72449_c))))) || blockForward == Blocks.field_150355_j || blockForward == Blocks.field_150353_l) {
            return false;
        }
        Vec3i dirLeft = this.dirTurnLeft(dirForward);
        Vec3i dirRight = this.dirTurnRight(dirForward);
        BlockPos posLeft = pos.func_177971_a(dirLeft);
        BlockPos posRight = pos.func_177971_a(dirRight);
        Boolean canErodeForward = ErodableBlocks.canErode(blockForward) && !this.treeInColumn(world, posForward);
        Boolean canErodeLeft = ErodableBlocks.canErode(world.getBlock(posLeft)) && !this.treeInColumn(world, posLeft);
        Boolean canErodeRight = ErodableBlocks.canErode(world.getBlock(posRight)) && !this.treeInColumn(world, posRight);
        if (!(canErodeForward.booleanValue() || canErodeLeft.booleanValue() || canErodeRight.booleanValue())) {
            return false;
        }
        ArrayList<wallBreakOption> options = new ArrayList<wallBreakOption>();
        if (canErodeForward.booleanValue() && (dist = this.distanceToAirWaterInFlowPath(world, pos, dirForward, level)) != 128) {
            opt = new wallBreakOption();
            opt.dir = dirForward;
            opt.distance = dist;
            options.add(opt);
        }
        if (canErodeLeft.booleanValue() && (dist = this.distanceToAirWaterInFlowPath(world, pos, dirLeft, level)) != 128) {
            opt = new wallBreakOption();
            opt.dir = dirLeft;
            opt.distance = dist;
            options.add(opt);
        }
        if (canErodeRight.booleanValue() && (dist = this.distanceToAirWaterInFlowPath(world, pos, dirRight, level)) != 128) {
            opt = new wallBreakOption();
            opt.dir = dirRight;
            opt.distance = dist;
            options.add(opt);
        }
        if (options.size() == 0) {
            return false;
        }
        Integer shortestDistance = 128;
        Vec3i shortestDir = null;
        for (wallBreakOption option : options) {
            if (option.distance >= shortestDistance) continue;
            shortestDistance = option.distance;
            shortestDir = option.dir;
        }
        if (shortestDir == null) {
            return false;
        }
        BlockPos flowPos = pos.func_177971_a(shortestDir);
        BlockPos aboveFlowPos = flowPos.func_177984_a();
        Block aboveFlowBlock = world.getBlock(aboveFlowPos);
        if (BlockTags.field_200031_h.func_199685_a_((Object)aboveFlowBlock)) {
            return false;
        }
        Block wallBlock = world.getBlock(flowPos);
        if (!ErodableBlocks.canErode(wallBlock)) {
            return false;
        }
        if (!ErodableBlocks.maybeErode(rand, wallBlock)) {
            return false;
        }
        world.setBlockState(flowPos, Blocks.field_150350_a.func_176223_P(), blockFlags);
        return true;
    }

    private void maybeSourceBreak(BlockState state, ErosionWorld world, BlockPos pos, Random rand, Integer level) {
        if (level != FluidLevel.SOURCE) {
            return;
        }
        if (pos.func_177956_o() < world.getSeaLevel()) {
            return;
        }
        Block upBlock = world.getBlockState(pos.func_177984_a()).func_177230_c();
        if (!this.isAir(upBlock)) {
            return;
        }
        Vec3d velocity = world.getFlowVelocity(state, pos);
        if (velocity.func_72433_c() > 0.0) {
            return;
        }
        List<Vec3i> listDirection = Arrays.asList(new Vec3i(1, 0, 0), new Vec3i(-1, 0, 0), new Vec3i(0, 0, 1), new Vec3i(0, 0, -1));
        Collections.shuffle(listDirection);
        for (Vec3i dir : listDirection) {
            Integer dist;
            BlockPos sidePos = pos.func_177971_a(dir);
            Block sideBlock = world.getBlock(sidePos);
            if (sideBlock == Blocks.field_150355_j || !ErodableBlocks.canErode(sideBlock) || !ErodableBlocks.canSourceBreak(sideBlock) || (dist = this.distanceToAirWaterInFlowPath(world, pos, dir, level)) == 128) continue;
            int waterFound = 0;
            for (int waterMultipler : Arrays.asList(1, 2, 3)) {
                Vec3i waterDirection = new Vec3i(-dir.func_177958_n() * waterMultipler, dir.func_177956_o(), -dir.func_177952_p() * waterMultipler);
                BlockPos maybeWaterPos = pos.func_177971_a(waterDirection);
                BlockState maybeWaterState = world.getBlockState(maybeWaterPos);
                if (maybeWaterState.func_177230_c() != Blocks.field_150355_j) break;
                ++waterFound;
            }
            if (waterFound < 1) continue;
            if (!ErodableBlocks.maybeErode(rand, sideBlock)) {
                return;
            }
            world.setBlockState(sidePos, Blocks.field_150350_a.func_176223_P(), blockFlags);
            return;
        }
    }

    private boolean isAir(Block block) {
        return block == Blocks.field_150350_a || block == Blocks.field_201941_jj;
    }

    protected boolean airInFlowPath(ErosionWorld world, BlockPos pos, Vec3i dir) {
        int yDeeper = 0;
        for (int airMultipler : Arrays.asList(7, 14)) {
            Vec3i airDirection = new Vec3i(dir.func_177958_n() * airMultipler, dir.func_177956_o() - yDeeper, dir.func_177952_p() * airMultipler);
            ++yDeeper;
            BlockPos maybeAirPos = pos.func_177971_a(airDirection);
            Block maybeAirBlock = world.getBlock(maybeAirPos);
            if (!this.isAir(maybeAirBlock) && !BlockTags.field_206952_E.func_199685_a_((Object)maybeAirBlock)) continue;
            return true;
        }
        return false;
    }

    protected Integer distanceToAirWaterInFlowPath(ErosionWorld world, BlockPos pos, Vec3i dir, Integer level) {
        Block blockCurrent;
        if (level > FluidLevel.FLOW7) {
            return 128;
        }
        Integer distanceToAirWater = 0;
        Integer flowDistanceRemaining = 7 - level;
        BlockPos posCurrent = pos;
        while (flowDistanceRemaining > 0) {
            flowDistanceRemaining = flowDistanceRemaining - 1;
            distanceToAirWater = distanceToAirWater + 1;
            blockCurrent = world.getBlock(posCurrent = posCurrent.func_177971_a(dir));
            if (this.isAir(blockCurrent) || BlockTags.field_206952_E.func_199685_a_((Object)blockCurrent) || blockCurrent == Blocks.field_150355_j) {
                return distanceToAirWater;
            }
            if (ErodableBlocks.canErode(blockCurrent)) continue;
            return 128;
        }
        posCurrent = posCurrent.func_177977_b();
        flowDistanceRemaining = 7;
        while (flowDistanceRemaining > 0) {
            flowDistanceRemaining = flowDistanceRemaining - 1;
            distanceToAirWater = distanceToAirWater + 1;
            blockCurrent = world.getBlock(posCurrent = posCurrent.func_177971_a(dir));
            if (!this.isAir(blockCurrent) && !BlockTags.field_206952_E.func_199685_a_((Object)blockCurrent)) continue;
            return distanceToAirWater;
        }
        return 128;
    }

    protected boolean maybeDecayUnder(BlockState state, ErosionWorld world, BlockPos pos, Random rand, Integer level) {
        if (level == FluidLevel.SOURCE || level > FluidLevel.FLOW7) {
            return false;
        }
        BlockPos underPos = pos.func_177977_b();
        Block underBlock = world.getBlock(underPos);
        if (!ErodableBlocks.canErode(underBlock)) {
            return false;
        }
        Block decayTo = ErodableBlocks.decayTo(underBlock);
        if (decayTo == Blocks.field_150350_a) {
            return false;
        }
        Vec3d velocity = world.getFlowVelocity(state, pos);
        if (Math.abs(velocity.field_72450_a) < 0.8 && Math.abs(velocity.field_72449_c) < 0.8) {
            return false;
        }
        BlockPos flowPos = underPos.func_177971_a(new Vec3i((double)Math.round(velocity.field_72450_a), 0.0, (double)Math.round(velocity.field_72449_c)));
        Block flowBlock = world.getBlock(flowPos);
        if (!ErodableBlocks.getDecayList(underBlock).contains(flowBlock)) {
            return false;
        }
        world.setBlockState(underPos, decayTo.func_176223_P(), blockFlags);
        return true;
    }

    protected boolean isCobbleStone(Block block) {
        return block == Blocks.field_150347_e || block == Blocks.field_150463_bK || block == Blocks.field_196659_cl || block == Blocks.field_150463_bK;
    }

    protected boolean isStoneBricks(Block block) {
        return block == Blocks.field_196696_di || block == Blocks.field_222413_lB || block == Blocks.field_150390_bg || block == Blocks.field_222413_lB;
    }

    protected boolean maybeAddMoss(ErosionWorld world, BlockPos pos, Random rand) {
        List<Vec3i> listDirection = posEightAround;
        Collections.shuffle(listDirection);
        Iterator<Vec3i> iterator = listDirection.iterator();
        if (iterator.hasNext()) {
            Vec3i dir = iterator.next();
            BlockPos sidePos = pos.func_177971_a(dir);
            Block sideBlock = world.getBlock(sidePos);
            if (!this.isCobbleStone(sideBlock) && !this.isStoneBricks(sideBlock)) {
                return false;
            }
            Block mossBlock = ErodableBlocks.maybeDecay(rand, sideBlock);
            if (mossBlock == Blocks.field_150350_a) {
                return false;
            }
            world.setBlockState(sidePos, mossBlock.func_176223_P(), blockFlags);
            return true;
        }
        return false;
    }

    private class wallBreakOption {
        Vec3i dir;
        Integer distance;

        private wallBreakOption() {
        }
    }
}

