/*
 * Decompiled with CFR 0.152.
 */
package fluke.worleycaves.world;

import com.google.common.base.MoreObjects;
import com.mojang.datafixers.Dynamic;
import fluke.worleycaves.config.WorleyConfig;
import fluke.worleycaves.util.BlockUtil;
import fluke.worleycaves.util.FastNoise;
import fluke.worleycaves.util.WorleyUtil;
import java.util.BitSet;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.carver.WorldCarver;
import net.minecraft.world.gen.feature.ProbabilityConfig;
import net.minecraftforge.fluids.IFluidBlock;

public class WorldCarverWorley
extends WorldCarver<ProbabilityConfig> {
    long[] genTime = new long[300];
    int currentTimeIndex = 0;
    double sum = 0.0;
    private WorleyUtil worleyF1divF3;
    private FastNoise displacementNoisePerlin;
    private static final BlockState AIR = Blocks.field_150350_a.func_176223_P();
    private static BlockState lavaBlock;
    private static int maxCaveHeight;
    private static int minCaveHeight;
    private static float noiseCutoff;
    private static float warpAmplifier;
    private static float easeInDepth;
    private static float yCompression;
    private static float xzCompression;
    private static float surfaceCutoff;
    private static int lavaDepth;
    private static boolean additionalWaterChecks;

    public WorldCarverWorley(Function<Dynamic<?>, ? extends ProbabilityConfig> p_i49929_1_, int p_i49929_2_) {
        super(p_i49929_1_, p_i49929_2_);
    }

    private void debugValueAdjustments() {
    }

    public void init(long worldSeed) {
        this.worleyF1divF3 = new WorleyUtil((int)worldSeed);
        this.worleyF1divF3.SetFrequency(0.016f);
        this.displacementNoisePerlin = new FastNoise((int)worldSeed);
        this.displacementNoisePerlin.SetNoiseType(FastNoise.NoiseType.Perlin);
        this.displacementNoisePerlin.SetFrequency(0.05f);
        maxCaveHeight = WorleyConfig.maxCaveHeight;
        minCaveHeight = WorleyConfig.minCaveHeight;
        noiseCutoff = (float)WorleyConfig.noiseCutoffValue;
        warpAmplifier = (float)WorleyConfig.warpAmplifier;
        easeInDepth = WorleyConfig.easeInDepth;
        yCompression = (float)WorleyConfig.verticalCompressionMultiplier;
        xzCompression = (float)WorleyConfig.horizonalCompressionMultiplier;
        surfaceCutoff = (float)WorleyConfig.surfaceCutoffValue;
        lavaDepth = WorleyConfig.lavaDepth;
        lavaBlock = BlockUtil.getStateFromString(WorleyConfig.lavaBlock, Blocks.field_150353_l.func_176223_P());
    }

    public boolean carve(IChunk chunkIn, Random rand, int seaLevel, int chunkX, int chunkZ, int chunkXOffset, int chunkZOffset, BitSet carvingMask, ProbabilityConfig config) {
        if (chunkXOffset != chunkX || chunkZOffset != chunkZ) {
            return false;
        }
        this.debugValueAdjustments();
        boolean logTime = false;
        long millis = 0L;
        if (logTime) {
            millis = System.currentTimeMillis();
        }
        this.carveWorleyCaves(chunkIn, seaLevel, chunkX, chunkZ);
        if (logTime) {
            this.genTime[this.currentTimeIndex] = System.currentTimeMillis() - millis;
            this.sum += (double)this.genTime[this.currentTimeIndex];
            ++this.currentTimeIndex;
            if (this.currentTimeIndex == this.genTime.length) {
                System.out.printf("300 chunk average: %.2f ms per chunk\n", this.sum / 300.0);
                this.sum = 0.0;
                this.currentTimeIndex = 0;
            }
        }
        return true;
    }

    protected void carveWorleyCaves(IChunk chunk, int seaLevel, int chunkX, int chunkZ) {
        int chunkMaxHeight = this.getMaxSurfaceHeight(chunk);
        float[][][] samples = this.sampleNoise(chunkX, chunkZ, chunkMaxHeight + 1);
        float oneQuarter = 0.25f;
        float oneHalf = 0.5f;
        for (int x = 0; x < 4; ++x) {
            for (int z = 0; z < 4; ++z) {
                int depth = 0;
                for (int y = maxCaveHeight / 2 - 1; y >= 0; --y) {
                    float x0y0z0 = samples[x][y][z];
                    float x0y0z1 = samples[x][y][z + 1];
                    float x1y0z0 = samples[x + 1][y][z];
                    float x1y0z1 = samples[x + 1][y][z + 1];
                    float x0y1z0 = samples[x][y + 1][z];
                    float x0y1z1 = samples[x][y + 1][z + 1];
                    float x1y1z0 = samples[x + 1][y + 1][z];
                    float x1y1z1 = samples[x + 1][y + 1][z + 1];
                    float noiseStepY00 = (x0y1z0 - x0y0z0) * -oneHalf;
                    float noiseStepY01 = (x0y1z1 - x0y0z1) * -oneHalf;
                    float noiseStepY10 = (x1y1z0 - x1y0z0) * -oneHalf;
                    float noiseStepY11 = (x1y1z1 - x1y0z1) * -oneHalf;
                    float noiseStartX0 = x0y0z0;
                    float noiseStartX1 = x0y0z1;
                    float noiseEndX0 = x1y0z0;
                    float noiseEndX1 = x1y0z1;
                    for (int suby = 1; suby >= 0; --suby) {
                        int localY = suby + y * 2;
                        float noiseStartZ = noiseStartX0;
                        float noiseEndZ = noiseStartX1;
                        float noiseStepX0 = (noiseEndX0 - noiseStartX0) * oneQuarter;
                        float noiseStepX1 = (noiseEndX1 - noiseStartX1) * oneQuarter;
                        for (int subx = 0; subx < 4; ++subx) {
                            int localX = subx + x * 4;
                            float noiseStepZ = (noiseEndZ - noiseStartZ) * oneQuarter;
                            float noiseVal = noiseStartZ;
                            for (int subz = 0; subz < 4; ++subz) {
                                BlockState aboveBlock;
                                int localZ = subz + z * 4;
                                if (depth == 0) {
                                    if (subx != 0 || subz != 0) continue;
                                    BlockState currentBlock = chunk.func_180495_p(new BlockPos(localX, localY, localZ));
                                    if (this.canReplaceBlock(currentBlock, AIR) || this.isBiomeBlock(chunk, new BlockPos(localX, localY, localZ))) {
                                        ++depth;
                                    }
                                } else if (subx == 0 && subz == 0) {
                                    ++depth;
                                }
                                float adjustedNoiseCutoff = noiseCutoff;
                                if ((float)depth < easeInDepth) {
                                    adjustedNoiseCutoff = (float)MathHelper.func_151238_b((double)noiseCutoff, (double)surfaceCutoff, (double)((easeInDepth - (float)depth) / easeInDepth));
                                }
                                if (localY < minCaveHeight + 5) {
                                    adjustedNoiseCutoff = (float)((double)adjustedNoiseCutoff + (double)(minCaveHeight + 5 - localY) * 0.05);
                                }
                                if (noiseVal > adjustedNoiseCutoff && (!this.isFluidBlock(aboveBlock = (BlockState)MoreObjects.firstNonNull((Object)chunk.func_180495_p(new BlockPos(localX, localY + 1, localZ)), (Object)Blocks.field_150350_a.func_176223_P())) || localY <= lavaDepth)) {
                                    if (((float)depth < easeInDepth || localY > seaLevel - 8 || additionalWaterChecks) && localY > lavaDepth && (localX < 15 && this.isFluidBlock(chunk.func_180495_p(new BlockPos(localX + 1, localY, localZ))) || localX > 0 && this.isFluidBlock(chunk.func_180495_p(new BlockPos(localX - 1, localY, localZ))) || localZ < 15 && this.isFluidBlock(chunk.func_180495_p(new BlockPos(localX, localY, localZ + 1))) || localZ > 0 && this.isFluidBlock(chunk.func_180495_p(new BlockPos(localX, localY, localZ - 1))))) continue;
                                    BlockState currentBlock = chunk.func_180495_p(new BlockPos(localX, localY, localZ));
                                    boolean foundTopBlock = false;
                                    if (this.isTopBlock(chunk, localX, localY, localZ, chunkX, chunkZ)) {
                                        foundTopBlock = true;
                                    }
                                    this.digBlock(chunk, new BlockPos(localX, localY, localZ), chunkX, chunkZ, foundTopBlock, currentBlock, aboveBlock);
                                }
                                noiseVal += noiseStepZ;
                            }
                            noiseStartZ += noiseStepX0;
                            noiseEndZ += noiseStepX1;
                        }
                        noiseStartX0 += noiseStepY00;
                        noiseStartX1 += noiseStepY01;
                        noiseEndX0 += noiseStepY10;
                        noiseEndX1 += noiseStepY11;
                    }
                }
            }
        }
    }

    public float[][][] sampleNoise(int chunkX, int chunkZ, int maxSurfaceHeight) {
        int originalMaxHeight = 128;
        float[][][] noiseSamples = new float[5][129][5];
        for (int x = 0; x < 5; ++x) {
            int realX = x * 4 + chunkX * 16;
            for (int z = 0; z < 5; ++z) {
                int realZ = z * 4 + chunkZ * 16;
                for (int y = 128; y >= 0; --y) {
                    float noiseTwoAbove;
                    float noise;
                    float realY = y * 2;
                    if (realY > (float)maxSurfaceHeight || realY > (float)maxCaveHeight || realY < (float)minCaveHeight) {
                        noiseSamples[x][y][z] = -1.1f;
                        continue;
                    }
                    float dispAmp = (float)((double)warpAmplifier * ((double)(originalMaxHeight - y) / ((double)originalMaxHeight * 0.85)));
                    float xDisp = 0.0f;
                    float yDisp = 0.0f;
                    float zDisp = 0.0f;
                    xDisp = this.displacementNoisePerlin.GetNoise(realX, realY, realZ) * dispAmp;
                    yDisp = this.displacementNoisePerlin.GetNoise(realX, realY - 256.0f, realZ) * dispAmp;
                    zDisp = this.displacementNoisePerlin.GetNoise(realX, realY - 512.0f, realZ) * dispAmp;
                    noiseSamples[x][y][z] = noise = this.worleyF1divF3.SingleCellular3Edge((float)realX * xzCompression + xDisp, realY * yCompression + yDisp, (float)realZ * xzCompression + zDisp);
                    if (!(noise > noiseCutoff)) continue;
                    if (x > 0) {
                        noiseSamples[x - 1][y][z] = noise * 0.2f + noiseSamples[x - 1][y][z] * 0.8f;
                    }
                    if (z > 0) {
                        noiseSamples[x][y][z - 1] = noise * 0.2f + noiseSamples[x][y][z - 1] * 0.8f;
                    }
                    if (y >= 128) continue;
                    float noiseAbove = noiseSamples[x][y + 1][z];
                    if (noise > noiseAbove) {
                        noiseSamples[x][y + 1][z] = noise * 0.8f + noiseAbove * 0.2f;
                    }
                    if (y >= 127 || !(noise > (noiseTwoAbove = noiseSamples[x][y + 2][z]))) continue;
                    noiseSamples[x][y + 2][z] = noise * 0.35f + noiseTwoAbove * 0.65f;
                }
            }
        }
        return noiseSamples;
    }

    private int getSurfaceHeight(IChunk chunk, int localX, int localZ) {
        return this.recursiveBinarySurfaceSearch(chunk, localX, localZ, 255, 0);
    }

    private int recursiveBinarySurfaceSearch(IChunk chunk, int localX, int localZ, int searchTop, int searchBottom) {
        int top = searchTop;
        if (searchTop > searchBottom) {
            int searchMid = (searchBottom + searchTop) / 2;
            top = this.canReplaceBlock(chunk.func_180495_p(new BlockPos(localX, searchMid, localZ)), AIR) ? this.recursiveBinarySurfaceSearch(chunk, localX, localZ, searchTop, searchMid + 1) : this.recursiveBinarySurfaceSearch(chunk, localX, localZ, searchMid, searchBottom);
        }
        return top;
    }

    private int getMaxSurfaceHeight(IChunk chunk) {
        int max = 0;
        int[] testcords = new int[]{0, 7, 15};
        for (int n = 0; n < testcords.length; ++n) {
            for (int m = 0; m < testcords.length; ++m) {
                int testmax = this.getSurfaceHeight(chunk, testcords[n], testcords[m]);
                if (testmax <= max) continue;
                max = testmax;
            }
        }
        return max;
    }

    private boolean isBiomeBlock(IChunk chunk, BlockPos blockPos) {
        Biome biome = chunk.func_217309_c(blockPos);
        BlockState blockState = chunk.func_180495_p(blockPos);
        return blockState == biome.func_203944_q().func_204108_a() || blockState == biome.func_203944_q().func_204109_b();
    }

    private boolean isFluidBlock(BlockState state) {
        Block blocky = state.func_177230_c();
        return blocky instanceof IFluidBlock;
    }

    private boolean isTopBlock(IChunk chunk, int x, int y, int z, int chunkX, int chunkZ) {
        Biome biome = chunk.func_217309_c(new BlockPos(x + chunkX * 16, 0, z + chunkZ * 16));
        BlockState state = chunk.func_180495_p(new BlockPos(x, y, z));
        return this.isExceptionBiome(biome) ? state.func_177230_c() == Blocks.field_150349_c : state == biome.func_203944_q().func_204108_a();
    }

    private boolean isExceptionBiome(Biome biome) {
        if (biome == Biomes.field_76787_r) {
            return true;
        }
        return biome == Biomes.field_76769_d;
    }

    public boolean shouldCarve(Random rand, int chunkX, int chunkZ, ProbabilityConfig config) {
        return true;
    }

    protected boolean func_222708_a(double p_222708_1_, double p_222708_3_, double p_222708_5_, int p_222708_7_) {
        return false;
    }

    private boolean canReplaceBlock(BlockState state, BlockState stateUp) {
        return state.func_185904_a() == Material.field_151576_e || super.func_222707_a(state, stateUp);
    }

    private void digBlock(IChunk chunk, BlockPos blockPos, int chunkX, int chunkZ, boolean foundTop, BlockState state, BlockState blockStateUp) {
        Biome biome = chunk.func_217309_c(blockPos);
        BlockState top = biome.func_203944_q().func_204108_a();
        BlockState filler = biome.func_203944_q().func_204109_b();
        if (this.canReplaceBlock(state, blockStateUp) || state.func_177230_c() == top.func_177230_c() || state.func_177230_c() == filler.func_177230_c()) {
            if (blockPos.func_177956_o() <= lavaDepth) {
                chunk.func_177436_a(blockPos, lavaBlock, false);
            } else {
                chunk.func_177436_a(blockPos, AIR, false);
                if (foundTop && chunk.func_180495_p(blockPos.func_177977_b()).func_177230_c() == filler.func_177230_c()) {
                    chunk.func_177436_a(blockPos.func_177977_b(), top, false);
                }
                if (blockStateUp == Blocks.field_150354_m.func_176223_P()) {
                    chunk.func_177436_a(blockPos.func_177984_a(), Blocks.field_150322_A.func_176223_P(), false);
                } else if (blockStateUp == Blocks.field_196611_F.func_176223_P()) {
                    chunk.func_177436_a(blockPos.func_177984_a(), Blocks.field_180395_cM.func_176223_P(), false);
                }
            }
        }
    }

    static {
        additionalWaterChecks = false;
    }
}

