/*
 * Decompiled with CFR 0.152.
 */
package fluke.worleycaves.config;

import net.minecraftforge.common.ForgeConfigSpec;

public class ServerConfig {
    final ForgeConfigSpec.ConfigValue<Integer> lavaDepth;
    final ForgeConfigSpec.ConfigValue<Integer> easeInDepth;
    final ForgeConfigSpec.ConfigValue<String> lavaBlock;
    final ForgeConfigSpec.ConfigValue<Integer> maxCaveHeight;
    final ForgeConfigSpec.ConfigValue<Integer> minCaveHeight;
    final ForgeConfigSpec.ConfigValue<Double> noiseCutoffValue;
    final ForgeConfigSpec.ConfigValue<Double> surfaceCutoffValue;
    final ForgeConfigSpec.ConfigValue<Double> verticalCompressionMultiplier;
    final ForgeConfigSpec.ConfigValue<Double> horizonalCompressionMultiplier;
    final ForgeConfigSpec.ConfigValue<Double> warpAmplifier;

    ServerConfig(ForgeConfigSpec.Builder builder) {
        builder.push("general");
        this.lavaDepth = builder.comment("\nAir blocks at or below this y level will generate as lavaBlock \nDefault: 10").translation("worleycaves.config.lavaDepth").worldRestart().defineInRange("lavaDepth", 10, 0, 255);
        this.easeInDepth = builder.comment("\nReduces number of caves at surface level, becoming more common until caves generate normally X number of blocks below the surface \nDefault: 15").translation("worleycaves.config.easeInDepth").worldRestart().define("easeInDepth", (Object)15);
        this.lavaBlock = builder.comment("\nBlock to use when generating large lava lakes below lavaDepth (usually y=10) \nDefault: minecraft:lava").translation("worleycaves.config.lavaBlock").worldRestart().define("lavaBlock", (Object)"minecraft:lava");
        this.maxCaveHeight = builder.comment("\nCaves will not attempt to generate above this y level. \nDefault: 128").translation("worleycaves.config.maxCaveHeight").worldRestart().defineInRange("maxCaveHeight", 128, 1, 256);
        this.minCaveHeight = builder.comment("\nCaves will not attempt to generate below this y level. \nDefault: 1").translation("worleycaves.config.minCaveHeight").worldRestart().defineInRange("minCaveHeight", 1, 1, 256);
        this.noiseCutoffValue = builder.comment("\nControls size of caves. Smaller values = larger caves. \nDefault: -0.18").translation("worleycaves.config.noiseCutoffValue").worldRestart().defineInRange("noiseCutoffValue", -0.18, -1.0, 1.0);
        this.surfaceCutoffValue = builder.comment("\nControls size of caves at the surface. Smaller values = more caves break through the surface. \nDefault: -0.081 (45% of noiseCutoffValue)").translation("worleycaves.config.noiseCutoffValue").worldRestart().defineInRange("surfaceCutoffValue", -0.081, -1.0, 1.0);
        this.verticalCompressionMultiplier = builder.comment("\nSquishes caves on the Y axis. Lower values = taller caves and more steep drops \nDefault: 2.0").translation("worleycaves.config.verticalCompressionMultiplier").worldRestart().define("verticalCompressionMultiplier", (Object)2.0);
        this.horizonalCompressionMultiplier = builder.comment("\nStreches (when < 1.0) or compresses (when > 1.0) cave generation along X and Z axis \nDefault: 1.0").translation("worleycaves.config.horizonalCompressionMultiplier").worldRestart().define("horizonalCompressionMultiplier", (Object)1.0);
        this.warpAmplifier = builder.comment("\nControls how much to warp caves. Lower values = straighter caves \nDefault: 8.0").translation("worleycaves.config.warpAmplifier").worldRestart().define("warpAmplifier", (Object)8.0);
        builder.pop();
    }
}

