/*
 * Decompiled with CFR 0.152.
 */
package fluke.worleycaves.proxy;

import fluke.worleycaves.config.ConfigHelper;
import fluke.worleycaves.config.ConfigHolder;
import fluke.worleycaves.world.WorldCarverWorley;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.carver.CaveWorldCarver;
import net.minecraft.world.gen.carver.ConfiguredCarver;
import net.minecraft.world.gen.carver.ICarverConfig;
import net.minecraft.world.gen.carver.UnderwaterCaveWorldCarver;
import net.minecraft.world.gen.carver.WorldCarver;
import net.minecraft.world.gen.feature.ProbabilityConfig;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.ForgeRegistries;

public class CommonProxy {
    private WorldCarverWorley worleyCarver;
    private ConfiguredCarver<ProbabilityConfig> configuredWorleyCarver;
    private long worldSeed;
    private boolean seedsSet = false;

    public void start() {
        IEventBus fmlBus = FMLJavaModLoadingContext.get().getModEventBus();
        IEventBus forgeBus = MinecraftForge.EVENT_BUS;
        this.worleyCarver = new WorldCarverWorley(ProbabilityConfig::func_214645_a, 256);
        this.configuredWorleyCarver = Biome.func_203606_a((WorldCarver)this.worleyCarver, (ICarverConfig)new ProbabilityConfig(1.0f));
        this.registerListeners(fmlBus, forgeBus);
    }

    public void registerListeners(IEventBus fmlBus, IEventBus forgeBus) {
        fmlBus.addListener(this::configChanged);
        fmlBus.addListener(this::commonSetup);
        forgeBus.addListener(this::worldLoad);
        forgeBus.addListener(this::worldCreateSpawn);
        forgeBus.addListener(this::worldUnload);
    }

    public void commonSetup(FMLCommonSetupEvent event) {
        ForgeRegistries.BIOMES.forEach((Consumer)new Consumer<Biome>(){

            @Override
            public void accept(Biome b) {
                if (b.func_201856_r() == Biome.Category.NETHER || b.func_201856_r() == Biome.Category.THEEND || b.func_201856_r() == Biome.Category.NONE) {
                    return;
                }
                List carversAir = b.func_203603_a(GenerationStage.Carving.AIR);
                Iterator iteratorCarversAir = carversAir.iterator();
                while (iteratorCarversAir.hasNext()) {
                    ConfiguredCarver carver = (ConfiguredCarver)iteratorCarversAir.next();
                    if (!(carver.field_222732_a instanceof CaveWorldCarver)) continue;
                    iteratorCarversAir.remove();
                }
                List carversLiquid = b.func_203603_a(GenerationStage.Carving.LIQUID);
                Iterator iteratorCarversLiquid = carversLiquid.iterator();
                while (iteratorCarversLiquid.hasNext()) {
                    ConfiguredCarver carver = (ConfiguredCarver)iteratorCarversLiquid.next();
                    if (!(carver.field_222732_a instanceof UnderwaterCaveWorldCarver)) continue;
                    iteratorCarversLiquid.remove();
                }
                b.func_203603_a(GenerationStage.Carving.AIR).add(CommonProxy.this.configuredWorleyCarver);
            }
        });
    }

    public void configChanged(ModConfig.ModConfigEvent event) {
        ModConfig config = event.getConfig();
        if (config.getSpec() == ConfigHolder.CLIENT_SPEC) {
            ConfigHelper.bakeClient(config);
        } else if (config.getSpec() == ConfigHolder.SERVER_SPEC) {
            ConfigHelper.bakeServer(config);
        }
    }

    public void worldLoad(WorldEvent.Load event) {
        this.setWorldSeed((WorldEvent)event);
    }

    public void worldCreateSpawn(WorldEvent.CreateSpawnPosition event) {
        this.setWorldSeed((WorldEvent)event);
    }

    public void worldUnload(WorldEvent.Unload event) {
        if (event.getWorld().func_201675_m().func_76569_d()) {
            this.seedsSet = false;
            this.worldSeed = 0L;
        }
    }

    public void setWorldSeed(WorldEvent event) {
        if (this.seedsSet) {
            return;
        }
        long seed = event.getWorld().func_72905_C();
        if (seed != 0L) {
            this.worldSeed = seed;
        }
        this.worleyCarver.init(this.worldSeed);
    }
}

