/*
 * Decompiled with CFR 0.152.
 */
package net.spellcraftgaming.rpghud.gui.hud.element.defaulthud;

import net.minecraft.client.gui.Gui;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.spellcraftgaming.lib.GameData;
import net.spellcraftgaming.rpghud.gui.hud.element.HudElement;
import net.spellcraftgaming.rpghud.gui.hud.element.HudElementType;

public class HudElementFoodDefault
extends HudElement {
    public HudElementFoodDefault() {
        super(HudElementType.FOOD, 0, 0, 0, 0, true);
        this.parent = HudElementType.WIDGET;
    }

    @Override
    public boolean checkConditions() {
        return GameData.shouldDrawHUD();
    }

    @Override
    public void drawElement(Gui gui, float zLevel, float partialTicks) {
        int stamina = GameData.getPlayerFood();
        int foodMax = GameData.getPlayerMaxFood();
        int posX = (this.settings.getBoolValue("render_player_face") != false ? 49 : 24) + this.settings.getPositionValue("hunger_position")[0];
        int posY = (this.settings.getBoolValue("render_player_face") != false ? 26 : 18) + this.settings.getPositionValue("hunger_position")[1];
        ItemStack itemMain = GameData.getMainhand();
        ItemStack itemSec = GameData.getOffhand();
        if (GameData.doesPlayerNeedFood() && this.settings.getBoolValue("show_hunger_preview").booleanValue()) {
            float value = 0.0f;
            if (itemMain != GameData.nullStack() && itemMain.func_77973_b() instanceof ItemFood) {
                value = ((ItemFood)itemMain.func_77973_b()).func_150905_g(itemMain);
            } else if (itemSec != GameData.nullStack() && itemSec.func_77973_b() instanceof ItemFood) {
                value = ((ItemFood)itemSec.func_77973_b()).func_150905_g(itemSec);
            }
            if (value > 0.0f) {
                int bonusHunger = (int)(value + (float)stamina);
                if (bonusHunger > foodMax) {
                    bonusHunger = foodMax;
                }
                int colorPreview = HudElementFoodDefault.offsetColor(this.settings.getIntValue("color_food"), 0x5A5A5A);
                HudElementFoodDefault.drawCustomBar(posX, posY, 110, 12, (double)bonusHunger / (double)foodMax * 100.0, -1, -1, colorPreview, HudElementFoodDefault.offsetColorPercent(colorPreview, 25));
            }
        }
        if (GameData.isPlayerHungered()) {
            HudElementFoodDefault.drawCustomBar(posX, posY, 110, 12, (double)stamina / (double)foodMax * 100.0, -1, -1, this.settings.getIntValue("color_hunger"), HudElementFoodDefault.offsetColorPercent(this.settings.getIntValue("color_hunger"), 25));
        } else {
            HudElementFoodDefault.drawCustomBar(posX, posY, 110, 12, (double)stamina / (double)foodMax * 100.0, -1, -1, this.settings.getIntValue("color_food"), HudElementFoodDefault.offsetColorPercent(this.settings.getIntValue("color_food"), 25));
        }
        String staminaString = stamina + "/" + foodMax;
        if (this.settings.getBoolValue("show_numbers_food").booleanValue()) {
            gui.func_73732_a(GameData.getFontRenderer(), staminaString, posX + 55, posY + 2, -1);
        }
    }
}

