/*
 * Decompiled with CFR 0.152.
 */
package net.spellcraftgaming.rpghud.gui.hud.element.extended;

import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.EntityLivingBase;
import net.spellcraftgaming.lib.GameData;
import net.spellcraftgaming.rpghud.gui.hud.element.HudElement;
import net.spellcraftgaming.rpghud.gui.hud.element.HudElementType;

public class HudElementHealthMountExtended
extends HudElement {
    public HudElementHealthMountExtended() {
        super(HudElementType.HEALTH_MOUNT, 0, 0, 0, 0, false);
        this.parent = HudElementType.WIDGET;
    }

    @Override
    public boolean checkConditions() {
        return GameData.isRidingLivingMount() && GameData.shouldDrawHUD();
    }

    @Override
    public void drawElement(Gui gui, float zLevel, float partialTicks) {
        EntityLivingBase mount = (EntityLivingBase)GameData.getMount();
        int health = (int)Math.ceil(mount.func_110143_aJ());
        int healthMax = (int)mount.func_110138_aP();
        int posX = (this.settings.getBoolValue("render_player_face") != false ? 53 : 25) + this.settings.getPositionValue("mount_health_position")[0];
        int posY = (this.settings.getBoolValue("render_player_face") != false ? 54 : 49) + this.settings.getPositionValue("mount_health_position")[1];
        HudElementHealthMountExtended.drawCustomBar(posX, posY, 88, 8, (double)health / (double)healthMax * 100.0, -1, -1, this.settings.getIntValue("color_health"), HudElementHealthMountExtended.offsetColorPercent(this.settings.getIntValue("color_health"), 25));
        String stringHealth = health + "/" + healthMax;
        if (this.settings.getBoolValue("show_numbers_health").booleanValue()) {
            GlStateManager.func_179139_a((double)0.5, (double)0.5, (double)0.5);
            gui.func_73732_a(GameData.getFontRenderer(), stringHealth, posX * 2 + 82, posY * 2 + 4, -1);
            GlStateManager.func_179139_a((double)2.0, (double)2.0, (double)2.0);
        }
    }
}

