/*
 * Decompiled with CFR 0.152.
 */
package net.spellcraftgaming.lib.gui.override;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiNewChat;
import net.minecraft.client.gui.GuiOverlayDebug;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.network.NetHandlerPlayClient;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.MobEffects;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.scoreboard.ScoreObjective;
import net.minecraft.scoreboard.ScorePlayerTeam;
import net.minecraft.scoreboard.Scoreboard;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StringUtils;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.client.GuiIngameForge;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.spellcraftgaming.lib.gui.override.GuiChatRPGHud;
import net.spellcraftgaming.rpghud.gui.hud.element.HudElementType;
import net.spellcraftgaming.rpghud.main.ModRPGHud;

public class GuiIngameRPGHud
extends GuiIngameForge {
    private static final int WHITE = 0xFFFFFF;
    private ScaledResolution res = null;
    private FontRenderer fontrenderer = null;
    private RenderGameOverlayEvent eventParent;
    private GuiOverlayDebugForge debugOverlay;
    private ModRPGHud rpgHud;
    private final GuiChatRPGHud chat;

    public GuiIngameRPGHud(Minecraft mc) {
        super(mc);
        this.debugOverlay = new GuiOverlayDebugForge(mc);
        this.rpgHud = ModRPGHud.instance;
        this.chat = new GuiChatRPGHud(mc);
    }

    public void func_175180_a(float partialTicks) {
        ScoreObjective scoreobjective1;
        int slot;
        this.res = new ScaledResolution(this.field_73839_d);
        this.eventParent = new RenderGameOverlayEvent(partialTicks, this.res);
        int width = this.res.func_78326_a();
        int height = this.res.func_78328_b();
        right_height = 39;
        left_height = 39;
        if (this.pre(RenderGameOverlayEvent.ElementType.ALL)) {
            return;
        }
        this.fontrenderer = this.field_73839_d.field_71466_p;
        this.field_73839_d.field_71460_t.func_78478_c();
        GlStateManager.func_179147_l();
        if (Minecraft.func_71375_t()) {
            this.func_180480_a(this.field_73839_d.field_71439_g.func_70013_c(partialTicks), this.res);
        } else {
            GlStateManager.func_179126_j();
            GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        }
        this.renderHelmet(this.res, partialTicks);
        if (!this.field_73839_d.field_71439_g.func_70644_a(MobEffects.field_76431_k)) {
            this.renderPortalMod(this.res, partialTicks);
        }
        this.drawElement(HudElementType.WIDGET, partialTicks);
        this.drawElement(HudElementType.HOTBAR, partialTicks);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_73735_i = -90.0f;
        this.field_73842_c.setSeed(this.field_73837_f * 312871);
        this.drawElement(HudElementType.CROSSHAIR, partialTicks);
        this.renderBossHealthMod();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.field_73839_d.func_175606_aa() instanceof EntityPlayer) {
            this.drawElement(HudElementType.HEALTH, partialTicks);
            this.drawElement(HudElementType.ARMOR, partialTicks);
            this.drawElement(HudElementType.FOOD, partialTicks);
            this.drawElement(HudElementType.HEALTH_MOUNT, partialTicks);
            this.drawElement(HudElementType.AIR, partialTicks);
            this.drawElement(HudElementType.CLOCK, partialTicks);
            this.drawElement(HudElementType.DETAILS, partialTicks);
            this.drawElement(HudElementType.COMPASS, partialTicks);
            this.drawElement(HudElementType.PICKUP, partialTicks);
            this.drawElement(HudElementType.ENTITY_INSPECT, partialTicks);
        }
        this.renderSleepFadeMod(width, height);
        this.drawElement(HudElementType.EXPERIENCE, partialTicks);
        this.drawElement(HudElementType.LEVEL, partialTicks);
        this.drawElement(HudElementType.JUMP_BAR, partialTicks);
        this.renderToolHighlightMod(this.res);
        this.renderHUDText(width);
        this.renderFPSGraphMod();
        this.renderPotionIconsMod(this.res);
        this.drawElement(HudElementType.RECORD_OVERLAY, partialTicks);
        this.renderSubtitles();
        this.renderTitleMod(width, height, partialTicks);
        Scoreboard scoreboard = this.field_73839_d.field_71441_e.func_96441_U();
        ScoreObjective objective = null;
        ScorePlayerTeam scoreplayerteam = scoreboard.func_96509_i(this.field_73839_d.field_71439_g.func_70005_c_());
        if (scoreplayerteam != null && (slot = scoreplayerteam.func_178775_l().func_175746_b()) >= 0) {
            objective = scoreboard.func_96539_a(3 + slot);
        }
        ScoreObjective scoreObjective = scoreobjective1 = objective != null ? objective : scoreboard.func_96539_a(1);
        if (scoreobjective1 != null) {
            this.func_180475_a(scoreobjective1, this.res);
        }
        GlStateManager.func_179147_l();
        GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
        GlStateManager.func_179118_c();
        this.drawElementChat(partialTicks);
        this.renderPlayerList(width);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179140_f();
        GlStateManager.func_179141_d();
        this.post(RenderGameOverlayEvent.ElementType.ALL);
    }

    public ScaledResolution getResolution() {
        return this.res;
    }

    private void renderPotionIconsMod(ScaledResolution resolution) {
        if (this.pre(RenderGameOverlayEvent.ElementType.POTION_ICONS)) {
            return;
        }
        super.func_184048_a(resolution);
        this.post(RenderGameOverlayEvent.ElementType.POTION_ICONS);
    }

    private void renderSubtitles() {
        if (this.pre(RenderGameOverlayEvent.ElementType.SUBTITLES)) {
            return;
        }
        this.field_184049_t.func_184068_a(this.res);
        this.post(RenderGameOverlayEvent.ElementType.SUBTITLES);
    }

    private void renderBossHealthMod() {
        if (this.pre(RenderGameOverlayEvent.ElementType.BOSSHEALTH)) {
            return;
        }
        this.bind(Gui.field_110324_m);
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        this.field_73839_d.field_71424_I.func_76320_a("bossHealth");
        GlStateManager.func_179147_l();
        this.field_184050_w.func_184051_a();
        GlStateManager.func_179084_k();
        this.field_73839_d.field_71424_I.func_76319_b();
        this.post(RenderGameOverlayEvent.ElementType.BOSSHEALTH);
    }

    private void renderHelmet(ScaledResolution res, float partialTicks) {
        if (this.pre(RenderGameOverlayEvent.ElementType.HELMET)) {
            return;
        }
        ItemStack itemstack = this.field_73839_d.field_71439_g.field_71071_by.func_70440_f(3);
        if (this.field_73839_d.field_71474_y.field_74320_O == 0 && itemstack != null && itemstack.func_77973_b() != null) {
            if (itemstack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150423_aK)) {
                this.func_180476_e(res);
            } else {
                itemstack.func_77973_b().renderHelmetOverlay(itemstack, (EntityPlayer)this.field_73839_d.field_71439_g, res, partialTicks);
            }
        }
        this.post(RenderGameOverlayEvent.ElementType.HELMET);
    }

    private void renderPortalMod(ScaledResolution res, float partialTicks) {
        if (this.pre(RenderGameOverlayEvent.ElementType.PORTAL)) {
            return;
        }
        float f1 = this.field_73839_d.field_71439_g.field_71080_cy + (this.field_73839_d.field_71439_g.field_71086_bY - this.field_73839_d.field_71439_g.field_71080_cy) * partialTicks;
        if (f1 > 0.0f) {
            this.func_180474_b(f1, res);
        }
        this.post(RenderGameOverlayEvent.ElementType.PORTAL);
    }

    private void renderSleepFadeMod(int width, int height) {
        if (this.field_73839_d.field_71439_g.func_71060_bI() > 0) {
            this.field_73839_d.field_71424_I.func_76320_a("sleep");
            GlStateManager.func_179097_i();
            GlStateManager.func_179118_c();
            int sleepTime = this.field_73839_d.field_71439_g.func_71060_bI();
            float opacity = (float)sleepTime / 100.0f;
            if (opacity > 1.0f) {
                opacity = 1.0f - (float)(sleepTime - 100) / 10.0f;
            }
            int color = (int)(220.0f * opacity) << 24 | 0x101020;
            GuiIngameRPGHud.func_73734_a((int)0, (int)0, (int)width, (int)height, (int)color);
            GlStateManager.func_179141_d();
            GlStateManager.func_179126_j();
            this.field_73839_d.field_71424_I.func_76319_b();
        }
    }

    private void renderToolHighlightMod(ScaledResolution res) {
        if (this.field_73839_d.field_71474_y.field_92117_D && !this.field_73839_d.field_71442_b.func_78747_a()) {
            this.field_73839_d.field_71424_I.func_76320_a("toolHighlight");
            if (this.field_92017_k > 0 && this.field_92016_l != null) {
                String name = this.field_92016_l.func_82833_r();
                if (this.field_92016_l.func_82837_s()) {
                    name = TextFormatting.ITALIC + name;
                }
                name = this.field_92016_l.func_77973_b().getHighlightTip(this.field_92016_l, name);
                int opacity = (int)((float)this.field_92017_k * 256.0f / 10.0f);
                if (opacity > 255) {
                    opacity = 255;
                }
                if (opacity > 0) {
                    int y = res.func_78328_b() - 59;
                    if (!this.field_73839_d.field_71442_b.func_78755_b()) {
                        y += 14;
                    }
                    GlStateManager.func_179094_E();
                    GlStateManager.func_179147_l();
                    GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
                    FontRenderer font = this.field_92016_l.func_77973_b().getFontRenderer(this.field_92016_l);
                    if (font != null) {
                        int x = (res.func_78326_a() - font.func_78256_a(name)) / 2;
                        font.func_175063_a(name, (float)x, (float)y, 0xFFFFFF | opacity << 24);
                    } else {
                        int x = (res.func_78326_a() - this.fontrenderer.func_78256_a(name)) / 2;
                        this.fontrenderer.func_175063_a(name, (float)x, (float)y, 0xFFFFFF | opacity << 24);
                    }
                    GlStateManager.func_179084_k();
                    GlStateManager.func_179121_F();
                }
            }
            this.field_73839_d.field_71424_I.func_76319_b();
        } else if (this.field_73839_d.field_71439_g.func_175149_v()) {
            this.field_175197_u.func_175263_a(res);
        }
    }

    private void renderHUDText(int width) {
        RenderGameOverlayEvent.Text event;
        this.field_73839_d.field_71424_I.func_76320_a("forgeHudText");
        OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
        ArrayList<String> listL = new ArrayList<String>();
        ArrayList<String> listR = new ArrayList<String>();
        if (this.field_73839_d.func_71355_q()) {
            long time = this.field_73839_d.field_71441_e.func_82737_E();
            if (time >= 120500L) {
                listR.add(I18n.func_135052_a((String)"demo.demoExpired", (Object[])new Object[0]));
            } else {
                listR.add(I18n.func_135052_a((String)"demo.remainingTime", (Object[])new Object[]{StringUtils.func_76337_a((int)((int)(120500L - time)))}));
            }
        }
        if (this.field_73839_d.field_71474_y.field_74330_P && !this.pre(RenderGameOverlayEvent.ElementType.DEBUG)) {
            listL.addAll(this.debugOverlay.getLeft());
            listR.addAll(this.debugOverlay.getRight());
            this.post(RenderGameOverlayEvent.ElementType.DEBUG);
        }
        if (!MinecraftForge.EVENT_BUS.post((Event)(event = new RenderGameOverlayEvent.Text(this.eventParent, listL, listR)))) {
            int top = 2;
            for (String msg : listL) {
                if (msg == null) continue;
                GuiIngameRPGHud.func_73734_a((int)1, (int)(top - 1), (int)(2 + this.fontrenderer.func_78256_a(msg) + 1), (int)(top + this.fontrenderer.field_78288_b - 1), (int)-1873784752);
                this.fontrenderer.func_78276_b(msg, 2, top, 0xE0E0E0);
                top += this.fontrenderer.field_78288_b;
            }
            top = 2;
            for (String msg : listR) {
                if (msg == null) continue;
                int w = this.fontrenderer.func_78256_a(msg);
                int left = width - 2 - w;
                GuiIngameRPGHud.func_73734_a((int)(left - 1), (int)(top - 1), (int)(left + w + 1), (int)(top + this.fontrenderer.field_78288_b - 1), (int)-1873784752);
                this.fontrenderer.func_78276_b(msg, left, top, 0xE0E0E0);
                top += this.fontrenderer.field_78288_b;
            }
        }
        this.field_73839_d.field_71424_I.func_76319_b();
        this.post(RenderGameOverlayEvent.ElementType.TEXT);
    }

    private void renderFPSGraphMod() {
        if (this.field_73839_d.field_71474_y.field_74330_P && this.field_73839_d.field_71474_y.field_181657_aC && !this.pre(RenderGameOverlayEvent.ElementType.FPS_GRAPH)) {
            this.debugOverlay.func_181554_e();
            this.post(RenderGameOverlayEvent.ElementType.FPS_GRAPH);
        }
    }

    private void renderTitleMod(int width, int height, float partialTicks) {
        if (this.field_175195_w > 0) {
            this.field_73839_d.field_71424_I.func_76320_a("titleAndSubtitle");
            float age = (float)this.field_175195_w - partialTicks;
            int opacity = 255;
            if (this.field_175195_w > this.field_175193_B + this.field_175192_A) {
                float f3 = (float)(this.field_175199_z + this.field_175192_A + this.field_175193_B) - age;
                opacity = (int)(f3 * 255.0f / (float)this.field_175199_z);
            }
            if (this.field_175195_w <= this.field_175193_B) {
                opacity = (int)(age * 255.0f / (float)this.field_175193_B);
            }
            if ((opacity = MathHelper.func_76125_a((int)opacity, (int)0, (int)255)) > 8) {
                GlStateManager.func_179094_E();
                GlStateManager.func_179109_b((float)(width / 2), (float)(height / 2), (float)0.0f);
                GlStateManager.func_179147_l();
                GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
                GlStateManager.func_179094_E();
                GlStateManager.func_179152_a((float)4.0f, (float)4.0f, (float)4.0f);
                int l = opacity << 24 & 0xFF000000;
                this.func_175179_f().func_175065_a(this.field_175201_x, (float)(-this.func_175179_f().func_78256_a(this.field_175201_x) / 2), -10.0f, 0xFFFFFF | l, true);
                GlStateManager.func_179121_F();
                GlStateManager.func_179094_E();
                GlStateManager.func_179152_a((float)2.0f, (float)2.0f, (float)2.0f);
                this.func_175179_f().func_175065_a(this.field_175200_y, (float)(-this.func_175179_f().func_78256_a(this.field_175200_y) / 2), 5.0f, 0xFFFFFF | l, true);
                GlStateManager.func_179121_F();
                GlStateManager.func_179084_k();
                GlStateManager.func_179121_F();
            }
            this.field_73839_d.field_71424_I.func_76319_b();
        }
    }

    private void renderPlayerList(int width) {
        ScoreObjective scoreobjective = this.field_73839_d.field_71441_e.func_96441_U().func_96539_a(0);
        NetHandlerPlayClient handler = this.field_73839_d.field_71439_g.field_71174_a;
        if (this.field_73839_d.field_71474_y.field_74321_H.func_151470_d() && (!this.field_73839_d.func_71387_A() || handler.func_175106_d().size() > 1 || scoreobjective != null)) {
            this.field_175196_v.func_175246_a(true);
            if (this.pre(RenderGameOverlayEvent.ElementType.PLAYER_LIST)) {
                return;
            }
            this.field_175196_v.func_175249_a(width, this.field_73839_d.field_71441_e.func_96441_U(), scoreobjective);
            this.post(RenderGameOverlayEvent.ElementType.PLAYER_LIST);
        } else {
            this.field_175196_v.func_175246_a(false);
        }
    }

    private boolean pre(RenderGameOverlayEvent.ElementType type) {
        return MinecraftForge.EVENT_BUS.post((Event)new RenderGameOverlayEvent.Pre(this.eventParent, type));
    }

    private void post(RenderGameOverlayEvent.ElementType type) {
        MinecraftForge.EVENT_BUS.post((Event)new RenderGameOverlayEvent.Post(this.eventParent, type));
    }

    public void bind(ResourceLocation res) {
        this.field_73839_d.func_110434_K().func_110577_a(res);
    }

    public int func_73834_c() {
        return this.field_73837_f;
    }

    public int getOverlayMessageTime() {
        return this.field_73845_h;
    }

    public boolean getAnimateOverlayMessageColor() {
        return this.field_73844_j;
    }

    public String getOverlayMessage() {
        return this.field_73838_g;
    }

    public GuiNewChat func_146158_b() {
        if (!this.forceRenderTypeVanilla(HudElementType.CHAT)) {
            return this.chat;
        }
        return this.field_73840_e;
    }

    public GuiChatRPGHud getChat() {
        return this.chat;
    }

    private void drawElement(HudElementType type, float partialTicks) {
        if (this.rpgHud.getActiveHud().checkElementConditions(type)) {
            RenderGameOverlayEvent.ElementType alias = GuiIngameRPGHud.getEventAlias(type);
            if (this.forceRenderType(type)) {
                if (this.forceRenderTypeVanilla(type)) {
                    if (!this.preventElementRenderType(type)) {
                        this.bind(Gui.field_110324_m);
                        GlStateManager.func_179147_l();
                        this.rpgHud.getVanillaHud().drawElement(type, (Gui)this, partialTicks, partialTicks);
                        GlStateManager.func_179084_k();
                    }
                    if (alias != null && !this.preventEventType(type)) {
                        if (this.pre(alias)) {
                            return;
                        }
                        this.post(alias);
                    }
                } else {
                    if (!this.preventElementRenderType(type)) {
                        this.bind(Gui.field_110324_m);
                        GlStateManager.func_179147_l();
                        this.rpgHud.getActiveHud().drawElement(type, (Gui)this, partialTicks, partialTicks);
                        GlStateManager.func_179084_k();
                    }
                    if (alias != null && !this.preventEventType(type)) {
                        if (this.pre(alias)) {
                            return;
                        }
                        this.post(alias);
                    }
                }
            } else if (this.forceRenderTypeVanilla(type)) {
                if (alias != null && !this.preventEventType(type) && this.pre(alias)) {
                    return;
                }
                if (!this.preventElementRenderType(type)) {
                    this.bind(Gui.field_110324_m);
                    GlStateManager.func_179147_l();
                    this.rpgHud.getVanillaHud().drawElement(type, (Gui)this, partialTicks, partialTicks);
                    GlStateManager.func_179084_k();
                }
                if (alias != null && !this.preventEventType(type)) {
                    this.post(alias);
                }
            } else {
                if (alias != null && !this.preventEventType(type) && this.pre(alias)) {
                    return;
                }
                if (!this.preventElementRenderType(type)) {
                    this.bind(Gui.field_110324_m);
                    GlStateManager.func_179147_l();
                    this.rpgHud.getActiveHud().drawElement(type, (Gui)this, partialTicks, partialTicks);
                    GlStateManager.func_179084_k();
                }
                if (alias != null && !this.preventEventType(type)) {
                    this.post(alias);
                }
            }
        }
    }

    private void drawElementChat(float partialTicks) {
        if (this.rpgHud.getActiveHud().checkElementConditions(HudElementType.CHAT)) {
            RenderGameOverlayEvent.Chat event = new RenderGameOverlayEvent.Chat(this.eventParent, 0, this.res.func_78328_b() - 48);
            this.chat.setXOffset(event.getPosX());
            this.chat.setYOffset(event.getPosY());
            if (this.forceRenderType(HudElementType.CHAT)) {
                if (this.forceRenderTypeVanilla(HudElementType.CHAT)) {
                    if (!this.preventElementRenderType(HudElementType.CHAT)) {
                        this.bind(Gui.field_110324_m);
                        GlStateManager.func_179147_l();
                        GlStateManager.func_179094_E();
                        GlStateManager.func_179109_b((float)event.getPosX(), (float)event.getPosY(), (float)0.0f);
                        this.field_73840_e.func_146230_a(this.field_73837_f);
                        GlStateManager.func_179121_F();
                        GlStateManager.func_179084_k();
                    }
                    if (!this.preventEventType(HudElementType.CHAT)) {
                        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
                            return;
                        }
                        this.post(RenderGameOverlayEvent.ElementType.CHAT);
                    }
                } else {
                    if (!this.preventElementRenderType(HudElementType.CHAT)) {
                        this.bind(Gui.field_110324_m);
                        GlStateManager.func_179147_l();
                        this.rpgHud.getActiveHud().drawElement(HudElementType.CHAT, (Gui)this, this.field_73735_i, partialTicks);
                        GlStateManager.func_179084_k();
                    }
                    if (!this.preventEventType(HudElementType.CHAT)) {
                        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
                            return;
                        }
                        this.post(RenderGameOverlayEvent.ElementType.CHAT);
                    }
                }
            } else if (this.forceRenderTypeVanilla(HudElementType.CHAT)) {
                if (!this.preventEventType(HudElementType.CHAT) && MinecraftForge.EVENT_BUS.post((Event)event)) {
                    return;
                }
                if (!this.preventElementRenderType(HudElementType.CHAT)) {
                    this.bind(Gui.field_110324_m);
                    GlStateManager.func_179147_l();
                    GlStateManager.func_179094_E();
                    GlStateManager.func_179109_b((float)event.getPosX(), (float)event.getPosY(), (float)0.0f);
                    this.field_73840_e.func_146230_a(this.field_73837_f);
                    GlStateManager.func_179121_F();
                    GlStateManager.func_179084_k();
                }
                if (!this.preventEventType(HudElementType.CHAT)) {
                    this.post(RenderGameOverlayEvent.ElementType.CHAT);
                }
            } else {
                if (!this.preventEventType(HudElementType.CHAT) && MinecraftForge.EVENT_BUS.post((Event)event)) {
                    return;
                }
                if (!this.preventElementRenderType(HudElementType.CHAT)) {
                    this.bind(Gui.field_110324_m);
                    GlStateManager.func_179147_l();
                    this.rpgHud.getActiveHud().drawElement(HudElementType.CHAT, (Gui)this, this.field_73735_i, partialTicks);
                    GlStateManager.func_179084_k();
                }
                if (!this.preventEventType(HudElementType.CHAT)) {
                    this.post(RenderGameOverlayEvent.ElementType.CHAT);
                }
            }
        }
    }

    private boolean forceRenderType(HudElementType type) {
        String id = "force_render_" + type.name().toLowerCase();
        if (this.rpgHud.settings.doesSettingExist(id)) {
            return this.rpgHud.settings.getBoolValue(id);
        }
        return false;
    }

    private boolean preventElementRenderType(HudElementType type) {
        String id = "prevent_element_render_" + type.name().toLowerCase();
        if (this.rpgHud.settings.doesSettingExist(id)) {
            return this.rpgHud.settings.getBoolValue(id);
        }
        return false;
    }

    private boolean forceRenderTypeVanilla(HudElementType type) {
        String id = "force_render_" + type.name().toLowerCase();
        if (this.rpgHud.settings.doesSettingExist(id)) {
            return this.rpgHud.settings.getBoolValue(id);
        }
        return false;
    }

    private boolean preventEventType(HudElementType type) {
        String id = "prevent_event_" + type.name().toLowerCase();
        if (this.rpgHud.settings.doesSettingExist(id)) {
            return this.rpgHud.settings.getBoolValue(id);
        }
        return false;
    }

    private static RenderGameOverlayEvent.ElementType getEventAlias(HudElementType type) {
        switch (type) {
            case HOTBAR: {
                return RenderGameOverlayEvent.ElementType.HOTBAR;
            }
            case CROSSHAIR: {
                return RenderGameOverlayEvent.ElementType.CROSSHAIRS;
            }
            case HEALTH: {
                return RenderGameOverlayEvent.ElementType.HEALTH;
            }
            case ARMOR: {
                return RenderGameOverlayEvent.ElementType.ARMOR;
            }
            case FOOD: {
                return RenderGameOverlayEvent.ElementType.FOOD;
            }
            case HEALTH_MOUNT: {
                return RenderGameOverlayEvent.ElementType.HEALTHMOUNT;
            }
            case AIR: {
                return RenderGameOverlayEvent.ElementType.AIR;
            }
            case JUMP_BAR: {
                return RenderGameOverlayEvent.ElementType.JUMPBAR;
            }
            case EXPERIENCE: {
                return RenderGameOverlayEvent.ElementType.EXPERIENCE;
            }
        }
        return null;
    }

    public void addChatYOffset(int offset) {
        this.chat.setYOffset(this.chat.yOffset + offset);
    }

    private class GuiOverlayDebugForge
    extends GuiOverlayDebug {
        private Minecraft mc;

        GuiOverlayDebugForge(Minecraft mc) {
            super(mc);
            this.mc = mc;
        }

        protected void func_180798_a() {
        }

        protected void func_175239_b(ScaledResolution res) {
        }

        List<String> getLeft() {
            List ret = this.call();
            ret.add("");
            ret.add("Debug: Pie [shift]: " + (this.mc.field_71474_y.field_74329_Q ? "visible" : "hidden") + " FPS [alt]: " + (this.mc.field_71474_y.field_181657_aC ? "visible" : "hidden"));
            ret.add("For help: press F3 + Q");
            return ret;
        }

        List<String> getRight() {
            return this.func_175238_c();
        }
    }
}

