/*
 * Decompiled with CFR 0.152.
 */
package net.spellcraftgaming.rpghud.settings;

import net.spellcraftgaming.lib.GameData;
import net.spellcraftgaming.rpghud.gui.hud.element.HudElementType;
import net.spellcraftgaming.rpghud.settings.Setting;

public class SettingFloat
extends Setting {
    public final float defaultValue;
    public float value;
    public final float minValue;
    public final float maxValue;
    public final float step;

    public SettingFloat(String ID, float defaultValue, float minValue, float maxValue, float step) {
        super(ID);
        this.defaultValue = defaultValue;
        this.value = defaultValue;
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.step = step;
    }

    public SettingFloat(String ID, HudElementType type, float defaultValue, float minValue, float maxValue, float step) {
        super(ID, type);
        this.defaultValue = defaultValue;
        this.value = defaultValue;
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.step = step;
    }

    @Override
    public void increment() {
        this.value = this.value < this.maxValue ? (this.value += this.step) : this.minValue;
    }

    @Override
    public Object getValue() {
        return Float.valueOf(this.value);
    }

    @Override
    public void resetValue() {
        this.value = this.defaultValue;
    }

    @Override
    public void setValue(Object o) {
        if (o instanceof Float) {
            this.value = ((Float)o).floatValue();
        }
    }

    @Override
    public Object getDefaultValue() {
        return Float.valueOf(this.defaultValue);
    }

    public static float normalizeValue(SettingFloat setting, float value) {
        return GameData.clamp((SettingFloat.snapToStepClamp(setting, value) - setting.minValue) / (setting.maxValue - setting.minValue), 0.0f, 1.0f);
    }

    public static float denormalizeValue(SettingFloat setting, float value) {
        return SettingFloat.snapToStepClamp(setting, setting.minValue + (setting.maxValue - setting.minValue) * GameData.clamp(value, 0.0f, 1.0f));
    }

    public static float snapToStepClamp(SettingFloat setting, float value) {
        value = SettingFloat.snapToStep(setting, value);
        return GameData.clamp(value, setting.minValue, setting.maxValue);
    }

    public static float snapToStep(SettingFloat setting, float value) {
        if (setting.step > 0.0f) {
            value = setting.step * (float)Math.round(value / setting.step);
        }
        return value;
    }
}

