/*
 * Decompiled with CFR 0.152.
 */
package net.spellcraftgaming.rpghud.settings;

import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraftforge.common.config.Configuration;
import net.spellcraftgaming.lib.GameData;
import net.spellcraftgaming.rpghud.gui.hud.element.HudElementType;
import net.spellcraftgaming.rpghud.main.ModRPGHud;
import net.spellcraftgaming.rpghud.settings.Setting;
import net.spellcraftgaming.rpghud.settings.SettingBoolean;
import net.spellcraftgaming.rpghud.settings.SettingColor;
import net.spellcraftgaming.rpghud.settings.SettingFloat;
import net.spellcraftgaming.rpghud.settings.SettingHudType;
import net.spellcraftgaming.rpghud.settings.SettingInteger;
import net.spellcraftgaming.rpghud.settings.SettingPosition;
import net.spellcraftgaming.rpghud.settings.SettingString;

public class Settings {
    private Map<String, Setting> settings = new LinkedHashMap<String, Setting>();
    private Configuration config = new Configuration(new File(this.rpgHudDir(), "settings.cfg"));
    private Configuration[] hudConfig;
    public static final String hud_type = "hud_type";
    public static final String enable_button_tooltip = "enable_button_tooltip";
    public static final String show_update_notification = "show_update_notification";
    public static final String show_convert_notification = "show_convert_notification";
    public static final String hotbar_position = "hotbar_position";
    public static final String widget_position = "widget_position";
    public static final String chat_position = "chat_position";
    public static final String armor_position = "armor_position";
    public static final String reduce_size = "reduce_size";
    public static final String show_armor = "show_armor";
    public static final String show_arrow_count = "show_arrow_count";
    public static final String show_item_durability = "show_item_durability";
    public static final String show_block_count = "show_block_count";
    public static final String show_durability_bar = "show_durability_bar";
    public static final String armor_det_position = "armor_det_position";
    public static final String arrow_det_position = "arrow_det_position";
    public static final String item_det_position = "item_det_position";
    public static final String show_numbers_health = "show_numbers_health";
    public static final String color_health = "color_health";
    public static final String color_absorption = "color_absorption";
    public static final String color_poison = "color_poison";
    public static final String color_wither = "color_wither";
    public static final String health_position = "health_position";
    public static final String mount_health_position = "mount_health_position";
    public static final String show_numbers_food = "show_numbers_food";
    public static final String show_hunger_preview = "show_hunger_preview";
    public static final String color_food = "color_food";
    public static final String color_hunger = "color_hunger";
    public static final String hunger_position = "hunger_position";
    public static final String show_numbers_experience = "show_numbers_experience";
    public static final String color_experience = "color_experience";
    public static final String experience_position = "experience_position";
    public static final String level_position = "level_position";
    public static final String enable_clock = "enable_clock";
    public static final String enable_clock_color = "enable_clock_color";
    public static final String enable_immersive_clock = "enable_immersive_clock";
    public static final String clock_time_format = "clock_time_format";
    public static final String clock_position = "clock_position";
    public static final String enable_compass = "enable_compass";
    public static final String enable_compass_color = "enable_compass_color";
    public static final String enable_immersive_compass = "enable_immersive_compass";
    public static final String enable_compass_coordinates = "enable_compass_coordinates";
    public static final String invert_compass = "invert_compass";
    public static final String compass_position = "compass_position";
    public static final String enable_pickup = "enable_pickup";
    public static final String pickup_duration = "pickup_duration";
    public static final String pickup_position = "pickup_position";
    public static final String render_player_face = "render_player_face";
    public static final String face_position = "face_position";
    public static final String limit_jump_bar = "limit_jump_bar";
    public static final String color_jump_bar = "color_jump_bar";
    public static final String jump_bar_position = "jump_bar_position";
    public static final String enable_entity_inspect = "enable_entity_inspect";
    public static final String inspector_position = "inspector_position";
    public static final String color_air = "color_air";
    public static final String air_position = "air_position";
    public static final String force_render = "force_render";
    public static final String render_vanilla = "render_vanilla";
    public static final String prevent_event = "prevent_event";
    public static final String prevent_element_render = "prevent_element_render";

    private File rpgHudDir() {
        return new File(Minecraft.func_71410_x().field_71412_D.getPath(), "config" + File.separator + "RPG-HUD");
    }

    public Settings() {
        this.config.load();
        this.init();
        this.config.save();
    }

    public void initHudConfig() {
        this.hudConfig = new Configuration[ModRPGHud.instance.huds.size()];
        Set<String> huds = ModRPGHud.instance.huds.keySet();
        String[] keys = huds.toArray(new String[huds.size()]);
        int size = keys.length;
        for (int n = 0; n < size; ++n) {
            this.hudConfig[n] = new Configuration(new File(this.rpgHudDir() + File.separator + "hud", keys[n] + ".cfg"));
            SettingBoolean setting = new SettingBoolean("test", true);
            this.hudConfig[n].get("test", "test", ((Boolean)((Setting)setting).getDefaultValue()).booleanValue(), setting.getFormatedTooltip()).set(((Boolean)((Setting)setting).getValue()).booleanValue());
            this.hudConfig[n].save();
        }
    }

    public void init() {
        this.addSetting(hud_type, new SettingHudType(hud_type, "vanilla"));
        this.addSetting(enable_button_tooltip, new SettingBoolean(enable_button_tooltip, true));
        this.addSetting(show_update_notification, new SettingBoolean(show_update_notification, true));
        this.addSetting(show_convert_notification, new SettingBoolean(show_convert_notification, true));
        this.addSetting(reduce_size, new SettingBoolean(reduce_size, HudElementType.DETAILS, false));
        this.addSetting(show_armor, new SettingBoolean(show_armor, HudElementType.DETAILS, true));
        this.addSetting(show_arrow_count, new SettingBoolean(show_arrow_count, HudElementType.DETAILS, true));
        this.addSetting(show_item_durability, new SettingBoolean(show_item_durability, HudElementType.DETAILS, true));
        this.addSetting(show_block_count, new SettingBoolean(show_block_count, HudElementType.DETAILS, true));
        this.addSetting(show_durability_bar, new SettingBoolean(show_durability_bar, HudElementType.DETAILS, true));
        this.addSetting(armor_det_position, new SettingPosition(armor_det_position, HudElementType.DETAILS, 0, 0));
        this.addSetting(arrow_det_position, new SettingPosition(arrow_det_position, HudElementType.DETAILS, 0, 0));
        this.addSetting(item_det_position, new SettingPosition(item_det_position, HudElementType.DETAILS, 0, 0));
        this.addSetting(show_numbers_health, new SettingBoolean(show_numbers_health, HudElementType.HEALTH, true));
        this.addSetting(color_health, new SettingColor(color_health, HudElementType.HEALTH, 0xC10000));
        this.addSetting(color_absorption, new SettingColor(color_absorption, HudElementType.HEALTH, 16745472));
        this.addSetting(color_poison, new SettingColor(color_poison, HudElementType.HEALTH, 10748144));
        this.addSetting(color_wither, new SettingColor(color_wither, HudElementType.HEALTH, 0x292929));
        this.addSetting(health_position, new SettingPosition(health_position, HudElementType.HEALTH, 0, 0));
        this.addSetting(show_numbers_food, new SettingBoolean(show_numbers_food, HudElementType.FOOD, true));
        this.addSetting(show_hunger_preview, new SettingBoolean(show_hunger_preview, HudElementType.FOOD, true));
        this.addSetting(color_food, new SettingColor(color_food, HudElementType.FOOD, 3916288));
        this.addSetting(color_hunger, new SettingColor(color_hunger, HudElementType.FOOD, 10199143));
        this.addSetting(hunger_position, new SettingPosition(hunger_position, HudElementType.FOOD, 0, 0));
        this.addSetting(show_numbers_experience, new SettingBoolean(show_numbers_experience, HudElementType.EXPERIENCE, true));
        this.addSetting(color_experience, new SettingColor(color_experience, HudElementType.EXPERIENCE, 0xEEEE00));
        this.addSetting(experience_position, new SettingPosition(experience_position, HudElementType.EXPERIENCE, 0, 0));
        this.addSetting(enable_clock, new SettingBoolean(enable_clock, HudElementType.CLOCK, true));
        this.addSetting(enable_clock_color, new SettingBoolean(enable_clock_color, HudElementType.CLOCK, true));
        this.addSetting(enable_immersive_clock, new SettingBoolean(enable_immersive_clock, HudElementType.CLOCK, false));
        this.addSetting(clock_time_format, new SettingString(clock_time_format, HudElementType.CLOCK, 0, new String[]{"time.24", "time.12"}));
        this.addSetting(clock_position, new SettingPosition(clock_position, HudElementType.CLOCK, 0, 0));
        this.addSetting(enable_compass, new SettingBoolean(enable_compass, HudElementType.COMPASS, true));
        this.addSetting(enable_compass_color, new SettingBoolean(enable_compass_color, HudElementType.COMPASS, true));
        this.addSetting(enable_immersive_compass, new SettingBoolean(enable_immersive_compass, HudElementType.COMPASS, false));
        this.addSetting(enable_compass_coordinates, new SettingBoolean(enable_compass_coordinates, HudElementType.COMPASS, true));
        this.addSetting(invert_compass, new SettingBoolean(invert_compass, HudElementType.COMPASS, false));
        this.addSetting(compass_position, new SettingPosition(compass_position, HudElementType.COMPASS, 0, 0));
        this.addSetting(enable_pickup, new SettingBoolean(enable_pickup, HudElementType.PICKUP, true));
        this.addSetting(pickup_duration, new SettingFloat(pickup_duration, HudElementType.PICKUP, 5.0f, 1.0f, 10.0f, 1.0f));
        this.addSetting(pickup_position, new SettingPosition(pickup_position, HudElementType.PICKUP, 0, 0));
        this.addSetting(render_player_face, new SettingBoolean(render_player_face, HudElementType.WIDGET, true));
        this.addSetting(widget_position, new SettingPosition(widget_position, HudElementType.WIDGET, 0, 0));
        this.addSetting(face_position, new SettingPosition(face_position, HudElementType.WIDGET, 0, 0));
        this.addSetting(limit_jump_bar, new SettingBoolean(limit_jump_bar, HudElementType.JUMP_BAR, true));
        this.addSetting(color_jump_bar, new SettingColor(color_jump_bar, HudElementType.JUMP_BAR, 0x8A8A8A));
        this.addSetting(jump_bar_position, new SettingPosition(jump_bar_position, HudElementType.JUMP_BAR, 0, 0));
        this.addSetting(enable_entity_inspect, new SettingBoolean(enable_entity_inspect, HudElementType.ENTITY_INSPECT, true));
        this.addSetting(inspector_position, new SettingPosition(inspector_position, HudElementType.ENTITY_INSPECT, 0, 0));
        this.addSetting(color_air, new SettingColor(color_air, HudElementType.AIR, 23490));
        this.addSetting(air_position, new SettingPosition(air_position, HudElementType.AIR, 0, 0));
        this.addSetting(mount_health_position, new SettingPosition(mount_health_position, HudElementType.HEALTH_MOUNT, 0, 0));
        this.addSetting(hotbar_position, new SettingPosition(hotbar_position, HudElementType.HOTBAR, 0, 0));
        this.addSetting(level_position, new SettingPosition(level_position, HudElementType.LEVEL, 0, 0));
        this.addSetting(chat_position, new SettingPosition(chat_position, HudElementType.CHAT, 0, 0));
        this.addSetting(armor_position, new SettingPosition(armor_position, HudElementType.ARMOR, 0, 0));
        this.addDebugSettings(HudElementType.CROSSHAIR);
        this.addDebugSettings(HudElementType.ARMOR);
        this.addDebugSettings(HudElementType.HOTBAR);
        this.addDebugSettings(HudElementType.AIR);
        this.addDebugSettings(HudElementType.HEALTH);
        this.addDebugSettings(HudElementType.FOOD);
        this.addDebugSettings(HudElementType.EXPERIENCE);
        this.addDebugSettings(HudElementType.LEVEL);
        this.addDebugSettings(HudElementType.HEALTH_MOUNT);
        this.addDebugSettings(HudElementType.JUMP_BAR);
        this.addDebugSettings(HudElementType.CHAT);
    }

    public void addDebugSettings(HudElementType type) {
        this.addSetting("force_render_" + type.name().toLowerCase(), new SettingBoolean(force_render, type, false));
        this.addSetting("render_vanilla_" + type.name().toLowerCase(), new SettingBoolean(render_vanilla, type, false));
        this.addSetting("prevent_event_" + type.name().toLowerCase(), new SettingBoolean(prevent_event, type, false));
        this.addSetting("prevent_element_render_" + type.name().toLowerCase(), new SettingBoolean(prevent_element_render, type, false));
    }

    public Setting getSetting(String id) {
        return this.settings.get(id);
    }

    public int[] getPositionValue(String i) {
        String[] postions = this.settings.get(i).getValue().toString().split("_");
        int[] values = new int[]{Integer.valueOf(postions[0]), Integer.valueOf(postions[1])};
        return values;
    }

    public Object getValue(String i) {
        return this.settings.get(i).getValue();
    }

    public double getDoubleValue(String i) {
        return this.settings.get(i).getDoubleValue();
    }

    public Integer getIntValue(String i) {
        return this.settings.get(i).getIntValue();
    }

    public Boolean getBoolValue(String i) {
        return this.settings.get(i).getBoolValue();
    }

    public Float getFloatValue(String i) {
        return this.settings.get(i).getFloatValue();
    }

    public String getStringValue(String i) {
        return this.settings.get(i).getStringValue();
    }

    public void resetSetting(String i) {
        Setting setting = this.settings.get(i);
        setting.resetValue();
        this.settings.put(i, setting);
        this.saveSetting(i);
    }

    public void increment(String i) {
        Setting setting = this.settings.get(i);
        setting.increment();
        this.settings.put(i, setting);
        this.saveSetting(i);
    }

    public void setSetting(String i, Object o) {
        Setting setting = this.settings.get(i);
        setting.setValue(o);
        this.settings.put(i, setting);
        this.saveSetting(i);
    }

    public void saveSetting(String id) {
        Setting setting = this.settings.get(id);
        String category = "0:general";
        if (setting.associatedType != null) {
            category = "1:" + setting.associatedType.name().toLowerCase();
        }
        if (setting instanceof SettingInteger) {
            this.config.get(category, id, ((Integer)setting.getDefaultValue()).intValue(), setting.getFormatedTooltip()).set(((Integer)setting.getValue()).intValue());
        } else if (setting instanceof SettingColor) {
            this.config.get(category, id, Integer.toHexString((Integer)setting.getDefaultValue()), setting.getFormatedTooltip()).set(Integer.toHexString((Integer)setting.getValue()));
        } else if (setting instanceof SettingBoolean) {
            this.config.get(category, id, ((Boolean)setting.getDefaultValue()).booleanValue(), setting.getFormatedTooltip()).set(((Boolean)setting.getValue()).booleanValue());
        } else if (setting instanceof SettingFloat) {
            this.config.get(category, id, (double)((Float)setting.getDefaultValue()).floatValue(), setting.getFormatedTooltip()).set((double)((Float)setting.getValue()).floatValue());
        } else if (setting instanceof SettingString || setting instanceof SettingHudType || setting instanceof SettingPosition) {
            this.config.get(category, id, (String)setting.getDefaultValue(), setting.getFormatedTooltip()).set((String)setting.getValue());
        }
        this.config.save();
    }

    public void addSetting(String id, Setting setting) {
        String category = "0:general";
        if (setting.associatedType != null) {
            category = "1:" + setting.associatedType.name().toLowerCase();
        }
        if (setting instanceof SettingInteger) {
            setting.setValue(this.config.get(category, id, ((Integer)setting.getDefaultValue()).intValue(), setting.getFormatedTooltip()).getInt());
        } else if (setting instanceof SettingColor) {
            setting.setValue(this.config.get(category, id, Integer.toHexString((Integer)setting.getDefaultValue()), setting.getFormatedTooltip()).getString());
        } else if (setting instanceof SettingBoolean) {
            setting.setValue(this.config.get(category, id, ((Boolean)setting.getDefaultValue()).booleanValue(), setting.getFormatedTooltip()).getBoolean());
        } else if (setting instanceof SettingFloat) {
            setting.setValue(this.config.get(category, id, (double)((Float)setting.getDefaultValue()).floatValue(), setting.getFormatedTooltip()).getDouble());
        } else if (setting instanceof SettingString || setting instanceof SettingHudType || setting instanceof SettingPosition) {
            setting.setValue(this.config.get(category, id, (String)setting.getDefaultValue(), setting.getFormatedTooltip()).getString());
        }
        this.settings.put(id, setting);
    }

    public boolean doesSettingExist(String i) {
        return this.settings.containsKey(i);
    }

    public String getButtonString(String id) {
        Setting setting = this.settings.get(id);
        String s = I18n.func_135052_a((String)setting.getName(), (Object[])new Object[0]) + ": ";
        if (setting instanceof SettingBoolean) {
            return s + (setting.getBoolValue() != false ? I18n.func_135052_a((String)"options.on", (Object[])new Object[0]) : I18n.func_135052_a((String)"options.off", (Object[])new Object[0]));
        }
        if (setting instanceof SettingString || setting instanceof SettingHudType) {
            return s + I18n.func_135052_a((String)setting.getStringValue(), (Object[])new Object[0]);
        }
        if (setting instanceof SettingColor) {
            return s + Settings.intToHexString(setting.getIntValue());
        }
        if (setting instanceof SettingInteger) {
            return s + setting.getIntValue();
        }
        if (setting instanceof SettingFloat) {
            SettingFloat sf = (SettingFloat)setting;
            return s + (id == pickup_duration ? GameData.ceil(SettingFloat.snapToStepClamp(sf, sf.getFloatValue().floatValue())) + " " + I18n.func_135052_a((String)"gui.rpg.sec", (Object[])new Object[0]) : String.valueOf(SettingFloat.snapToStepClamp(sf, sf.getFloatValue().floatValue())));
        }
        if (setting instanceof SettingPosition) {
            return s;
        }
        return s + "error";
    }

    public static String intToHexString(int hex) {
        String s = Integer.toHexString(hex).toUpperCase();
        if (hex <= 1048575) {
            s = "0" + s;
            if (hex <= 65535) {
                s = "0" + s;
                if (hex <= 4095) {
                    s = "0" + s;
                    if (hex <= 255) {
                        s = "0" + s;
                        if (hex <= 15) {
                            s = "0" + s;
                        }
                    }
                }
            }
        }
        return "#" + s;
    }

    public void saveSettings() {
        this.config.save();
    }

    public List<String> getSettingsOf(HudElementType type) {
        ArrayList<String> settings = new ArrayList<String>();
        for (String key : this.settings.keySet()) {
            if (this.settings.get((Object)key).associatedType != type) continue;
            settings.add(key);
        }
        return settings;
    }

    public List<String> getSettingsOf(String type) {
        ArrayList<String> settings = new ArrayList<String>();
        for (String key : this.settings.keySet()) {
            if (this.settings.get((Object)key).associatedType != null && this.settings.get((Object)key).associatedType.name() == type) {
                settings.add(key);
                continue;
            }
            if (type != "general" || this.settings.get((Object)key).associatedType != null) continue;
            settings.add(key);
        }
        return settings;
    }
}

