/*
 * Decompiled with CFR 0.152.
 */
package com.github.ipixeli.gender;

import com.github.ipixeli.gender.core.Gender;
import com.github.ipixeli.gender.core.profiles.EnumAge;
import com.github.ipixeli.gender.core.profiles.EnumGender;
import com.github.ipixeli.gender.core.profiles.EnumModel;
import com.github.ipixeli.gender.core.profiles.PlayerProfile;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.nio.charset.Charset;
import java.util.List;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.FMLEventChannel;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import net.minecraftforge.fml.common.network.internal.FMLProxyPacket;

public class PacketHandler {
    private static FMLEventChannel channel;

    public PacketHandler(FMLEventChannel c) {
        channel = c;
    }

    @SubscribeEvent
    public void onClientPacket(FMLNetworkEvent.ClientCustomPacketEvent e) {
        try {
            ByteBuf buf = e.getPacket().payload();
            PlayerProfile p = PacketHandler.readBytes(Side.CLIENT, buf);
            Gender.client().tempMgr.getOrCreate(p, true);
            if (p != null) {
                Gender.log().logInfo("[CLIENT] Recieved packet from server: username: " + p.name() + ", gender: " + p.getGender().name() + ", age: " + p.getAge().name() + ", model: " + p.getModel().name());
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void sendProfileFromClientToServer(PlayerProfile p) {
        PacketBuffer buf = PacketHandler.writeBytes(Side.CLIENT, new PacketBuffer(Unpooled.buffer()), p);
        if (buf != null) {
            channel.sendToServer(new FMLProxyPacket(buf, "gender"));
        }
    }

    @SubscribeEvent
    public void onServerPacket(FMLNetworkEvent.ServerCustomPacketEvent e) {
        try {
            ByteBuf buf = e.getPacket().payload();
            PlayerProfile r = PacketHandler.readBytes(Side.SERVER, buf);
            if (r != null) {
                PlayerProfile p = Gender.server().getListManager().getOrCreate(r, true);
                Gender.log().logInfo("[CLIENT] Recieved packet from server: username: " + p.name() + ", gender: " + p.getGender().name() + ", age: " + p.getAge().name() + ", model: " + p.getModel().name());
                PacketHandler.sendOneFromServerToAllClients(p);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private static PlayerProfile readBytes(Side side, ByteBuf buf) {
        try {
            byte bage = buf.readByte();
            byte bgender = buf.readByte();
            byte bmodel = buf.readByte();
            String u = buf.readCharSequence(buf.capacity() - buf.readerIndex(), Charset.forName("utf-8")).toString().trim();
            String[] s = u.split("@");
            String name = s[0];
            String uuid = s[1];
            EnumAge age = EnumAge.UNSET.getFromValue(bage);
            EnumGender gender = EnumGender.UNSET.getFromValue(bgender);
            EnumModel model = EnumModel.UNSET.getFromValue(bmodel);
            if (PacketHandler.notEmpty(name) || PacketHandler.notEmpty(uuid)) {
                PlayerProfile data = new PlayerProfile("" + name, "" + uuid);
                data.setAge(age);
                data.setGender(gender);
                data.setModel(model);
                Gender.log().logDebug(side.name() + ": Successfully loaded profile from datagram: " + name + " (" + uuid + "): " + age.toString() + "; " + gender.toString() + "; " + model.toString());
                return data;
            }
            Gender.log().logWarn(side.name() + ": Invalid packet read.");
        }
        catch (Exception e) {
            Gender.log().logWarn(side.name() + ": Invalid packet read. Error: " + e.getMessage());
        }
        return null;
    }

    private static boolean notEmpty(String s) {
        return s != null && s.length() > 0;
    }

    public static void sendOneFromServerToAllClients(PlayerProfile p) {
        PacketBuffer buf = PacketHandler.writeBytes(Side.SERVER, new PacketBuffer(Unpooled.buffer()), p);
        if (buf != null) {
            channel.sendToAll(new FMLProxyPacket(buf, "gender"));
        }
    }

    public static void sendAllFromServerToOneClient(EntityPlayerMP player) {
        List<PlayerProfile> profiles = Gender.server().getListManager().getList();
        if (profiles == null) {
            return;
        }
        try {
            for (PlayerProfile p : profiles) {
                PacketBuffer buf = PacketHandler.writeBytes(Side.SERVER, new PacketBuffer(Unpooled.buffer()), p);
                if (buf == null) continue;
                channel.sendTo(new FMLProxyPacket(buf, "gender"), player);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static PacketBuffer writeBytes(Side side, PacketBuffer buf, PlayerProfile p) {
        try {
            String name = p.name();
            String uuid = p.uuid();
            EnumAge age = p.getAge();
            EnumGender gender = p.getGender();
            EnumModel model = p.getModel();
            buf.writeByte(age.ordinal());
            buf.writeByte(gender.ordinal());
            buf.writeByte(model.ordinal());
            buf.writeCharSequence((CharSequence)new StringBuffer(name + "@" + uuid), Charset.forName("utf-8"));
            Gender.log().logDebug(side.name() + ": Successfully converted profile to bytes: " + name + " (" + uuid + "): " + age.toString() + "; " + gender.toString() + "; " + model.toString());
        }
        catch (Exception e) {
            Gender.log().logWarn(side.name() + ": Failed to convert profile to bytes. Error: " + e.getMessage());
        }
        return buf;
    }

    private static enum Side {
        CLIENT,
        SERVER;

    }
}

