/*
 * Decompiled with CFR 0.152.
 */
package net.spellcraftgaming.rpghud.gui.hud.element.hotbar;

import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.spellcraftgaming.lib.GameData;
import net.spellcraftgaming.rpghud.gui.hud.element.HudElement;
import net.spellcraftgaming.rpghud.gui.hud.element.HudElementType;

public class HudElementHealthHotbar
extends HudElement {
    public HudElementHealthHotbar() {
        super(HudElementType.HEALTH, 0, 0, 0, 0, true);
        this.parent = HudElementType.WIDGET;
    }

    @Override
    public boolean checkConditions() {
        return GameData.shouldDrawHUD() && !GameData.isRidingLivingMount();
    }

    @Override
    public void drawElement(Gui gui, float zLevel, float partialTicks) {
        String stringHealth;
        ScaledResolution res = new ScaledResolution(this.mc);
        int height = res.func_78328_b() + this.settings.getPositionValue("health_position")[1];
        int health = GameData.getPlayerHealth();
        int posX = (this.settings.getBoolValue("render_player_face") != false ? 49 : 25) + this.settings.getPositionValue("health_position")[0];
        int healthMax = GameData.getPlayerMaxHealth();
        int absorption = GameData.getPlayerAbsorption();
        int offset = GameData.getHotbarWidgetWidthOffset();
        if (absorption > 1) {
            HudElementHealthHotbar.drawCustomBar(posX, height - 56, 200 + offset, 10, (double)(health + absorption) / (double)(healthMax + absorption) * 100.0, -1, -1, this.settings.getIntValue("color_absorption"), HudElementHealthHotbar.offsetColorPercent(this.settings.getIntValue("color_absorption"), 25));
        }
        if (GameData.isPlayerPoisoned()) {
            HudElementHealthHotbar.drawCustomBar(posX, height - 56, 200 + offset, 10, (double)health / (double)(healthMax + absorption) * 100.0, -1, -1, this.settings.getIntValue("color_poison"), HudElementHealthHotbar.offsetColorPercent(this.settings.getIntValue("color_poison"), 25));
        } else if (GameData.isPlayerWithering()) {
            HudElementHealthHotbar.drawCustomBar(posX, height - 56, 200 + offset, 10, (double)health / (double)(healthMax + absorption) * 100.0, -1, -1, this.settings.getIntValue("color_wither"), HudElementHealthHotbar.offsetColorPercent(this.settings.getIntValue("color_wither"), 25));
        } else {
            HudElementHealthHotbar.drawCustomBar(posX, height - 56, 200 + offset, 10, (double)health / (double)(healthMax + absorption) * 100.0, -1, -1, this.settings.getIntValue("color_health"), HudElementHealthHotbar.offsetColorPercent(this.settings.getIntValue("color_health"), 25));
        }
        String string = stringHealth = this.settings.getBoolValue("health_percentage") != false ? (int)Math.floor((double)health / (double)healthMax * 100.0) + "%" : health + absorption + "/" + healthMax;
        if (this.settings.getBoolValue("show_numbers_health").booleanValue()) {
            gui.func_73732_a(GameData.getFontRenderer(), stringHealth, posX + 100 + offset / 2, height - 55, -1);
        }
    }
}

