/*
 * Decompiled with CFR 0.152.
 */
package net.spellcraftgaming.rpghud.gui;

import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.ITextComponent;
import net.spellcraftgaming.rpghud.gui.GuiButtonTooltip;
import net.spellcraftgaming.rpghud.gui.GuiScreenTooltip;
import net.spellcraftgaming.rpghud.gui.GuiSliderMod;
import net.spellcraftgaming.rpghud.gui.hud.element.HudElement;
import net.spellcraftgaming.rpghud.main.ModRPGHud;
import net.spellcraftgaming.rpghud.settings.Settings;

public class GuiSettingsModColor
extends GuiScreenTooltip {
    private TextFieldWidget colorCodeField;
    private Screen parent;
    private String colorType;
    private int colorR;
    private int colorG;
    private int colorB;
    private int color;
    private String title = "";

    public GuiSettingsModColor(Screen parent, String color, ITextComponent titleIn) {
        super(titleIn);
        this.parent = parent;
        this.colorType = color;
        this.setColors();
        this.title = this.setTitle() + " " + I18n.func_135052_a((String)"gui.rpg.editor", (Object[])new Object[0]);
    }

    private String setTitle() {
        return I18n.func_135052_a((String)("name." + this.colorType), (Object[])new Object[0]);
    }

    private void setColors() {
        int color;
        this.color = color = ModRPGHud.instance.settings.getIntValue(this.colorType).intValue();
        this.colorR = color >> 16 & 0xFF;
        this.colorG = color >> 8 & 0xFF;
        this.colorB = color & 0xFF;
    }

    private void setSettingColor() {
        ModRPGHud.instance.settings.setSetting(this.colorType, this.color);
    }

    public void init() {
        int i;
        this.addButton((Widget)new GuiSliderMod(GuiSliderMod.EnumColor.RED, this.width / 2 - 75, 40, this.colorR, 0.0f, 255.0f, 1.0f, slider -> slider.onClick(0.0, 0.0)));
        this.addButton((Widget)new GuiSliderMod(GuiSliderMod.EnumColor.GREEN, this.width / 2 - 75, 65, this.colorG, 0.0f, 255.0f, 1.0f, slider -> slider.onClick(0.0, 0.0)));
        this.addButton((Widget)new GuiSliderMod(GuiSliderMod.EnumColor.BLUE, this.width / 2 - 75, 90, this.colorB, 0.0f, 255.0f, 1.0f, slider -> slider.onClick(0.0, 0.0)));
        this.colorCodeField = new TextFieldWidget(this.minecraft.field_71466_p, this.width / 2 - 74, 115, 147, 20, Settings.intToHexString(this.color));
        this.colorCodeField.func_146180_a(Settings.intToHexString(this.color));
        this.colorCodeField.func_146203_f(7);
        this.children.add(this.colorCodeField);
        String[] colorString = new String[]{"color.red", "color.pink", "color.brown", "color.white", "color.orange", "color.green", "color.purple", "color.blue", "color.aqua", "color.black", "color.grey", "color.yellow"};
        for (i = 0; i < 6; ++i) {
            this.addButton((Widget)new GuiButtonTooltip(10 + i, this.width / 4 * 3 - 20, 40 + i * 20, 60, 20, I18n.func_135052_a((String)colorString[i], (Object[])new Object[0]), button -> this.actionPerformed(button)));
        }
        for (i = 0; i < 6; ++i) {
            this.addButton((Widget)new GuiButtonTooltip(16 + i, this.width / 4 * 3 + 60 - 20, 40 + i * 20, 60, 20, I18n.func_135052_a((String)colorString[i + 6], (Object[])new Object[0]), button -> this.actionPerformed(button)));
        }
        this.addButton((Widget)new GuiButtonTooltip(this.width / 2 - 100, this.height / 6 + 168, 125, 20, I18n.func_135052_a((String)"gui.done", (Object[])new Object[0]), button -> {
            this.setSettingColor();
            this.minecraft.func_147108_a(this.parent);
        }).setTooltip(I18n.func_135052_a((String)"tooltip.done", (Object[])new Object[0])));
        this.addButton((Widget)new GuiButtonTooltip(this.width / 2 + 24, this.height / 6 + 168, 75, 20, I18n.func_135052_a((String)"gui.cancel", (Object[])new Object[0]), button -> this.minecraft.func_147108_a(this.parent)).setTooltip(I18n.func_135052_a((String)"tooltip.cancel", (Object[])new Object[0])));
    }

    protected void actionPerformed(Button b) {
        GuiButtonTooltip button = (GuiButtonTooltip)b;
        if (button.active) {
            if (button.id == 10) {
                this.setColorTo(0xC10000);
            } else if (button.id == 11) {
                this.setColorTo(16738740);
            } else if (button.id == 12) {
                this.setColorTo(9127187);
            } else if (button.id == 13) {
                this.setColorTo(0xF2F2F2);
            } else if (button.id == 14) {
                this.setColorTo(16745472);
            } else if (button.id == 15) {
                this.setColorTo(3916288);
            } else if (button.id == 16) {
                this.setColorTo(10748144);
            } else if (button.id == 17) {
                this.setColorTo(23490);
            } else if (button.id == 18) {
                this.setColorTo(65535);
            } else if (button.id == 19) {
                this.setColorTo(0x292929);
            } else if (button.id == 20) {
                this.setColorTo(0x8A8A8A);
            } else if (button.id == 21) {
                this.setColorTo(0xEEEE00);
            } else if (button.id == 250) {
                this.setSettingColor();
                this.minecraft.func_147108_a(this.parent);
            } else if (button.id == 251) {
                this.minecraft.func_147108_a(this.parent);
            }
        }
    }

    public void setColorTo(int color) {
        this.color = color;
        this.colorR = this.color >> 16 & 0xFF;
        ((GuiSliderMod)((Object)this.buttons.get((int)0))).sliderValue = (float)this.colorR / 255.0f;
        ((GuiSliderMod)((Object)this.buttons.get((int)0))).value = this.colorR;
        this.colorG = this.color >> 8 & 0xFF;
        ((GuiSliderMod)((Object)this.buttons.get((int)1))).sliderValue = (float)this.colorG / 255.0f;
        ((GuiSliderMod)((Object)this.buttons.get((int)1))).value = this.colorG;
        this.colorB = this.color & 0xFF;
        ((GuiSliderMod)((Object)this.buttons.get((int)2))).sliderValue = (float)this.colorB / 255.0f;
        ((GuiSliderMod)((Object)this.buttons.get((int)2))).value = this.colorB;
        this.colorCodeField.func_146180_a(Settings.intToHexString(this.color));
    }

    public void tick() {
        super.tick();
        if (this.colorCodeField.isFocused()) {
            if (!this.colorCodeField.func_146179_b().startsWith("#")) {
                String s = "#" + this.colorCodeField.func_146179_b();
                if (this.colorCodeField.func_146179_b().length() >= 7) {
                    s = "#";
                    for (int i = 0; i < 6; ++i) {
                        s = s + this.colorCodeField.func_146179_b().charAt(i);
                    }
                }
                this.colorCodeField.func_146180_a(s);
            }
            if (this.colorCodeField.func_146179_b().length() == 7 && this.colorCodeField.func_146179_b().startsWith("#") && this.colorCodeField.func_146179_b().replace("#", "").matches("[0-9A-Fa-f]+")) {
                this.color = Integer.valueOf(this.colorCodeField.func_146179_b().replace("#", ""), 16);
                this.colorR = this.color >> 16 & 0xFF;
                ((GuiSliderMod)((Object)this.buttons.get((int)0))).sliderValue = (float)this.colorR / 255.0f;
                ((GuiSliderMod)((Object)this.buttons.get((int)0))).value = this.colorR;
                this.colorG = this.color >> 8 & 0xFF;
                ((GuiSliderMod)((Object)this.buttons.get((int)1))).sliderValue = (float)this.colorG / 255.0f;
                ((GuiSliderMod)((Object)this.buttons.get((int)1))).value = this.colorG;
                this.colorB = this.color & 0xFF;
                ((GuiSliderMod)((Object)this.buttons.get((int)2))).sliderValue = (float)this.colorB / 255.0f;
                ((GuiSliderMod)((Object)this.buttons.get((int)2))).value = this.colorB;
            }
            this.colorCodeField.func_146180_a(this.colorCodeField.func_146179_b().toUpperCase());
        } else {
            this.colorCodeField.func_146180_a(Settings.intToHexString(this.color));
            this.colorR = ((GuiSliderMod)((Object)this.buttons.get(0))).getValue();
            this.colorG = ((GuiSliderMod)((Object)this.buttons.get(1))).getValue();
            this.colorB = ((GuiSliderMod)((Object)this.buttons.get(2))).getValue();
            int color = (this.colorR << 16) + (this.colorG << 8) + this.colorB;
            if (color > 0xFFFFFF) {
                color = 0xFFFFFF;
            }
            if (color < 0) {
                color = 0;
            }
            this.color = color;
        }
        this.colorCodeField.func_146178_a();
    }

    public boolean keyPressed(int p_keyPressed_1_, int p_keyPressed_2_, int p_keyPressed_3_) {
        if (this.colorCodeField.isFocused()) {
            this.colorCodeField.keyPressed(p_keyPressed_1_, p_keyPressed_2_, p_keyPressed_3_);
            if (p_keyPressed_1_ == 28) {
                this.colorCodeField.func_146195_b(false);
            }
        }
        return super.keyPressed(p_keyPressed_1_, p_keyPressed_2_, p_keyPressed_3_);
    }

    @Override
    public void render(int mouseX, int mouseY, float partialTicks) {
        FontRenderer fontRenderer = this.minecraft.field_71466_p;
        this.renderBackground();
        this.drawCenteredString(fontRenderer, this.title, this.width / 2, 12, -1);
        this.drawCenteredString(fontRenderer, I18n.func_135052_a((String)"color.red", (Object[])new Object[0]), this.width / 2, 31, -1);
        this.drawCenteredString(fontRenderer, I18n.func_135052_a((String)"color.green", (Object[])new Object[0]), this.width / 2, 56, -1);
        this.drawCenteredString(fontRenderer, I18n.func_135052_a((String)"color.blue", (Object[])new Object[0]), this.width / 2, 81, -1);
        this.colorCodeField.renderButton(mouseX, mouseY, partialTicks);
        this.drawCenteredString(fontRenderer, I18n.func_135052_a((String)"gui.rpg.result", (Object[])new Object[0]) + ": " + Settings.intToHexString(this.color), this.width / 2, 141, -1);
        super.render(mouseX, mouseY, partialTicks);
        HudElement.drawCustomBar(this.width / 2 - 75, 149, 150, 16, 100.0, 0, 0, this.color, HudElement.offsetColorPercent(this.color, 25), true);
    }
}

