/*
 * Decompiled with CFR 0.152.
 */
package com.github.ipixeli.gender.client.gui;

import com.github.ipixeli.gender.client.AccessorMC;
import com.github.ipixeli.gender.client.GenderClient;
import com.github.ipixeli.gender.client.gui.ScreenBase;
import com.github.ipixeli.gender.client.gui.SpecialSlot;
import com.github.ipixeli.gender.core.Gender;
import com.github.ipixeli.gender.core.client.Config;
import com.github.ipixeli.gender.core.profiles.BaseListMgr;
import com.github.ipixeli.gender.core.profiles.EnumAge;
import com.github.ipixeli.gender.core.profiles.EnumGender;
import com.github.ipixeli.gender.core.profiles.EnumModel;
import com.github.ipixeli.gender.core.profiles.PlayerProfile;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.ImageButton;

public final class ScreenList
extends ScreenBase {
    protected int selected;
    private static BaseListMgr manager;
    private static SpecialSlot slots;
    private static TextFieldWidget textField;
    private static ImageButton butAdd;
    private static ImageButton butTogA;
    private static ImageButton butTogG;
    private static ImageButton butTogM;
    private static ImageButton butDel;
    private static boolean showTemp;
    private static PlayerProfile self;

    public ScreenList(int prevSelected) {
        this();
        this.selected = prevSelected;
    }

    public ScreenList() {
        showTemp = (Boolean)Config.serverPriority.value != false && Gender.client().tempMgr.getList().size() > 0;
        super((showTemp ? "Server" : "Client") + " Profile List");
        this.selected = -1;
        manager = showTemp ? Gender.client().tempMgr : Gender.client().getListManager();
        String name = AccessorMC.instance().getSelfUsername();
        String uuid = AccessorMC.instance().getSelfUuid();
        self = manager.get(name, uuid);
    }

    private void displayNew(int selected) {
        AccessorMC.instance().displayScreen(new ScreenList(selected));
    }

    @Override
    public void init(Minecraft mc, int screenWidth, int screenHeight) {
        super.init(mc, screenWidth, screenHeight);
        int boundUpper = 25;
        int boundLower = screenHeight - 62;
        slots = new SpecialSlot(this, mc, manager, this.width + 20, this.height, boundUpper, showTemp ? this.height - 24 : boundLower, 14);
        slots.setLeftPos(-20);
        this.children.add(slots);
        if (!showTemp) {
            this.initLocal(mc, screenWidth, screenHeight);
        }
    }

    private void initLocal(Minecraft mc, int screenWidth, int screenHeight) {
        butTogA = new ImageButton(screenWidth / 2 - 110, screenHeight - 58, 20, 20, 160, 0, 20, GenderClient.TEX_ICONS, 240, 80, a -> {
            PlayerProfile target;
            if (this.selected >= 0 && this.selected <= slots.getItemCount() && (target = manager.getList().get(this.selected)) != null) {
                boolean isSelf = target.isSamePlayer(self);
                target.setAge(EnumAge.UNSET.next((Enum)target.getAge(), isSelf));
                manager.onAttributeChangedByGUI(target, isSelf);
                this.displayNew(this.selected);
            }
        }, "Age");
        this.addButton((Widget)butTogA);
        butTogG = new ImageButton(screenWidth / 2 - 88, screenHeight - 58, 20, 20, 140, 0, 20, GenderClient.TEX_ICONS, 240, 80, a -> {
            PlayerProfile target;
            if (this.selected >= 0 && this.selected <= slots.getItemCount() && (target = manager.getList().get(this.selected)) != null) {
                boolean isSelf = target.isSamePlayer(self);
                target.setGender(EnumGender.UNSET.next((Enum)target.getGender(), isSelf));
                manager.onAttributeChangedByGUI(target, isSelf);
                this.displayNew(this.selected);
            }
        }, "Gender");
        this.addButton((Widget)butTogG);
        butTogM = new ImageButton(screenWidth / 2 - 66, screenHeight - 58, 20, 20, 180, 0, 20, GenderClient.TEX_ICONS, 240, 80, a -> {
            PlayerProfile target;
            if (this.selected >= 0 && this.selected <= slots.getItemCount() && (target = manager.getList().get(this.selected)) != null) {
                boolean isSelf = target.isSamePlayer(self);
                target.setModel(EnumModel.UNSET.next((Enum)target.getModel(), isSelf));
                manager.onAttributeChangedByGUI(target, isSelf);
                this.displayNew(this.selected);
            }
        }, "Model");
        this.addButton((Widget)butTogM);
        butDel = new ImageButton(screenWidth / 2 - 44, screenHeight - 58, 20, 20, 220, 0, 20, GenderClient.TEX_ICONS, 240, 80, a -> {
            PlayerProfile p = manager.getList().get(this.selected);
            boolean isSelf = p.name().equals(self.name());
            if (p != null && !isSelf) {
                manager.removePlayer(this.selected);
                this.displayNew(-1);
            }
        }, "Remove");
        this.addButton((Widget)butDel);
        textField = new TextFieldWidget(this.font, screenWidth / 2 - 21, screenHeight - 58, 120, 20, "USERNAME");
        textField.func_146195_b(false);
        textField.func_146203_f(16);
        textField.func_146180_a("");
        this.children.add(textField);
        butAdd = new ImageButton(screenWidth / 2 + 102, screenHeight - 58, 20, 20, 200, 0, 20, GenderClient.TEX_ICONS, 240, 80, a -> {
            if (textField.func_146179_b() != null) {
                String name = textField.func_146179_b();
                manager.getOrCreate(name, "", true);
                this.displayNew(-1);
            }
        }, "Add");
        this.addButton((Widget)butAdd);
    }

    public boolean keyPressed(int keyID, int p_keyPressed_2_, int p_keyPressed_3_) {
        if (!(showTemp || keyID != 257 && keyID != 335)) {
            butAdd.onPress();
            return true;
        }
        return super.keyPressed(keyID, p_keyPressed_2_, p_keyPressed_3_);
    }

    public void tick() {
        if (!showTemp) {
            textField.func_146178_a();
        }
        super.tick();
    }

    @Override
    public void render(int mouseX, int mouseY, float ticks) {
        slots.render(mouseX, mouseY, ticks);
        if (!showTemp) {
            boolean hasSelected;
            ScreenList.butTogA.visible = hasSelected = this.selected > -1;
            ScreenList.butTogG.visible = hasSelected;
            ScreenList.butTogM.visible = hasSelected;
            ScreenList.butDel.visible = hasSelected;
            ScreenList.butAdd.active = textField.func_146179_b().length() > 0;
            textField.render(mouseX, mouseY, ticks);
        }
        super.render(mouseX, mouseY, ticks);
    }

    static {
        showTemp = false;
    }
}

