/*
 * Decompiled with CFR 0.152.
 */
package com.github.ipixeli.gender.core.client;

import com.github.ipixeli.gender.core.Gender;
import com.github.ipixeli.gender.core.Side;
import com.github.ipixeli.gender.core.client.Config;
import com.github.ipixeli.gender.core.client.Logic;
import com.github.ipixeli.gender.core.client.MCC;
import com.github.ipixeli.gender.core.profiles.BaseListMgr;
import com.github.ipixeli.gender.core.profiles.EnumAge;
import com.github.ipixeli.gender.core.profiles.EnumGender;
import com.github.ipixeli.gender.core.profiles.FlatList;
import com.github.ipixeli.gender.core.profiles.PlayerProfile;
import java.io.File;
import java.util.Random;

public final class Client {
    private static final Random random = new Random();
    public static final String HURT_MALE = "gender:malehurt";
    public static final String HURT_FEMALE = "gender:femalehurt";
    public static final String TEX_ICONS = "gender:textures/guigender.png";
    public static final String TEX_PLAYER_ALEX = "minecraft:textures/entity/alex.png";
    public static final String TEX_PLAYER_FEMALE = "gender:textures/entity/charfemale.png";
    public static final String TEX_PLAYER_FEMALE_CHILD = "gender:textures/entity/charfemalechild.png";
    public static final String TEX_PLAYER_MALE = "minecraft:textures/entity/steve.png";
    public static final String TEX_PLAYER_MALE_CHILD = "gender:textures/entity/charmalechild.png";
    public static final String TEX_ZOMBIE_FEMALE = "gender:textures/entity/zombiefemale.png";
    public static final String TEX_ZOMBIE_FEMALE_CHILD = "gender:textures/entity/zombiefemalechild.png";
    public static final String TEX_ZOMBIE_MALE = "minecraft:textures/entity/zombie/zombie.png";
    public static final String TEX_ZOMBIE_MALE_CHILD = "gender:textures/entity/zombiemalechild.png";
    public final BaseListMgr tempMgr = new BaseListMgr(Side.TEMP, null);
    private BaseListMgr mgr;
    private MCC accessor;

    public Client(File modDir, MCC accessor) {
        this.accessor = accessor;
        this.mgr = new BaseListMgr(Side.CLIENT, new FlatList(modDir, "client-profiles.txt"));
        new Config(modDir);
    }

    public final BaseListMgr getListManager() {
        return this.mgr;
    }

    public void onLogout() {
        this.tempMgr.clear();
    }

    public String getNewLabel(String n, String u, String label) {
        String symbol = Logic.getNameDecor(n, u);
        label.replace("\u00a75\u2640\u00a7r", "");
        label.replace("\u00a73\u2642\u00a7r", "");
        label.replace("\u00a7d\u2640\u00a7r", "");
        label.replace("\u00a7b\u2642\u00a7r", "");
        return label + symbol;
    }

    public void onLogin() {
        String n = this.accessor.getSelfUsername();
        String u = this.accessor.getSelfUuid();
        if (n != null || u != null) {
            PlayerProfile p = this.mgr.getOrCreate(n, u, true);
            Gender.wrapper().sendProfilePacket(p);
        }
    }

    public void onHurtSound(String n, String u, float x, float y, float z) {
        EnumGender gender = Logic.getVisibleGender(n, u);
        if (gender == EnumGender.OTHER) {
            return;
        }
        EnumAge age = Logic.getVisibleAge(n, u);
        float pitch = (random.nextFloat() - random.nextFloat()) * 0.2f + 1.0f + age.getBasePitch();
        this.accessor.play(gender.getSound(), pitch, x, y, z);
    }
}

