/*
 * Decompiled with CFR 0.152.
 */
package com.github.ipixeli.gender.core.profiles;

import com.github.ipixeli.gender.core.Gender;
import com.github.ipixeli.gender.core.profiles.BaseListMgr;
import com.github.ipixeli.gender.core.profiles.EnumAge;
import com.github.ipixeli.gender.core.profiles.EnumGender;
import com.github.ipixeli.gender.core.profiles.EnumModel;
import com.github.ipixeli.gender.core.profiles.PlayerProfile;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Iterator;

public final class FlatList {
    private BaseListMgr mgr;
    private File suchFile;
    private boolean isReading;

    public FlatList(File veryDir, String suchName) {
        this.suchFile = new File(veryDir, suchName);
        if (!this.suchFile.exists()) {
            try {
                Gender.log().logWarn("Did not locate an existing file " + this.suchFile.getAbsolutePath() + ".");
                this.suchFile.createNewFile();
            }
            catch (IOException e) {
                Gender.log().logWarn("Failed to create or locate file " + this.suchFile.getAbsolutePath() + " with error: " + e.getMessage());
            }
        } else {
            Gender.log().logDebug("Located existing " + this.suchFile.getName() + " at: " + this.suchFile.getAbsolutePath());
        }
    }

    public void register(BaseListMgr mgr) {
        this.mgr = mgr;
        this.readList();
    }

    public void readList() {
        Gender.log().logDebug("Reading file " + this.suchFile.getName());
        try {
            this.isReading = true;
            BufferedReader reader = new BufferedReader(new FileReader(this.suchFile));
            Iterator ite = reader.lines().iterator();
            while (ite.hasNext()) {
                String line = (String)ite.next();
                if (line == null || line.length() <= 0) continue;
                this.doReadLine(line);
            }
            reader.close();
            this.isReading = false;
        }
        catch (Exception e) {
            Gender.log().logErr("Failed to load " + this.suchFile.getName() + "with error: " + e.getMessage() + " Recreating...");
            e.printStackTrace();
        }
    }

    public void saveList() {
        Gender.log().logDebug("Saving file " + this.suchFile.getName());
        if (!this.isReading) {
            try {
                PrintWriter writer = new PrintWriter((Writer)new FileWriter(this.suchFile), false);
                this.doWriteLines(writer);
                writer.close();
            }
            catch (Exception e) {
                Gender.log().logErr("Failed to save " + this.suchFile.getName() + " with error: " + e.getMessage());
                e.printStackTrace();
            }
        }
    }

    private void doReadLine(String line) {
        try {
            String[] t = line.trim().split(",");
            String name = t[0] == null ? "" : t[0];
            String uuid = t[1] == null ? "" : t[1];
            String age = t[2];
            String gender = t[3];
            String model = t[4];
            if (name != null && name.length() > 0 || uuid != null && uuid.length() > 0) {
                this.mgr.getOrCreate("" + name, "" + uuid, EnumAge.valueOf(age), EnumGender.valueOf(gender), EnumModel.valueOf(model), false);
            }
        }
        catch (Exception e) {
            Gender.log().logErr("Failed to read line within " + this.suchFile.getName() + ": " + line);
        }
    }

    private void doWriteLines(PrintWriter writer) {
        for (PlayerProfile p : this.mgr.getList()) {
            String name = p.name();
            String uuid = p.uuid();
            String line = name + "," + uuid + "," + p.getAge().toString() + "," + p.getGender().toString() + "," + p.getModel().toString();
            writer.println(line);
        }
    }
}

