/*
 * Decompiled with CFR 0.152.
 */
package com.github.ipixeli.gender.server;

import com.github.ipixeli.gender.Datagram;
import com.github.ipixeli.gender.GenderForge;
import com.github.ipixeli.gender.core.Gender;
import com.github.ipixeli.gender.core.profiles.PlayerProfile;
import com.github.ipixeli.gender.server.AccessorMCS;
import com.github.ipixeli.gender.server.ServerCmd;
import com.mojang.brigadier.CommandDispatcher;
import java.io.File;
import java.util.List;
import net.minecraft.command.CommandSource;
import net.minecraft.network.NetworkManager;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.PacketDistributor;

public class GenderServer {
    public static void onSetup(File modDir, MinecraftServer server, CommandDispatcher<CommandSource> cmdDispatcher) {
        new AccessorMCS(server);
        new ServerCmd().register(cmdDispatcher);
        Gender.onServerStartup(modDir);
    }

    public static void sendToClient(PlayerProfile p, NetworkManager n) {
        GenderForge.channel.sendTo((Object)new Datagram(p), n, NetworkDirection.PLAY_TO_CLIENT);
    }

    public static void sendToAllClients(PlayerProfile p) {
        GenderForge.channel.send(PacketDistributor.ALL.noArg(), (Object)new Datagram(p));
    }

    public static List<String> onCmdList() {
        List<PlayerProfile> profiles = Gender.server().getListManager().getList();
        return Gender.server().onCmdList(profiles);
    }
}

