var ASMAPI=Java.type("net.minecraftforge.coremod.api.ASMAPI");
var Opcodes=Java.type('org.objectweb.asm.Opcodes');
var InsnList=Java.type('org.objectweb.asm.tree.InsnList');
var FieldNode=Java.type('org.objectweb.asm.tree.FieldNode');
var VarInsnNode=Java.type('org.objectweb.asm.tree.VarInsnNode');
var FieldInsnNode=Java.type('org.objectweb.asm.tree.FieldInsnNode');
var MethodInsnNode=Java.type('org.objectweb.asm.tree.MethodInsnNode');
var MR="net/minecraft/client/renderer/entity/model/RendererModel";
var PM="net/minecraft/client/renderer/entity/model/PlayerModel";
var BM="net/minecraft/client/renderer/entity/model/BipedModel";
var LE="net/minecraft/entity/LivingEntity";
var BBF=ASMAPI.mapField("field_78115_e");
var M0=ASMAPI.mapMethod("<init>");
var M0_DESC="(FZ)V";
var M1=ASMAPI.mapMethod("func_78088_a");
var M1_DESC="(L"+LE+";FFFFFF)V";
var M2=ASMAPI.mapMethod("func_212844_a_");
var M2_DESC="(L"+LE+";FFFFFF)V";
var NUM_FOUND=0;
var NUM_PATCHED=0;
function log(message){
	print("[GenderCore]: "+message);
}
function initializeCoreMod(){
	return{
		"GenderCore-PlayerModel":{
			"target":{"type":"CLASS",'name': PM},
			"transformer": function(classNode){
				patchFields(classNode);
				for each(var method in classNode.methods){
					if(method.name.equals(M0)&&method.desc.equals(M0_DESC)){
						log("Transforming "+classNode.name+"."+method.name);
						patchInit(classNode.name,method);
					}else if(method.name.equals(M1)&&method.desc.equals(M1_DESC)){
						log("Transforming "+classNode.name+"."+method.name);
						patchRender(method);
					}else if(method.name.equals(M2)&&method.desc.equals(M2_DESC)){
						log("Transforming "+classNode.name+"."+method.name);
						patchRotate(method);
					}
				}
				log("Found methods: "+NUM_FOUND+" of 3");
				log("Patched methods: "+NUM_PATCHED+" of 3");
				return classNode;
			}
		}
	};
}
function patchFields(classNode){
	classNode.fields.add(new FieldNode(1,"cynthia","L"+MR+";","L"+MR+";",null));
	classNode.fields.add(new FieldNode(1,"stephanie","L"+MR+";","L"+MR+";",null));
}
function findFinalReturn(method){
	var finalReturn;
	for(var i=method.instructions.size()-1;i>=0;i--){
		var instruction=method.instructions.get(i);
		if(instruction.getOpcode()==Opcodes.RETURN){
			finalReturn=instruction;
			break;
		}
	}
	if(finalReturn==null){
		log("Failed to find last return "+method.name+method.desc);
	}
	return finalReturn;
}
function patchInit(className,method){
	NUM_FOUND++;
	var targetInst=findFinalReturn(method);
	if(targetInst!=null){
		var toInject=new InsnList();
		toInject.add(new VarInsnNode(Opcodes.ALOAD,0));
		toInject.add(new VarInsnNode(Opcodes.ALOAD,0));
		toInject.add(new MethodInsnNode(Opcodes.INVOKESTATIC,"com/github/ipixeli/gender/client/Model","initC","(L"+BM+";)L"+MR+";",false));
		toInject.add(new FieldInsnNode(Opcodes.PUTFIELD,PM,"cynthia","L"+MR+";"));
		toInject.add(new VarInsnNode(Opcodes.ALOAD,0));
		toInject.add(new VarInsnNode(Opcodes.ALOAD,0));
		toInject.add(new MethodInsnNode(Opcodes.INVOKESTATIC,"com/github/ipixeli/gender/client/Model","initS","(L"+BM+";)L"+MR+";",false));
		toInject.add(new FieldInsnNode(Opcodes.PUTFIELD,PM,"stephanie","L"+MR+";"));
		method.instructions.insertBefore(targetInst,toInject);
		NUM_PATCHED++;
	}
}
function patchRender(method){
	NUM_FOUND++;
	var targetInst;
	for(var i=method.instructions.size()-1;i>=0;i--){
		var instruction=method.instructions.get(i);
		var instructionBefore=method.instructions.get(i);
		if(instruction.getOpcode()==Opcodes.INVOKESTATIC){
			targetInst=instructionBefore;
			break;
		}
	}
	if(targetInst==null){
		log("Failed to find last INVOKESTATIC "+method.name+method.desc);
	}else{
		var toInject=new InsnList();
		toInject.add(new VarInsnNode(Opcodes.ALOAD,1));
		toInject.add(new VarInsnNode(Opcodes.ALOAD,0));
		toInject.add(new FieldInsnNode(Opcodes.GETFIELD,PM,BBF,"L"+MR+";"));
		toInject.add(new VarInsnNode(Opcodes.ALOAD,0));
		toInject.add(new FieldInsnNode(Opcodes.GETFIELD,PM,"cynthia","L"+MR+";"));
		toInject.add(new VarInsnNode(Opcodes.ALOAD,0));
		toInject.add(new FieldInsnNode(Opcodes.GETFIELD,PM,"stephanie","L"+MR+";"));
		toInject.add(new VarInsnNode(Opcodes.FLOAD,7));
		toInject.add(new MethodInsnNode(Opcodes.INVOKESTATIC,"com/github/ipixeli/gender/client/Renders","onEvent","(L"+LE+";L"+MR+";L"+MR+";L"+MR+";F)V"));
		method.instructions.insertBefore(targetInst,toInject);
		NUM_PATCHED++;
	}
}
function patchRotate(method){
	NUM_FOUND++;
	var targetInst=findFinalReturn(method);
	if(targetInst!=null){
		var toInject=new InsnList();
		toInject.add(new VarInsnNode(Opcodes.ALOAD,0));
		toInject.add(new FieldInsnNode(Opcodes.GETFIELD,PM,BBF,"L"+MR+";"));
		toInject.add(new VarInsnNode(Opcodes.ALOAD,0));
		toInject.add(new FieldInsnNode(Opcodes.GETFIELD,PM,"cynthia","L"+MR+";"));
		toInject.add(new VarInsnNode(Opcodes.ALOAD,0));
		toInject.add(new FieldInsnNode(Opcodes.GETFIELD,PM,"stephanie","L"+MR+";"));
		toInject.add(new MethodInsnNode(Opcodes.INVOKESTATIC,"com/github/ipixeli/gender/client/Renders","onEvent","(L"+MR+";L"+MR+";L"+MR+";)V"));
		method.instructions.insertBefore(targetInst,toInject);
		NUM_PATCHED++;
	}
}