var ASMAPI=Java.type("net.minecraftforge.coremod.api.ASMAPI");
var Opcodes=Java.type('org.objectweb.asm.Opcodes');
var InsnList=Java.type('org.objectweb.asm.tree.InsnList');
var InsnNode=Java.type('org.objectweb.asm.tree.InsnNode');
var MethodInsnNode=Java.type('org.objectweb.asm.tree.MethodInsnNode');
var VarInsnNode=Java.type('org.objectweb.asm.tree.VarInsnNode');
var M0=ASMAPI.mapMethod("func_177334_a");
var M0_DESC="(Ljava/util/UUID;)Lnet/minecraft/util/ResourceLocation;";
var NUM_FOUND=0;
var NUM_PATCHED=0;
function log(message){
	print("[GenderCore]: "+message);
}
function initializeCoreMod(){
	return{
		"GenderCore-PlayerTextures":{
			"target":{"type": "CLASS",'name': 'net.minecraft.client.resources.DefaultPlayerSkin'},
			"transformer": function(classNode){
				for each(var method in classNode.methods){
					if(method.name.equals(M0)&&method.desc.equals(M0_DESC)){
						log("Transforming "+method.name+" in "+classNode.name);
						doPatchMethodNodeInClassNode(method);
					}
				}
				log("Found methods: "+NUM_FOUND+" of 1");
				log("Patched methods: "+NUM_PATCHED+" of 1");
				return classNode;
			}
		}
	};
}
function doPatchMethodNodeInClassNode(method){
	NUM_FOUND++;
	var toInject=new InsnList();
	toInject.add(new VarInsnNode(Opcodes.ALOAD,0));
	toInject.add(new MethodInsnNode(Opcodes.INVOKESTATIC,"com/github/ipixeli/gender/client/Renders","onEvent",M0_DESC));
	toInject.add(new InsnNode(Opcodes.ARETURN));
	method.instructions=toInject;
	NUM_PATCHED++;
}