/*
 * Decompiled with CFR 0.152.
 */
package net.spellcraftgaming.rpghud.gui;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.util.text.ITextComponent;
import net.spellcraftgaming.rpghud.gui.GuiButtonTooltip;
import net.spellcraftgaming.rpghud.main.ModRPGHud;

public class GuiScreenTooltip
extends Screen {
    protected List<GuiTextLabel> labelList = new ArrayList<GuiTextLabel>();

    protected GuiScreenTooltip(ITextComponent titleIn) {
        super(titleIn);
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        super.render(mouseX, mouseY, partialTicks);
        if (ModRPGHud.instance.settings.getBoolValue("enable_button_tooltip").booleanValue()) {
            this.drawTooltip(mouseX, mouseY);
        }
        for (GuiTextLabel label : this.labelList) {
            label.render(this);
        }
    }

    private void drawTooltip(int mouseX, int mouseY) {
        Minecraft mc = Minecraft.func_71410_x();
        FontRenderer fontRenderer = mc.field_71466_p;
        GuiScreenTooltip gui = null;
        if (!(mc.field_71462_r instanceof GuiScreenTooltip)) {
            return;
        }
        gui = (GuiScreenTooltip)mc.field_71462_r;
        boolean shouldRenderTooltip = false;
        GuiButtonTooltip button = null;
        for (int x = 0; x < this.buttons.size(); ++x) {
            Widget b = (Widget)this.buttons.get(x);
            if (b instanceof GuiButtonTooltip) {
                button = (GuiButtonTooltip)b;
            }
            if (button == null || !button.isHovered()) continue;
            shouldRenderTooltip = true;
            break;
        }
        if (shouldRenderTooltip) {
            int posX = mouseX + 5;
            int posY = mouseY + 5;
            int totalWidth = 0;
            boolean reverseY = false;
            String[] tooltip = button.getTooltip();
            if (tooltip != null) {
                int id;
                int counter = 0;
                for (id = 0; id < tooltip.length; ++id) {
                    int width = fontRenderer.func_78256_a(tooltip[id]);
                    if (totalWidth < width) {
                        totalWidth = fontRenderer.func_78256_a(tooltip[id]);
                    }
                    ++counter;
                }
                if ((posX -= totalWidth / 2) + totalWidth + 10 > gui.width) {
                    posX -= posX + totalWidth + 10 - gui.width;
                }
                if (posX < 0) {
                    posX = 0;
                }
                if (posY + 3 + tooltip.length * 12 + 2 > gui.height) {
                    reverseY = true;
                }
                if (reverseY) {
                    GuiScreenTooltip.fill((int)posX, (int)(posY - 3 - tooltip.length * 12 - 2), (int)(posX + totalWidth + 10), (int)posY, (int)-1610612736);
                } else {
                    GuiScreenTooltip.fill((int)posX, (int)posY, (int)(posX + totalWidth + 10), (int)(posY + 3 + tooltip.length * 12 + 2), (int)-1610612736);
                }
                for (id = 0; id < tooltip.length; ++id) {
                    if (tooltip[id].isEmpty()) continue;
                    if (reverseY) {
                        gui.drawString(fontRenderer, tooltip[id], posX + 5, posY - 2 - 12 * (counter - id - 1) - 10, 0xBBBBBB);
                        continue;
                    }
                    gui.drawString(fontRenderer, tooltip[id], posX + 5, posY + 5 + 12 * id, 0xBBBBBB);
                }
            }
        }
    }

    public class GuiTextLabel {
        int x;
        int y;
        String text;

        public GuiTextLabel(int x, int y, String text) {
            this.x = x;
            this.y = y;
            this.text = text;
        }

        public void render(Screen gui) {
            RenderSystem.enableBlend();
            RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            gui.drawString(((GuiScreenTooltip)GuiScreenTooltip.this).minecraft.field_71466_p, this.text, this.x, this.y, -1);
        }
    }
}

