/*
 * Decompiled with CFR 0.152.
 */
package net.spellcraftgaming.rpghud.gui;

import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.util.math.MathHelper;
import net.spellcraftgaming.rpghud.gui.GuiButtonTooltip;
import net.spellcraftgaming.rpghud.gui.hud.element.HudElement;

public class GuiSliderMod
extends GuiButtonTooltip {
    private EnumColor color;
    public double sliderValue = 1.0;
    public String dispString = "";
    public boolean dragging = false;
    public boolean showDecimal = true;
    public double minValue = 0.0;
    public double maxValue = 5.0;
    public int precision = 1;
    private final float valueStep;
    public int value;
    @Nullable
    public ISlider parent = null;
    public String suffix = "";
    public boolean drawString = true;

    public GuiSliderMod(EnumColor color, int x, int y, float value, float minValueIn, float maxValue, float valueStep, Button.IPressable titleIn) {
        this(color, x, y, value, minValueIn, maxValue, valueStep, null, titleIn);
    }

    public GuiSliderMod(EnumColor color, int x, int y, float value, float minValueIn, float maxValue, float valueStep, @Nullable ISlider par, Button.IPressable titleIn) {
        super(x, y, 150, 12, "", titleIn);
        this.color = color;
        this.sliderValue = value / 255.0f;
        this.value = (int)Math.ceil(value);
        this.minValue = minValueIn;
        this.maxValue = maxValue;
        this.valueStep = valueStep;
        this.y = y;
        if (this.showDecimal) {
            String val = Double.toString(this.sliderValue * ((double)maxValue - this.minValue) + this.minValue);
            this.precision = Math.min(val.substring(val.indexOf(".") + 1).length(), 4);
        } else {
            String val = Integer.toString((int)Math.round(this.sliderValue * ((double)maxValue - this.minValue) + this.minValue));
            this.precision = 0;
        }
        if (!this.drawString) {
            this.dispString = "";
        }
    }

    protected int getYImage(boolean p_getYImage_1_) {
        return 0;
    }

    public boolean mouseReleased(double p_mouseReleased_1_, double p_mouseReleased_3_, int p_mouseReleased_5_) {
        this.dragging = false;
        return super.mouseReleased(p_mouseReleased_1_, p_mouseReleased_3_, p_mouseReleased_5_);
    }

    public int getValueInt() {
        return (int)Math.round(this.sliderValue * (this.maxValue - this.minValue) + this.minValue);
    }

    public int getValue() {
        return (int)Math.ceil(this.value);
    }

    public void setValue(double d) {
        this.sliderValue = (d - this.minValue) / (this.maxValue - this.minValue);
    }

    protected void renderBg(Minecraft par1Minecraft, int par2, int par3) {
    }

    public void onClick(double mouseX, double mouseY) {
        this.sliderValue = Math.ceil(MathHelper.func_151237_a((double)(this.sliderValue * 255.0), (double)0.0, (double)255.0));
        this.updateSlider(mouseX, mouseY);
        this.dragging = true;
    }

    public void updateSlider(double mouseX, double mouseY) {
        this.sliderValue = (float)(mouseX - (double)(this.x + 4)) / (float)(this.width - 8);
        if (this.sliderValue < 0.0) {
            this.sliderValue = 0.0;
        }
        if (this.sliderValue > 1.0) {
            this.sliderValue = 1.0;
        }
        this.value = MathHelper.func_76143_f((double)MathHelper.func_151237_a((double)(this.sliderValue * 255.0), (double)0.0, (double)255.0));
    }

    private String getDisplayString() {
        return "#" + Integer.toHexString(this.getValue()).toUpperCase();
    }

    @Override
    public void render(int mouseX, int mouseY, float partial) {
        if (this.visible) {
            if (this.dragging) {
                this.updateSlider(mouseX, mouseY);
            }
            Minecraft mc = Minecraft.func_71410_x();
            int color = 0 + (this.color == EnumColor.RED ? this.value << 16 : (this.color == EnumColor.GREEN ? this.value << 8 : this.value));
            HudElement.drawCustomBar(this.x, this.y, this.width, this.height, 100.0, color, HudElement.offsetColorPercent(color, 25));
            color = 0xE0E0E0;
            if (this.packedFGColor != 0) {
                color = this.packedFGColor;
            } else if (!this.active) {
                color = 0xA0A0A0;
            } else if (this.isHovered) {
                color = 0xFFFFA0;
            }
            String buttonText = this.getDisplayString();
            mc.func_110434_K().func_110577_a(WIDGETS_LOCATION);
            this.blit(this.x + (int)(this.sliderValue * (double)(this.width - 8)), this.y, 0, 66, 4, this.height / 2);
            this.blit(this.x + (int)(this.sliderValue * (double)(this.width - 8)), this.y + this.height / 2, 0, 86 - this.height / 2, 4, this.height / 2);
            this.blit(this.x + (int)(this.sliderValue * (double)(this.width - 8)) + 4, this.y, 196, 66, 4, this.height / 2);
            this.blit(this.x + (int)(this.sliderValue * (double)(this.width - 8)) + 4, this.y + this.height / 2, 196, 86 - this.height / 2, 4, this.height / 2);
            this.drawCenteredString(mc.field_71466_p, buttonText, this.x + this.width / 2, this.y + (this.height - 8) / 2, color);
        }
    }

    public float normalizeValue(float value) {
        return (float)MathHelper.func_151237_a((double)(((double)this.snapToStepClamp(value) - this.maxValue) / (this.maxValue - this.minValue)), (double)0.0, (double)1.0);
    }

    public float denormalizeValue(float value) {
        return this.snapToStepClamp((float)(this.minValue + (this.maxValue - this.minValue) * (double)MathHelper.func_76131_a((float)value, (float)0.0f, (float)1.0f)));
    }

    public float snapToStepClamp(float value) {
        value = this.snapToStep(value);
        return (float)MathHelper.func_151237_a((double)value, (double)this.minValue, (double)this.maxValue);
    }

    private float snapToStep(float value) {
        if (this.valueStep > 0.0f) {
            value = this.valueStep * (float)Math.round(value / this.valueStep);
        }
        return value;
    }

    public static interface ISlider {
        public void onChangeSliderValue(GuiSliderMod var1);
    }

    public static enum EnumColor {
        RED,
        GREEN,
        BLUE;

    }
}

