/*
 * Decompiled with CFR 0.152.
 */
package net.spellcraftgaming.rpghud.gui.hud.element.vanilla;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Quaternion;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.monster.SpiderEntity;
import net.minecraft.entity.passive.SquidEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.Vec3d;
import net.spellcraftgaming.rpghud.gui.hud.element.HudElement;
import net.spellcraftgaming.rpghud.gui.hud.element.HudElementType;

public class HudElementEntityInspectVanilla
extends HudElement {
    protected static final ResourceLocation DAMAGE_INDICATOR = new ResourceLocation("rpghud:textures/entityinspect.png");

    @Override
    public boolean checkConditions() {
        return !this.mc.field_71474_y.field_74319_N && this.settings.getBoolValue("enable_entity_inspect") != false;
    }

    public HudElementEntityInspectVanilla() {
        super(HudElementType.ENTITY_INSPECT, 0, 0, 0, 0, true);
    }

    @Override
    public void drawElement(AbstractGui gui, float zLevel, float partialTicks, int scaledWidth, int scaledHeight) {
        LivingEntity focused = HudElementEntityInspectVanilla.getFocusedEntity((Entity)this.mc.field_71439_g);
        if (focused != null) {
            int posX = scaledWidth / 2 + this.settings.getPositionValue("inspector_position")[0];
            int posY = this.settings.getPositionValue("inspector_position")[1];
            this.mc.func_110434_K().func_110577_a(DAMAGE_INDICATOR);
            gui.blit(posX - 62, 20 + posY, 0, 0, 128, 36);
            HudElementEntityInspectVanilla.drawCustomBar(posX - 25, 34 + posY, 89, 8, (double)focused.func_110143_aJ() / (double)focused.func_110138_aP() * 100.0, this.settings.getIntValue("color_health"), HudElementEntityInspectVanilla.offsetColorPercent(this.settings.getIntValue("color_health"), 25));
            String stringHealth = (double)Math.round(focused.func_110143_aJ() * 10.0f) / 10.0 + "/" + (double)Math.round(focused.func_110138_aP() * 10.0f) / 10.0;
            RenderSystem.scaled((double)0.5, (double)0.5, (double)0.5);
            gui.drawCenteredString(this.mc.field_71466_p, stringHealth, (posX - 27 + 44) * 2, (36 + posY) * 2, -1);
            RenderSystem.scaled((double)2.0, (double)2.0, (double)2.0);
            int x = posX - 29 + 44 - this.mc.field_71466_p.func_78256_a(focused.func_200200_C_().getString()) / 2;
            int y = 25 + posY;
            this.mc.field_71466_p.func_211126_b(focused.func_200200_C_().getString(), (float)(x + 1), (float)y, 0);
            this.mc.field_71466_p.func_211126_b(focused.func_200200_C_().getString(), (float)(x - 1), (float)y, 0);
            this.mc.field_71466_p.func_211126_b(focused.func_200200_C_().getString(), (float)x, (float)(y + 1), 0);
            this.mc.field_71466_p.func_211126_b(focused.func_200200_C_().getString(), (float)x, (float)(y - 1), 0);
            this.mc.field_71466_p.func_211126_b(focused.func_200200_C_().getString(), (float)x, (float)y, -1);
            HudElementEntityInspectVanilla.drawEntityOnScreen(posX - 60 + 16, 49 + posY, focused);
        }
    }

    public static void drawEntityOnScreen(int posX, int posY, LivingEntity ent) {
        int scale = 1;
        int s1 = (int)(18.0f / ent.func_213302_cg());
        int s3 = (int)(18.0f / ent.func_213355_cm());
        int offset = 0;
        scale = s1 > s3 ? s3 : s1;
        if (ent instanceof SquidEntity) {
            scale = 11;
            offset = -13;
        } else if (ent instanceof SpiderEntity) {
            scale = 11;
            offset = -5;
        }
        float lvt_6_1_ = (float)Math.atan(4.5);
        float lvt_7_1_ = (float)Math.atan(0.0);
        RenderSystem.pushMatrix();
        RenderSystem.translatef((float)posX, (float)(posY += offset), (float)1050.0f);
        RenderSystem.scalef((float)1.0f, (float)1.0f, (float)-1.0f);
        MatrixStack lvt_8_1_ = new MatrixStack();
        lvt_8_1_.func_227861_a_(0.0, 0.0, 1000.0);
        lvt_8_1_.func_227862_a_((float)scale, (float)scale, (float)scale);
        Quaternion lvt_9_1_ = Vector3f.field_229183_f_.func_229187_a_(180.0f);
        Quaternion lvt_10_1_ = Vector3f.field_229179_b_.func_229187_a_(lvt_7_1_ * 20.0f);
        lvt_9_1_.func_195890_a(lvt_10_1_);
        lvt_8_1_.func_227863_a_(lvt_9_1_);
        float lvt_11_1_ = ent.field_70761_aq;
        float lvt_12_1_ = ent.field_70177_z;
        float lvt_13_1_ = ent.field_70125_A;
        float lvt_14_1_ = ent.field_70758_at;
        float lvt_15_1_ = ent.field_70759_as;
        ent.field_70761_aq = 180.0f + lvt_6_1_ * 20.0f;
        ent.field_70177_z = 180.0f + lvt_6_1_ * 40.0f;
        ent.field_70125_A = -lvt_7_1_ * 20.0f;
        ent.field_70759_as = ent.field_70177_z - 25.0f;
        ent.field_70758_at = ent.field_70177_z;
        EntityRendererManager lvt_16_1_ = Minecraft.func_71410_x().func_175598_ae();
        lvt_10_1_.func_195892_e();
        lvt_16_1_.func_229089_a_(lvt_10_1_);
        lvt_16_1_.func_178633_a(false);
        IRenderTypeBuffer.Impl lvt_17_1_ = Minecraft.func_71410_x().func_228019_au_().func_228487_b_();
        lvt_16_1_.func_229084_a_((Entity)ent, 0.0, 0.0, 0.0, 0.0f, 1.0f, lvt_8_1_, (IRenderTypeBuffer)lvt_17_1_, 0xF000F0);
        lvt_17_1_.func_228461_a_();
        lvt_16_1_.func_178633_a(true);
        ent.field_70761_aq = lvt_11_1_;
        ent.field_70177_z = lvt_12_1_;
        ent.field_70125_A = lvt_13_1_;
        ent.field_70758_at = lvt_14_1_;
        ent.field_70759_as = lvt_15_1_;
        RenderSystem.popMatrix();
    }

    public static LivingEntity getFocusedEntity(Entity watcher) {
        LivingEntity focusedEntity = null;
        double maxDistance = 64.0;
        Vec3d vec = new Vec3d(watcher.func_226277_ct_(), watcher.func_226278_cu_(), watcher.func_226281_cx_());
        Vec3d posVec = watcher.func_174791_d();
        if (watcher instanceof PlayerEntity) {
            vec = vec.func_72441_c(0.0, (double)watcher.func_70047_e(), 0.0);
            posVec = posVec.func_72441_c(0.0, (double)watcher.func_70047_e(), 0.0);
        }
        Vec3d lookVec = watcher.func_70040_Z();
        Vec3d vec2 = vec.func_178787_e(lookVec.func_72432_b().func_186678_a(maxDistance));
        BlockRayTraceResult ray = watcher.field_70170_p.func_217299_a(new RayTraceContext(vec, vec2, RayTraceContext.BlockMode.OUTLINE, RayTraceContext.FluidMode.NONE, watcher));
        double distance = maxDistance;
        if (ray != null) {
            distance = ray.func_216347_e().func_72438_d(posVec);
        }
        Vec3d reachVector = posVec.func_72441_c(lookVec.field_72450_a * maxDistance, lookVec.field_72448_b * maxDistance, lookVec.field_72449_c * maxDistance);
        double currentDistance = distance;
        List entitiesWithinMaxDistance = watcher.field_70170_p.func_72839_b(watcher, watcher.func_174813_aQ().func_72314_b(lookVec.field_72450_a * maxDistance, lookVec.field_72448_b * maxDistance, lookVec.field_72449_c * maxDistance).func_72321_a(1.0, 1.0, 1.0));
        for (Entity entity : entitiesWithinMaxDistance) {
            Vec3d hitVec;
            double distanceToEntity;
            if (!(entity instanceof LivingEntity)) continue;
            float collisionBorderSize = entity.func_70111_Y();
            AxisAlignedBB hitBox = entity.func_174813_aQ().func_72321_a((double)collisionBorderSize, (double)collisionBorderSize, (double)collisionBorderSize);
            Vec3d hitVecIn = HudElementEntityInspectVanilla.intercept(posVec, reachVector, hitBox);
            if (hitBox.func_72318_a(posVec)) {
                if (!(currentDistance <= 0.0)) continue;
                currentDistance = 0.0;
                focusedEntity = (LivingEntity)entity;
                continue;
            }
            if (hitVecIn == null || !((distanceToEntity = posVec.func_72438_d(hitVec = new Vec3d(hitVecIn.field_72450_a, hitVecIn.field_72448_b, hitVecIn.field_72449_c))) <= currentDistance)) continue;
            currentDistance = distanceToEntity;
            focusedEntity = (LivingEntity)entity;
        }
        return focusedEntity;
    }

    public static Vec3d intercept(Vec3d vecA, Vec3d vecB, AxisAlignedBB bb) {
        double[] adouble = new double[]{1.0};
        Direction enumfacing = null;
        double d0 = vecB.field_72450_a - vecA.field_72450_a;
        double d1 = vecB.field_72448_b - vecA.field_72448_b;
        double d2 = vecB.field_72449_c - vecA.field_72449_c;
        if ((enumfacing = HudElementEntityInspectVanilla.func_197741_a(bb, vecA, adouble, enumfacing, d0, d1, d2)) == null) {
            return null;
        }
        double d3 = adouble[0];
        return vecA.func_72441_c(d3 * d0, d3 * d1, d3 * d2);
    }

    @Nullable
    private static Direction func_197741_a(AxisAlignedBB aabb, Vec3d p_197741_1_, double[] p_197741_2_, @Nullable Direction facing, double p_197741_4_, double p_197741_6_, double p_197741_8_) {
        if (p_197741_4_ > 1.0E-7) {
            facing = HudElementEntityInspectVanilla.func_197740_a(p_197741_2_, facing, p_197741_4_, p_197741_6_, p_197741_8_, aabb.field_72340_a, aabb.field_72338_b, aabb.field_72337_e, aabb.field_72339_c, aabb.field_72334_f, Direction.WEST, p_197741_1_.field_72450_a, p_197741_1_.field_72448_b, p_197741_1_.field_72449_c);
        } else if (p_197741_4_ < -1.0E-7) {
            facing = HudElementEntityInspectVanilla.func_197740_a(p_197741_2_, facing, p_197741_4_, p_197741_6_, p_197741_8_, aabb.field_72336_d, aabb.field_72338_b, aabb.field_72337_e, aabb.field_72339_c, aabb.field_72334_f, Direction.EAST, p_197741_1_.field_72450_a, p_197741_1_.field_72448_b, p_197741_1_.field_72449_c);
        }
        if (p_197741_6_ > 1.0E-7) {
            facing = HudElementEntityInspectVanilla.func_197740_a(p_197741_2_, facing, p_197741_6_, p_197741_8_, p_197741_4_, aabb.field_72338_b, aabb.field_72339_c, aabb.field_72334_f, aabb.field_72340_a, aabb.field_72336_d, Direction.DOWN, p_197741_1_.field_72448_b, p_197741_1_.field_72449_c, p_197741_1_.field_72450_a);
        } else if (p_197741_6_ < -1.0E-7) {
            facing = HudElementEntityInspectVanilla.func_197740_a(p_197741_2_, facing, p_197741_6_, p_197741_8_, p_197741_4_, aabb.field_72337_e, aabb.field_72339_c, aabb.field_72334_f, aabb.field_72340_a, aabb.field_72336_d, Direction.UP, p_197741_1_.field_72448_b, p_197741_1_.field_72449_c, p_197741_1_.field_72450_a);
        }
        if (p_197741_8_ > 1.0E-7) {
            facing = HudElementEntityInspectVanilla.func_197740_a(p_197741_2_, facing, p_197741_8_, p_197741_4_, p_197741_6_, aabb.field_72339_c, aabb.field_72340_a, aabb.field_72336_d, aabb.field_72338_b, aabb.field_72337_e, Direction.NORTH, p_197741_1_.field_72449_c, p_197741_1_.field_72450_a, p_197741_1_.field_72448_b);
        } else if (p_197741_8_ < -1.0E-7) {
            facing = HudElementEntityInspectVanilla.func_197740_a(p_197741_2_, facing, p_197741_8_, p_197741_4_, p_197741_6_, aabb.field_72334_f, aabb.field_72340_a, aabb.field_72336_d, aabb.field_72338_b, aabb.field_72337_e, Direction.SOUTH, p_197741_1_.field_72449_c, p_197741_1_.field_72450_a, p_197741_1_.field_72448_b);
        }
        return facing;
    }

    @Nullable
    private static Direction func_197740_a(double[] p_197740_0_, @Nullable Direction p_197740_1_, double p_197740_2_, double p_197740_4_, double p_197740_6_, double p_197740_8_, double p_197740_10_, double p_197740_12_, double p_197740_14_, double p_197740_16_, Direction p_197740_18_, double p_197740_19_, double p_197740_21_, double p_197740_23_) {
        double d0 = (p_197740_8_ - p_197740_19_) / p_197740_2_;
        double d1 = p_197740_21_ + d0 * p_197740_4_;
        double d2 = p_197740_23_ + d0 * p_197740_6_;
        if (0.0 < d0 && d0 < p_197740_0_[0] && p_197740_10_ - 1.0E-7 < d1 && d1 < p_197740_12_ + 1.0E-7 && p_197740_14_ - 1.0E-7 < d2 && d2 < p_197740_16_ + 1.0E-7) {
            p_197740_0_[0] = d0;
            return p_197740_18_;
        }
        return p_197740_1_;
    }
}

