/*
 * Decompiled with CFR 0.152.
 */
package net.spellcraftgaming.rpghud.main;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.spellcraftgaming.rpghud.gui.hud.HudHotbarWidget;
import net.spellcraftgaming.rpghud.gui.hud.element.HudElementType;
import net.spellcraftgaming.rpghud.main.ModRPGHud;

public class RenderOverlay {
    private ModRPGHud rpgHud = ModRPGHud.instance;
    private Minecraft mc = Minecraft.func_71410_x();

    public RenderOverlay() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onGameOverlayRender(RenderGameOverlayEvent event) {
        switch (event.getType()) {
            case AIR: {
                if (!this.forceRenderType(HudElementType.AIR)) {
                    this.drawElement(HudElementType.AIR, event.getPartialTicks());
                }
                if (this.forceRenderTypeVanilla(HudElementType.AIR)) break;
                event.setCanceled(true);
                break;
            }
            case ARMOR: {
                if (!this.forceRenderType(HudElementType.ARMOR)) {
                    this.drawElement(HudElementType.ARMOR, event.getPartialTicks());
                }
                if (this.forceRenderTypeVanilla(HudElementType.ARMOR)) break;
                event.setCanceled(true);
                break;
            }
            case EXPERIENCE: {
                if (!this.forceRenderType(HudElementType.EXPERIENCE)) {
                    this.drawElement(HudElementType.EXPERIENCE, event.getPartialTicks());
                }
                if (!this.forceRenderTypeVanilla(HudElementType.EXPERIENCE)) {
                    this.drawElement(HudElementType.LEVEL, event.getPartialTicks());
                }
                event.setCanceled(true);
                break;
            }
            case FOOD: {
                if (!this.forceRenderType(HudElementType.FOOD)) {
                    this.drawElement(HudElementType.FOOD, event.getPartialTicks());
                }
                if (this.forceRenderTypeVanilla(HudElementType.FOOD)) break;
                event.setCanceled(true);
                break;
            }
            case HEALTH: {
                if (!this.forceRenderType(HudElementType.HEALTH)) {
                    this.drawElement(HudElementType.HEALTH, event.getPartialTicks());
                }
                if (this.forceRenderTypeVanilla(HudElementType.HEALTH)) break;
                event.setCanceled(true);
                break;
            }
            case HEALTHMOUNT: {
                if (!this.forceRenderType(HudElementType.HEALTH_MOUNT)) {
                    this.drawElement(HudElementType.HEALTH_MOUNT, event.getPartialTicks());
                }
                if (this.forceRenderTypeVanilla(HudElementType.HEALTH_MOUNT)) break;
                event.setCanceled(true);
                break;
            }
            case HOTBAR: {
                if (!this.forceRenderType(HudElementType.HOTBAR)) {
                    this.drawElement(HudElementType.HOTBAR, event.getPartialTicks());
                }
                if (this.forceRenderTypeVanilla(HudElementType.HOTBAR)) break;
                event.setCanceled(true);
                break;
            }
            case JUMPBAR: {
                if (!this.forceRenderType(HudElementType.JUMP_BAR)) {
                    this.drawElement(HudElementType.JUMP_BAR, event.getPartialTicks());
                }
                if (this.forceRenderTypeVanilla(HudElementType.JUMP_BAR)) break;
                event.setCanceled(true);
                break;
            }
        }
    }

    @SubscribeEvent
    public void onGameOverlayRender(RenderGameOverlayEvent.Pre event) {
        switch (event.getType()) {
            case ALL: {
                this.renderOverlay(event.getPartialTicks());
                break;
            }
            case AIR: {
                if (!this.preventEventType(HudElementType.AIR)) break;
                event.setCanceled(true);
                break;
            }
            case ARMOR: {
                if (!this.preventEventType(HudElementType.ARMOR)) break;
                event.setCanceled(true);
                break;
            }
            case EXPERIENCE: {
                if (!this.preventEventType(HudElementType.EXPERIENCE)) break;
                event.setCanceled(true);
                break;
            }
            case FOOD: {
                if (!this.preventEventType(HudElementType.FOOD)) break;
                event.setCanceled(true);
                break;
            }
            case HEALTH: {
                if (!this.preventEventType(HudElementType.HEALTH)) break;
                event.setCanceled(true);
                break;
            }
            case HEALTHMOUNT: {
                if (!this.preventEventType(HudElementType.HEALTH_MOUNT)) break;
                event.setCanceled(true);
                break;
            }
            case HOTBAR: {
                if (!this.preventEventType(HudElementType.HOTBAR)) break;
                event.setCanceled(true);
                break;
            }
            case JUMPBAR: {
                if (!this.preventEventType(HudElementType.JUMP_BAR)) break;
                event.setCanceled(true);
                break;
            }
        }
    }

    @SubscribeEvent
    public void onChatRender(RenderGameOverlayEvent.Chat event) {
        if (ModRPGHud.instance.getActiveHud() instanceof HudHotbarWidget) {
            event.setPosY(event.getPosY() - 22);
        }
    }

    private void renderOverlay(float partialTicks) {
        this.drawElement(HudElementType.WIDGET, partialTicks);
        this.drawElement(HudElementType.CLOCK, partialTicks);
        this.drawElement(HudElementType.DETAILS, partialTicks);
        this.drawElement(HudElementType.COMPASS, partialTicks);
        this.drawElement(HudElementType.ENTITY_INSPECT, partialTicks);
        if (this.forceRenderType(HudElementType.HEALTH)) {
            this.drawElement(HudElementType.HEALTH, partialTicks);
        }
        if (this.forceRenderType(HudElementType.ARMOR)) {
            this.drawElement(HudElementType.ARMOR, partialTicks);
        }
        if (this.forceRenderType(HudElementType.FOOD)) {
            this.drawElement(HudElementType.FOOD, partialTicks);
        }
        if (this.forceRenderType(HudElementType.HEALTH_MOUNT)) {
            this.drawElement(HudElementType.HEALTH_MOUNT, partialTicks);
        }
        if (this.forceRenderType(HudElementType.AIR)) {
            this.drawElement(HudElementType.AIR, partialTicks);
        }
        if (this.forceRenderType(HudElementType.JUMP_BAR)) {
            this.drawElement(HudElementType.JUMP_BAR, partialTicks);
        }
        if (this.forceRenderType(HudElementType.EXPERIENCE)) {
            this.drawElement(HudElementType.EXPERIENCE, partialTicks);
        }
        if (this.forceRenderType(HudElementType.HOTBAR)) {
            this.drawElement(HudElementType.HOTBAR, partialTicks);
        }
        if (this.preventEventType(HudElementType.EXPERIENCE)) {
            this.drawElement(HudElementType.LEVEL, partialTicks);
        }
    }

    private void drawElement(HudElementType type, float partialTicks) {
        if (this.rpgHud.getActiveHud().checkElementConditions(type) && !this.forceRenderTypeVanilla(type) && !this.preventElementRenderType(type)) {
            this.bind(AbstractGui.GUI_ICONS_LOCATION);
            RenderSystem.enableBlend();
            this.rpgHud.getActiveHud().drawElement(type, (AbstractGui)this.mc.field_71456_v, partialTicks, partialTicks, this.mc.func_228018_at_().func_198107_o(), this.mc.func_228018_at_().func_198087_p());
            RenderSystem.disableBlend();
        }
    }

    private boolean preventElementRenderType(HudElementType type) {
        String id = "prevent_element_render_" + type.name().toLowerCase();
        if (this.rpgHud.settings.doesSettingExist(id)) {
            return this.rpgHud.settings.getBoolValue(id);
        }
        return false;
    }

    private boolean forceRenderTypeVanilla(HudElementType type) {
        String id = "render_vanilla_" + type.name().toLowerCase();
        if (this.rpgHud.settings.doesSettingExist(id)) {
            return this.rpgHud.settings.getBoolValue(id);
        }
        return false;
    }

    private boolean forceRenderType(HudElementType type) {
        String id = "force_render_" + type.name().toLowerCase();
        if (this.rpgHud.settings.doesSettingExist(id)) {
            return this.rpgHud.settings.getBoolValue(id);
        }
        return false;
    }

    private boolean preventEventType(HudElementType type) {
        String id = "prevent_event_" + type.name().toLowerCase();
        if (this.rpgHud.settings.doesSettingExist(id)) {
            return this.rpgHud.settings.getBoolValue(id);
        }
        return false;
    }

    private void bind(ResourceLocation res) {
        this.mc.func_110434_K().func_110577_a(res);
    }
}

