/*
 * Decompiled with CFR 0.152.
 */
package com.bioxx.tfc.ASM;

import com.bioxx.tfc.TFCASMLoadingPlugin;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.launchwrapper.IClassTransformer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LineNumberNode;
import org.objectweb.asm.tree.MethodNode;

public class ClassTransformer
implements IClassTransformer {
    public static final Logger LOG = LogManager.getLogger((String)"TerraFirmaCraft ASM");
    protected Map<String, Patch> mcpMethodNodes = new HashMap<String, Patch>();
    protected Map<String, Patch> obfMethodNodes = new HashMap<String, Patch>();
    protected String mcpClassName;
    protected String obfClassName;
    public static int numInsertions;

    public byte[] transform(String name, String transformedName, byte[] bytes) {
        if (name.equals(this.obfClassName)) {
            return this.transform(bytes);
        }
        if (name.equals(this.mcpClassName)) {
            return this.transform(bytes);
        }
        return bytes;
    }

    protected byte[] transform(byte[] bytes) {
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(bytes);
        classReader.accept((ClassVisitor)classNode, 0);
        LOG.info("Attempting to Transform: " + classNode.name + " | Found " + this.getMethodNodeList().size() + " injections");
        for (MethodNode m : classNode.methods) {
            int index;
            if (!this.getMethodNodeList().containsKey(m.name + " | " + m.desc)) continue;
            numInsertions = 0;
            Patch mPatch = this.getMethodNodeList().get(m.name + " | " + m.desc);
            List<InstrSet> instructions = mPatch.instructions;
            InstrSet target = null;
            if (!instructions.isEmpty()) {
                target = instructions.get(0);
            } else {
                LOG.error("Error in: {" + m.name + " | " + m.desc + "} No Instructions");
            }
            if (mPatch.opType == PatchOpType.Modify) {
                block1: for (index = 0; index < m.instructions.size() && !instructions.isEmpty(); ++index) {
                    numInsertions = 0;
                    while (target != null) {
                        if (target.startLine == -1) {
                            this.performDirectOperation(m.instructions, target);
                            instructions.remove(0);
                        } else {
                            if (!this.isLineNumber(m.instructions.get(index), target.startLine)) continue block1;
                            this.performAnchorOperation(m.instructions, target, index);
                            instructions.remove(0);
                        }
                        if (!instructions.isEmpty()) {
                            target = instructions.get(0);
                            continue;
                        }
                        target = null;
                    }
                }
            } else if (mPatch.opType == PatchOpType.Replace) {
                if (target != null && target.offset != -1) {
                    index = 0;
                    while (index < m.instructions.size()) {
                        if (index > target.offset) {
                            m.instructions.remove(m.instructions.get(index));
                            continue;
                        }
                        ++index;
                    }
                }
                for (index = 0; index < m.instructions.size() && !instructions.isEmpty(); ++index) {
                    numInsertions = 0;
                    while (target != null) {
                        if (target.startLine == -1) {
                            this.performDirectOperation(m.instructions, target);
                            instructions.remove(0);
                        } else {
                            if (!this.isLineNumber(m.instructions.get(index), target.startLine)) break;
                            this.performAnchorOperation(m.instructions, target, index);
                            instructions.remove(0);
                        }
                        if (!instructions.isEmpty()) {
                            target = instructions.get(0);
                            continue;
                        }
                        target = null;
                    }
                    m.instructions.add((AbstractInsnNode)new InsnNode(177));
                }
            }
            LOG.info("Inserted: " + classNode.name + " : {" + m.name + " | " + m.desc + "}");
        }
        LOG.info("Attempting to Transform: " + classNode.name + " Complete");
        ClassWriter writer = new ClassWriter(1);
        classNode.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    private int findLine(InsnList methodList, int line) {
        for (int index = 0; index < methodList.size(); ++index) {
            if (!this.isLineNumber(methodList.get(index), line)) continue;
            return index;
        }
        return -1;
    }

    private void performDirectOperation(InsnList methodInsn, InstrSet input) {
        AbstractInsnNode current = methodInsn.get(input.offset + numInsertions);
        switch (input.opType) {
            case InsertAfter: {
                numInsertions += input.iList.size();
                methodInsn.insert(current, input.iList);
                break;
            }
            case InsertBefore: {
                numInsertions += input.iList.size();
                methodInsn.insertBefore(current, input.iList);
                break;
            }
            case Remove: {
                --numInsertions;
                methodInsn.remove(current);
                break;
            }
            case Replace: {
                if (current instanceof JumpInsnNode && input.iList.get(0) instanceof JumpInsnNode) {
                    ((JumpInsnNode)input.iList.get((int)0)).label = ((JumpInsnNode)current).label;
                }
                methodInsn.insert(current, input.iList);
                methodInsn.remove(current);
                break;
            }
        }
    }

    private void performAnchorOperation(InsnList methodInsn, InstrSet input, int anchor) {
        AbstractInsnNode current = methodInsn.get(anchor + input.offset + numInsertions);
        if (input.iList.get(0) instanceof JumpInsnNode) {
            input.iList.set(input.iList.get(0), (AbstractInsnNode)new JumpInsnNode(input.iList.get(0).getOpcode(), (LabelNode)current.getPrevious()));
        }
        switch (input.opType) {
            case InsertAfter: {
                numInsertions += input.iList.size();
                methodInsn.insert(current, input.iList);
                break;
            }
            case InsertBefore: {
                numInsertions += input.iList.size();
                methodInsn.insertBefore(current, input.iList);
                break;
            }
            case Remove: {
                --numInsertions;
                methodInsn.remove(current);
                break;
            }
            case Replace: {
                methodInsn.insert(current, input.iList);
                methodInsn.remove(current);
                break;
            }
            case Switch: {
                int otherAnchor = this.findLine(methodInsn, input.offsetLine);
                AbstractInsnNode other = methodInsn.get(otherAnchor + input.offsetSwitch + numInsertions);
                methodInsn.remove(current);
                methodInsn.insert(other, current);
                current = methodInsn.get(anchor + input.offset + numInsertions);
                methodInsn.remove(other);
                methodInsn.insertBefore(current, other);
                break;
            }
        }
    }

    protected Map<String, Patch> getMethodNodeList() {
        if (TFCASMLoadingPlugin.runtimeDeobf) {
            return this.obfMethodNodes;
        }
        return this.mcpMethodNodes;
    }

    private boolean isLineNumber(AbstractInsnNode current, int line) {
        int l;
        return current instanceof LineNumberNode && (l = ((LineNumberNode)current).line) == line;
    }

    public class JumpNode
    extends JumpInsnNode {
        public int line;

        public JumpNode(int opcode, LabelNode label) {
            super(opcode, label);
        }

        public JumpNode(int opcode, int labelLine) {
            super(opcode, null);
            this.line = labelLine;
        }
    }

    public static enum InstrOpType {
        InsertAfter,
        InsertBefore,
        Switch,
        Replace,
        Remove;

    }

    public static enum PatchOpType {
        Modify,
        Replace;

    }

    public class Patch {
        public List<InstrSet> instructions;
        public PatchOpType opType = PatchOpType.Modify;

        public Patch(List<InstrSet> set) {
            this.instructions = set;
        }

        public Patch(List<InstrSet> set, PatchOpType op) {
            this.instructions = set;
            this.opType = op;
        }
    }

    public class InstrSet {
        public InsnList iList;
        public int offset;
        public int startLine = -1;
        public InstrOpType opType;
        public int offsetSwitch = -1;
        public int offsetLine = -1;

        public InstrSet(InsnList list, int off, InstrOpType op) {
            this.iList = list;
            this.offset = off;
            this.opType = op;
        }

        public InstrSet(AbstractInsnNode node, int off, InstrOpType op) {
            this.iList = new InsnList();
            this.iList.add(node);
            this.offset = off;
            this.opType = op;
        }

        public InstrSet(InsnList list, int startLineNum, int off, InstrOpType op) {
            this.iList = list;
            this.startLine = startLineNum;
            this.offset = off;
            this.opType = op;
        }

        public InstrSet(AbstractInsnNode node, int startLineNum, int off, InstrOpType op) {
            this.iList = new InsnList();
            this.iList.add(node);
            this.startLine = startLineNum;
            this.offset = off;
            this.opType = op;
        }

        public InstrSet(int startLineNum, int off, int swLineNum, int swOffset) {
            this.startLine = startLineNum;
            this.offset = off;
            this.opType = InstrOpType.Switch;
            this.offsetSwitch = swOffset;
            this.offsetLine = swLineNum;
        }
    }
}

