/*
 * Decompiled with CFR 0.152.
 */
package com.bioxx.tfc.Blocks;

import com.bioxx.tfc.Blocks.BlockPartial;
import com.bioxx.tfc.Core.CollisionRayTraceDetailed;
import com.bioxx.tfc.Core.Player.PlayerInfo;
import com.bioxx.tfc.Core.Player.PlayerManagerTFC;
import com.bioxx.tfc.Items.Tools.ItemChisel;
import com.bioxx.tfc.Items.Tools.ItemHammer;
import com.bioxx.tfc.TileEntities.TEDetailed;
import com.bioxx.tfc.TileEntities.TEWoodConstruct;
import com.bioxx.tfc.api.TFCBlocks;
import com.bioxx.tfc.api.TFCOptions;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.particle.EffectRenderer;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockDetailed
extends BlockPartial {
    public static int lockX;
    public static int lockY;
    public static int lockZ;
    public int xSelected = -10;
    public int ySelected = -10;
    public int zSelected = -10;
    public int side = -1;

    public BlockDetailed() {
        super(Material.field_151576_e);
    }

    public int func_149645_b() {
        return TFCBlocks.detailedRenderId;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean addDestroyEffects(World world, int x, int y, int z, int meta, EffectRenderer effectRenderer) {
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean addHitEffects(World worldObj, MovingObjectPosition target, EffectRenderer effectRenderer) {
        return true;
    }

    public boolean func_149655_b(IBlockAccess bAccess, int i, int j, int k) {
        return true;
    }

    public void func_149651_a(IIconRegister iconRegisterer) {
    }

    public IIcon func_149673_e(IBlockAccess bAccess, int x, int y, int z, int side) {
        TEDetailed te = (TEDetailed)bAccess.func_147438_o(x, y, z);
        return te.func_145838_q().func_149691_a(side, (int)te.metaID);
    }

    @Override
    public TileEntity func_149915_a(World var1, int var2) {
        return new TEDetailed();
    }

    @Override
    public boolean func_149662_c() {
        return false;
    }

    public boolean isSideSolid(IBlockAccess world, int x, int y, int z, ForgeDirection side) {
        if (!TFCOptions.enableSolidDetailed) {
            return false;
        }
        if (side == ForgeDirection.UNKNOWN) {
            return false;
        }
        int transpCount = TFCOptions.maxRemovedSolidDetailed;
        if (transpCount < 0 || transpCount >= 64) {
            return false;
        }
        TEDetailed te = (TEDetailed)world.func_147438_o(x, y, z);
        int startX = side == ForgeDirection.EAST ? 7 : 0;
        int endX = side == ForgeDirection.WEST ? 1 : 8;
        int startY = side == ForgeDirection.UP ? 7 : 0;
        int endY = side == ForgeDirection.DOWN ? 1 : 8;
        int startZ = side == ForgeDirection.SOUTH ? 7 : 0;
        int endZ = side == ForgeDirection.NORTH ? 1 : 8;
        for (int subX = startX; subX < endX; ++subX) {
            for (int subY = startY; subY < endY; ++subY) {
                for (int subZ = startZ; subZ < endZ; ++subZ) {
                    if (te.getBlockExists(subX, subY, subZ) || --transpCount >= 0) continue;
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public boolean func_149686_d() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_149646_a(IBlockAccess bAccess, int x, int y, int z, int side) {
        return true;
    }

    @Override
    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer entityplayer, int side, float hitX, float hitY, float hitZ) {
        boolean hasHammer = false;
        PlayerInfo pi = PlayerManagerTFC.getInstance().getPlayerInfoFromPlayer(entityplayer);
        for (int i = 0; i < 9; ++i) {
            if (entityplayer.field_71071_by.field_70462_a[i] == null || !(entityplayer.field_71071_by.field_70462_a[i].func_77973_b() instanceof ItemHammer)) continue;
            hasHammer = true;
        }
        if (entityplayer.func_71045_bC() != null && entityplayer.func_71045_bC().func_77973_b() instanceof ItemChisel && hasHammer && world.field_72995_K && pi.lockMatches(x, y, z)) {
            TEDetailed te = (TEDetailed)world.func_147438_o(x, y, z);
            lockX = x;
            lockY = y;
            lockZ = z;
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74774_a("packetType", (byte)1);
            nbt.func_74768_a("xSelected", this.xSelected);
            nbt.func_74768_a("ySelected", this.ySelected);
            nbt.func_74768_a("zSelected", this.zSelected);
            te.createDataNBT(nbt);
            te.broadcastPacketInRange(te.createDataPacket(nbt));
        }
        return false;
    }

    public boolean onBlockActivatedServer(World world, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        int index;
        byte mode = 0;
        PlayerInfo pi = PlayerManagerTFC.getInstance().getPlayerInfoFromPlayer(player);
        if (pi != null) {
            mode = pi.chiselMode;
        }
        TEDetailed te = (TEDetailed)world.func_147438_o(x, y, z);
        int hasChisel = -1;
        int hasHammer = -1;
        for (int i = 0; i < 9; ++i) {
            if (player.field_71071_by.field_70462_a[i] != null && player.field_71071_by.field_70462_a[i].func_77973_b() instanceof ItemHammer) {
                hasHammer = i;
            }
            if (player.field_71071_by.field_70462_a[i] == null || !(player.field_71071_by.field_70462_a[i].func_77973_b() instanceof ItemChisel)) continue;
            hasChisel = i;
        }
        if (mode == 1) {
            int subY;
            int subZ;
            int subX;
            index = -10;
            if (this.xSelected < 4 && this.ySelected < 4 && this.zSelected < 4) {
                for (subX = 0; subX < 4; ++subX) {
                    for (subZ = 0; subZ < 4; ++subZ) {
                        for (subY = 0; subY < 4; ++subY) {
                            index = (subX * 8 + subZ) * 8 + subY;
                            this.deleteBox(world, x, y, z, player, te, index, hasChisel, hasHammer);
                        }
                    }
                }
            }
            if (this.xSelected > 3 && this.ySelected < 4 && this.zSelected < 4) {
                for (subX = 4; subX < 8; ++subX) {
                    for (subZ = 0; subZ < 4; ++subZ) {
                        for (subY = 0; subY < 4; ++subY) {
                            index = (subX * 8 + subZ) * 8 + subY;
                            this.deleteBox(world, x, y, z, player, te, index, hasChisel, hasHammer);
                        }
                    }
                }
            }
            if (this.xSelected > 3 && this.ySelected < 4 && this.zSelected > 3) {
                for (subX = 4; subX < 8; ++subX) {
                    for (subZ = 4; subZ < 8; ++subZ) {
                        for (subY = 0; subY < 4; ++subY) {
                            index = (subX * 8 + subZ) * 8 + subY;
                            this.deleteBox(world, x, y, z, player, te, index, hasChisel, hasHammer);
                        }
                    }
                }
            }
            if (this.xSelected < 4 && this.ySelected < 4 && this.zSelected > 3) {
                for (subX = 0; subX < 4; ++subX) {
                    for (subZ = 4; subZ < 8; ++subZ) {
                        for (subY = 0; subY < 4; ++subY) {
                            index = (subX * 8 + subZ) * 8 + subY;
                            this.deleteBox(world, x, y, z, player, te, index, hasChisel, hasHammer);
                        }
                    }
                }
            }
            if (this.xSelected < 4 && this.ySelected > 3 && this.zSelected < 4) {
                for (subX = 0; subX < 4; ++subX) {
                    for (subZ = 0; subZ < 4; ++subZ) {
                        for (subY = 4; subY < 8; ++subY) {
                            index = (subX * 8 + subZ) * 8 + subY;
                            this.deleteBox(world, x, y, z, player, te, index, hasChisel, hasHammer);
                        }
                    }
                }
            }
            if (this.xSelected > 3 && this.ySelected > 3 && this.zSelected < 4) {
                for (subX = 4; subX < 8; ++subX) {
                    for (subZ = 0; subZ < 4; ++subZ) {
                        for (subY = 4; subY < 8; ++subY) {
                            index = (subX * 8 + subZ) * 8 + subY;
                            this.deleteBox(world, x, y, z, player, te, index, hasChisel, hasHammer);
                        }
                    }
                }
            }
            if (this.xSelected > 3 && this.ySelected > 3 && this.zSelected > 3) {
                for (subX = 4; subX < 8; ++subX) {
                    for (subZ = 4; subZ < 8; ++subZ) {
                        for (subY = 4; subY < 8; ++subY) {
                            index = (subX * 8 + subZ) * 8 + subY;
                            this.deleteBox(world, x, y, z, player, te, index, hasChisel, hasHammer);
                        }
                    }
                }
            }
            if (this.xSelected < 4 && this.ySelected > 3 && this.zSelected > 3) {
                for (subX = 0; subX < 4; ++subX) {
                    for (subZ = 4; subZ < 8; ++subZ) {
                        for (subY = 4; subY < 8; ++subY) {
                            index = (subX * 8 + subZ) * 8 + subY;
                            this.deleteBox(world, x, y, z, player, te, index, hasChisel, hasHammer);
                        }
                    }
                }
            }
            return true;
        }
        if (mode == 3 && this.xSelected != -10) {
            index = (this.xSelected * 8 + this.zSelected) * 8 + this.ySelected;
            if (index >= 0) {
                this.deleteBox(world, x, y, z, player, te, index, hasChisel, hasHammer);
            }
            return true;
        }
        return false;
    }

    public void deleteBox(World world, int x, int y, int z, EntityPlayer player, TEDetailed te, int index, int hasChisel, int hasHammer) {
        te.data.clear(index);
        te.clearQuad(this.xSelected, this.ySelected, this.zSelected);
        if (te.isBlockEmpty()) {
            world.func_147468_f(x, y, z);
        }
        if (player.field_71071_by.field_70462_a[hasChisel] != null) {
            player.field_71071_by.field_70462_a[hasChisel].func_77972_a(1, (EntityLivingBase)player);
        }
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74774_a("packetType", (byte)0);
        nbt.func_74768_a("index", index);
        te.createDataNBT(nbt);
        te.broadcastPacketInRange(te.createDataPacket(nbt));
    }

    public void func_149743_a(World world, int i, int j, int k, AxisAlignedBB aabb, List list, Entity entity) {
        TEDetailed te = (TEDetailed)world.func_147438_o(i, j, k);
        float div = 0.125f;
        for (int subX = 0; subX < 8; ++subX) {
            for (int subZ = 0; subZ < 8; ++subZ) {
                for (int subY = 0; subY < 8; ++subY) {
                    if (!te.data.get((subX * 8 + subZ) * 8 + subY)) continue;
                    float minX = (float)subX * div;
                    float maxX = minX + div;
                    float minY = (float)subY * div;
                    float maxY = minY + div;
                    float minZ = (float)subZ * div;
                    float maxZ = minZ + div;
                    this.func_149676_a(minX, minY, minZ, maxX, maxY, maxZ);
                    super.func_149743_a(world, i, j, k, aabb, list, entity);
                }
            }
        }
        this.setBlockBoundsBasedOnSelection((IBlockAccess)world, i, j, k);
    }

    public MovingObjectPosition func_149731_a(World world, int x, int y, int z, Vec3 player, Vec3 view) {
        TEDetailed te = (TEDetailed)world.func_147438_o(x, y, z);
        player = player.func_72441_c((double)(-x), (double)(-y), (double)(-z));
        view = view.func_72441_c((double)(-x), (double)(-y), (double)(-z));
        if (te == null) {
            return null;
        }
        List<Object[]> returns = new ArrayList<Object[]>();
        if (!(returns = CollisionRayTraceDetailed.rayTraceSubBlocks(this, player, view, x, y, z, returns, te.data, te)).isEmpty()) {
            Object[] min = null;
            double distMin = 0.0;
            for (Object[] ret : returns) {
                double dist = (Double)ret[2];
                if (min != null && !(dist < distMin)) continue;
                distMin = dist;
                min = ret;
            }
            if (min != null) {
                this.side = ((Byte)min[1]).byteValue();
                this.xSelected = (Integer)min[3];
                this.ySelected = (Integer)min[4];
                this.zSelected = (Integer)min[5];
                int index = (this.xSelected * 8 + this.zSelected) * 8 + this.ySelected;
                if (index >= 0 && te.data.get(index)) {
                    int d = TEWoodConstruct.plankDetailLevel;
                    float div = 1.0f / (float)d;
                    float minX = (float)x + (float)this.xSelected * div;
                    float maxX = minX + div;
                    float minY = (float)y + (float)this.ySelected * div;
                    float maxY = minY + div;
                    float minZ = (float)z + (float)this.zSelected * div;
                    float maxZ = minZ + div;
                    this.func_149676_a(minX, minY, minZ, maxX, maxY, maxZ);
                    this.rayTraceBound(AxisAlignedBB.func_72330_a((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ), x, y, z, player, view);
                }
                this.setBlockBoundsBasedOnSelection((IBlockAccess)world, x, y, z);
                lockX = x;
                lockY = y;
                lockZ = z;
                return new MovingObjectPosition(x, y, z, (int)((Byte)min[1]).byteValue(), ((Vec3)min[0]).func_72441_c((double)x, (double)y, (double)z));
            }
        }
        this.xSelected = -10;
        this.ySelected = -10;
        this.zSelected = -10;
        this.side = -1;
        this.setBlockBoundsBasedOnSelection((IBlockAccess)world, x, y, z);
        return null;
    }

    public void setBlockBoundsBasedOnSelection(IBlockAccess access, int x, int y, int z) {
        if (this.xSelected == -10) {
            this.func_149676_a(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
        } else {
            TEDetailed te = (TEDetailed)access.func_147438_o(x, y, z);
            int index = (this.xSelected * 8 + this.zSelected) * 8 + this.ySelected;
            if (index >= 0 && te.data.get(index)) {
                int d = 8;
                float div = 1.0f / (float)d;
                float minX = (float)this.xSelected * div;
                float maxX = minX + div;
                float minY = (float)this.ySelected * div;
                float maxY = minY + div;
                float minZ = (float)this.zSelected * div;
                float maxZ = minZ + div;
                AxisAlignedBB bound = AxisAlignedBB.func_72330_a((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ);
                this.func_149676_a((float)bound.field_72340_a, (float)bound.field_72338_b, (float)bound.field_72339_c, (float)bound.field_72336_d, (float)bound.field_72337_e, (float)bound.field_72334_f);
            }
        }
    }

    public Object[] rayTraceBound(AxisAlignedBB bound, int i, int j, int k, Vec3 player, Vec3 view) {
        Vec3 minX = player.func_72429_b(view, bound.field_72340_a);
        Vec3 maxX = player.func_72429_b(view, bound.field_72336_d);
        Vec3 minY = player.func_72435_c(view, bound.field_72338_b);
        Vec3 maxY = player.func_72435_c(view, bound.field_72337_e);
        Vec3 minZ = player.func_72434_d(view, bound.field_72339_c);
        Vec3 maxZ = player.func_72434_d(view, bound.field_72334_f);
        if (!this.isVecInsideYZBounds(bound, minX)) {
            minX = null;
        }
        if (!this.isVecInsideYZBounds(bound, maxX)) {
            maxX = null;
        }
        if (!this.isVecInsideXZBounds(bound, minY)) {
            minY = null;
        }
        if (!this.isVecInsideXZBounds(bound, maxY)) {
            maxY = null;
        }
        if (!this.isVecInsideXYBounds(bound, minZ)) {
            minZ = null;
        }
        if (!this.isVecInsideXYBounds(bound, maxZ)) {
            maxZ = null;
        }
        Vec3 tracedBound = null;
        if (minX != null && (tracedBound == null || player.func_72438_d(minX) < player.func_72438_d(tracedBound))) {
            tracedBound = minX;
        }
        if (maxX != null && (tracedBound == null || player.func_72438_d(maxX) < player.func_72438_d(tracedBound))) {
            tracedBound = maxX;
        }
        if (minY != null && (tracedBound == null || player.func_72438_d(minY) < player.func_72438_d(tracedBound))) {
            tracedBound = minY;
        }
        if (maxY != null && (tracedBound == null || player.func_72438_d(maxY) < player.func_72438_d(tracedBound))) {
            tracedBound = maxY;
        }
        if (minZ != null && (tracedBound == null || player.func_72438_d(minZ) < player.func_72438_d(tracedBound))) {
            tracedBound = minZ;
        }
        if (maxZ != null && (tracedBound == null || player.func_72438_d(maxZ) < player.func_72438_d(tracedBound))) {
            tracedBound = maxZ;
        }
        if (tracedBound == null) {
            return null;
        }
        byte side = -1;
        if (tracedBound == minX) {
            side = 4;
        }
        if (tracedBound == maxX) {
            side = 5;
        }
        if (tracedBound == minY) {
            side = 0;
        }
        if (tracedBound == maxY) {
            side = 1;
        }
        if (tracedBound == minZ) {
            side = 2;
        }
        if (tracedBound == maxZ) {
            side = 3;
        }
        return new Object[]{tracedBound, side, player.func_72438_d(tracedBound)};
    }

    private boolean isVecInsideYZBounds(AxisAlignedBB bound, Vec3 vec3) {
        if (vec3 == null) {
            return false;
        }
        return vec3.field_72448_b >= bound.field_72338_b && vec3.field_72448_b <= bound.field_72337_e && vec3.field_72449_c >= bound.field_72339_c && vec3.field_72449_c <= bound.field_72334_f;
    }

    private boolean isVecInsideXZBounds(AxisAlignedBB bound, Vec3 vec3) {
        if (vec3 == null) {
            return false;
        }
        return vec3.field_72450_a >= bound.field_72340_a && vec3.field_72450_a <= bound.field_72336_d && vec3.field_72449_c >= bound.field_72339_c && vec3.field_72449_c <= bound.field_72334_f;
    }

    private boolean isVecInsideXYBounds(AxisAlignedBB bound, Vec3 vec3) {
        if (vec3 == null) {
            return false;
        }
        return vec3.field_72450_a >= bound.field_72340_a && vec3.field_72450_a <= bound.field_72336_d && vec3.field_72448_b >= bound.field_72338_b && vec3.field_72448_b <= bound.field_72337_e;
    }

    @Override
    public int getFlammability(IBlockAccess world, int x, int y, int z, ForgeDirection face) {
        TEDetailed te = (TEDetailed)world.func_147438_o(x, y, z);
        if (te.typeID >= 0) {
            return Blocks.field_150480_ab.getFlammability(Block.func_149729_e((int)te.typeID));
        }
        return 0;
    }

    @Override
    public int getFireSpreadSpeed(IBlockAccess world, int x, int y, int z, ForgeDirection face) {
        TEDetailed te = (TEDetailed)world.func_147438_o(x, y, z);
        if (te.typeID >= 0) {
            return Blocks.field_150480_ab.getEncouragement(Block.func_149729_e((int)te.typeID));
        }
        return 0;
    }

    public Item func_149650_a(int metadata, Random rand, int fortune) {
        return null;
    }
}

