/*
 * Decompiled with CFR 0.152.
 */
package com.bioxx.tfc.Blocks.Devices;

import com.bioxx.tfc.Blocks.BlockTerraContainer;
import com.bioxx.tfc.Core.TFCTabs;
import com.bioxx.tfc.TerraFirmaCraft;
import com.bioxx.tfc.TileEntities.TEChest;
import com.bioxx.tfc.api.Constant.Global;
import com.bioxx.tfc.api.TFCBlocks;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryLargeChest;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockChestTFC
extends BlockTerraContainer {
    private String[] woodNames;

    public BlockChestTFC() {
        super(Material.field_151575_d);
        this.func_149647_a(TFCTabs.TFC_DECORATION);
        this.func_149676_a(0.0625f, 0.0f, 0.0625f, 0.9375f, 0.875f, 0.9375f);
        this.woodNames = Global.WOOD_ALL;
    }

    @Override
    public TileEntity func_149915_a(World world, int var2) {
        return new TEChest();
    }

    public int func_149643_k(World world, int x, int y, int z) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof TEChest) {
            return ((TEChest)te).type;
        }
        return 0;
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        return new ArrayList<ItemStack>();
    }

    public Item func_149650_a(int metadata, Random rand, int fortune) {
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item par1, CreativeTabs par2CreativeTabs, List par3List) {
        for (int i = 0; i < this.woodNames.length; ++i) {
            par3List.add(new ItemStack((Block)this, 1, i));
        }
    }

    public void func_149725_f(World world, int i, int j, int k, int meta) {
        if (!world.field_72995_K && world.func_82736_K().func_82766_b("doTileDrops")) {
            int damageValue = this.func_149643_k(world, i, j, k);
            EntityItem ei = new EntityItem(world, (double)i, (double)j, (double)k, new ItemStack(TFCBlocks.chest, 1, damageValue));
            world.func_72838_d((Entity)ei);
        }
    }

    @Override
    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int par6, float par7, float par8, float par9) {
        if (world.field_72995_K) {
            return true;
        }
        IInventory iinventory = this.getInventory(world, x, y, z);
        if (iinventory != null) {
            player.openGui((Object)TerraFirmaCraft.instance, 29, world, x, y, z);
        }
        return true;
    }

    @Override
    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase player, ItemStack itemStack) {
        ForgeDirection adjDirection;
        int chestSide = 0;
        int facingDir = MathHelper.func_76128_c((double)((double)(player.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        int secFacingDir = MathHelper.func_76128_c((double)(player.field_70177_z * 4.0f / 360.0f)) & 3;
        boolean facingN = false;
        boolean facingE = true;
        int facingS = 2;
        int facingW = 3;
        int sideN = 2;
        int sideS = 3;
        int sideE = 5;
        int sideW = 4;
        if (facingDir == 0) {
            chestSide = 2;
        }
        if (facingDir == 1) {
            chestSide = 5;
        }
        if (facingDir == 2) {
            chestSide = 3;
        }
        if (facingDir == 3) {
            chestSide = 4;
        }
        if ((adjDirection = this.getAdjacentChestDirection((IBlockAccess)world, x, y, z, itemStack.func_77960_j())) == ForgeDirection.UNKNOWN) {
            world.func_72921_c(x, y, z, chestSide, 3);
        } else {
            switch (adjDirection) {
                case NORTH: 
                case SOUTH: {
                    if (chestSide != 2 && chestSide != 3) break;
                    if (secFacingDir == 1 || secFacingDir == 0) {
                        chestSide = 5;
                    }
                    if (secFacingDir != 3 && secFacingDir != 2) break;
                    chestSide = 4;
                    break;
                }
                default: {
                    if (chestSide != 5 && chestSide != 4) break;
                    chestSide = 2;
                    if (secFacingDir == 0 || secFacingDir == 3) {
                        chestSide = 2;
                    }
                    if (secFacingDir != 2 && secFacingDir != 1) break;
                    chestSide = 3;
                }
            }
            world.func_72921_c(x, y, z, chestSide, 3);
            world.func_72921_c(x + adjDirection.offsetX, y, z + adjDirection.offsetZ, chestSide, 3);
        }
        if (itemStack.func_82837_s()) {
            ((TEChest)world.func_147438_o(x, y, z)).func_145976_a(itemStack.func_82833_r());
        }
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public int func_149645_b() {
        return TFCBlocks.chestRenderId;
    }

    public void func_149719_a(IBlockAccess access, int x, int y, int z) {
        TEChest chest = (TEChest)access.func_147438_o(x, y, z);
        if (chest != null) {
            ForgeDirection adjDirection = this.getAdjacentChestDirection(access, x, y, z, chest.type);
            switch (adjDirection) {
                case NORTH: {
                    this.func_149676_a(0.0625f, 0.0f, 0.0f, 0.9375f, 0.875f, 0.9375f);
                    break;
                }
                case SOUTH: {
                    this.func_149676_a(0.0625f, 0.0f, 0.0625f, 0.9375f, 0.875f, 1.0f);
                    break;
                }
                case EAST: {
                    this.func_149676_a(0.0625f, 0.0f, 0.0625f, 1.0f, 0.875f, 0.9375f);
                    break;
                }
                case WEST: {
                    this.func_149676_a(0.0f, 0.0f, 0.0625f, 0.9375f, 0.875f, 0.9375f);
                    break;
                }
                default: {
                    this.func_149676_a(0.0625f, 0.0f, 0.0625f, 0.9375f, 0.875f, 0.9375f);
                }
            }
        }
    }

    public void func_149726_b(World world, int x, int y, int z) {
        super.func_149726_b(world, x, y, z);
    }

    public void unifyAdjacentChests(World world, int x, int y, int z) {
    }

    private boolean isChestOfType(IBlockAccess world, int x, int y, int z, int type) {
        if (world.func_147439_a(x, y, z) == this) {
            TEChest chest = (TEChest)world.func_147438_o(x, y, z);
            return chest.type == type;
        }
        return false;
    }

    private ForgeDirection getAdjacentChestDirection(IBlockAccess world, int x, int y, int z, int type) {
        ForgeDirection[] dirs;
        for (ForgeDirection dir : dirs = new ForgeDirection[]{ForgeDirection.NORTH, ForgeDirection.SOUTH, ForgeDirection.EAST, ForgeDirection.WEST}) {
            if (!this.isChestOfType(world, x + dir.offsetX, y, z + dir.offsetZ, type)) continue;
            return dir;
        }
        return ForgeDirection.UNKNOWN;
    }

    public boolean func_149705_a(World world, int x, int y, int z, int side, ItemStack itemStack) {
        ForgeDirection[] dirs;
        int type = itemStack.func_77960_j();
        ForgeDirection adjDirection = ForgeDirection.UNKNOWN;
        for (ForgeDirection dir : dirs = new ForgeDirection[]{ForgeDirection.NORTH, ForgeDirection.SOUTH, ForgeDirection.EAST, ForgeDirection.WEST}) {
            if (!this.isChestOfType((IBlockAccess)world, x + dir.offsetX, y, z + dir.offsetZ, type)) continue;
            if (adjDirection != ForgeDirection.UNKNOWN) {
                return false;
            }
            adjDirection = dir;
        }
        if (adjDirection == ForgeDirection.UNKNOWN) {
            return true;
        }
        ForgeDirection doubleDirection = this.getAdjacentChestDirection((IBlockAccess)world, x + adjDirection.offsetX, y, z + adjDirection.offsetZ, type);
        return doubleDirection == ForgeDirection.UNKNOWN;
    }

    public IInventory getInventory(World world, int x, int y, int z) {
        TEChest inv2;
        TEChest inv1;
        TEChest chest = (TEChest)world.func_147438_o(x, y, z);
        if (chest == null) {
            return null;
        }
        if (world.isSideSolid(x, y + 1, z, ForgeDirection.DOWN)) {
            return null;
        }
        ForgeDirection adjDirection = this.getAdjacentChestDirection((IBlockAccess)world, x, y, z, chest.type);
        if (adjDirection == ForgeDirection.UNKNOWN) {
            return chest;
        }
        TEChest adjChest = (TEChest)world.func_147438_o(x + adjDirection.offsetX, y, z + adjDirection.offsetZ);
        switch (adjDirection) {
            case NORTH: {
                inv1 = chest;
                inv2 = adjChest;
                break;
            }
            case SOUTH: {
                inv2 = chest;
                inv1 = adjChest;
                break;
            }
            case EAST: {
                inv2 = chest;
                inv1 = adjChest;
                break;
            }
            default: {
                inv1 = chest;
                inv2 = adjChest;
            }
        }
        return new InventoryLargeChest("container.chestDouble", (IInventory)inv1, (IInventory)inv2);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister register) {
        this.field_149761_L = register.func_94245_a("planks_oak");
    }
}

