/*
 * Decompiled with CFR 0.152.
 */
package com.bioxx.tfc.Blocks.Flora;

import com.bioxx.tfc.Blocks.BlockTerra;
import com.bioxx.tfc.Core.TFCTabs;
import com.bioxx.tfc.Core.TFC_Climate;
import com.bioxx.tfc.Core.TFC_Core;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;

public class BlockFlower
extends BlockTerra {
    public String[] flowerNames;
    @SideOnly(value=Side.CLIENT)
    protected IIcon[] icons;

    public BlockFlower() {
        super(Material.field_151585_k);
        this.func_149675_a(true);
        float var4 = 0.2f;
        this.func_149676_a(0.5f - var4, 0.0f, 0.5f - var4, 0.5f + var4, var4 * 3.0f, 0.5f + var4);
        this.func_149647_a(TFCTabs.TFC_DECORATION);
        this.flowerNames = new String[]{"flower_dandelion", "flower_nasturtium", "flower_meads_milkweed", "flower_tropical_milkweed", "flower_butterfly_milkweed", "flower_calendula"};
    }

    public boolean canGrowConditions(World world, int x, int y, int z, int flowerMeta) {
        float evt = TFC_Climate.getCacheManager((World)world).getEVTLayerAt((int)x, (int)z).floatdata1;
        float rain = TFC_Climate.getRainfall(world, x, 144, z);
        float bioTemperature = TFC_Climate.getBioTemperatureHeight(world, x, y, z);
        if (flowerMeta == 3 && bioTemperature > 20.0f && rain > 500.0f && evt < 2.0f) {
            return true;
        }
        return bioTemperature > 5.0f && rain > 250.0f;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item item, CreativeTabs tabs, List list) {
        Boolean addToCreative = true;
        if (addToCreative.booleanValue()) {
            for (int i = 0; i < this.flowerNames.length; ++i) {
                list.add(new ItemStack(item, 1, i));
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        if (meta >= this.icons.length) {
            meta = 0;
        }
        return this.icons[meta];
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister register) {
        this.icons = new IIcon[this.flowerNames.length];
        for (int i = 0; i < this.icons.length; ++i) {
            this.icons[i] = register.func_94245_a("terrafirmacraft:plants/" + this.flowerNames[i]);
        }
    }

    public int func_149692_a(int dmg) {
        return dmg;
    }

    public boolean func_149718_j(World world, int x, int y, int z) {
        return (world.func_72883_k(x, y, z) >= 8 || world.func_72937_j(x, y, z)) && this.canThisPlantGrowOnThisBlock(world.func_147439_a(x, y - 1, z));
    }

    public boolean func_149742_c(World world, int x, int y, int z) {
        Block block = world.func_147439_a(x, y, z);
        return (world.func_147437_c(x, y, z) || block.func_149688_o().func_76222_j()) && this.canThisPlantGrowOnThisBlock(block);
    }

    protected boolean canThisPlantGrowOnThisBlock(Block block) {
        return TFC_Core.isSoil(block) || TFC_Core.isFarmland(block);
    }

    public AxisAlignedBB func_149668_a(World world, int x, int y, int z) {
        return null;
    }

    public int func_149645_b() {
        return 1;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public void func_149674_a(World world, int x, int y, int z, Random rand) {
        this.checkAndDropBlock(world, x, y, z);
    }

    public void func_149695_a(World world, int x, int y, int z, Block block) {
        this.checkAndDropBlock(world, x, y, z);
    }

    protected void checkAndDropBlock(World world, int x, int y, int z) {
        if (!this.func_149718_j(world, x, y, z)) {
            this.func_149697_b(world, x, y, z, world.func_72805_g(x, y, z), 0);
            world.func_147465_d(x, y, z, BlockFlower.func_149729_e((int)0), 0, 2);
        }
    }
}

