/*
 * Decompiled with CFR 0.152.
 */
package com.bioxx.tfc.Blocks.Terrain;

import com.bioxx.tfc.Blocks.BlockTerraContainer;
import com.bioxx.tfc.Blocks.Terrain.BlockCobble;
import com.bioxx.tfc.Blocks.Terrain.BlockOre;
import com.bioxx.tfc.Blocks.Terrain.BlockSand;
import com.bioxx.tfc.Blocks.Terrain.BlockStone;
import com.bioxx.tfc.Core.TFCTabs;
import com.bioxx.tfc.Core.TFC_Core;
import com.bioxx.tfc.Entities.EntityFallingBlockTFC;
import com.bioxx.tfc.TileEntities.TEPartial;
import com.bioxx.tfc.api.Enums.TFCDirection;
import com.bioxx.tfc.api.TFCBlocks;
import com.bioxx.tfc.api.TFCOptions;
import com.bioxx.tfc.api.Util.ByteCoord;
import com.bioxx.tfc.api.Util.CollapseData;
import com.bioxx.tfc.api.Util.CollapseList;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockCollapsible
extends BlockTerraContainer {
    public Block dropBlock;
    public static boolean fallInstantly;

    protected BlockCollapsible(Material material, Block block) {
        super(material);
        this.dropBlock = block;
        this.func_149647_a(TFCTabs.TFC_BUILDING);
    }

    protected BlockCollapsible(Material material) {
        super(material);
        this.dropBlock = Blocks.field_150350_a;
        this.func_149647_a(TFCTabs.TFC_BUILDING);
    }

    public int[] getDropBlock(World world, int x, int y, int z) {
        int[] data = new int[]{Block.func_149682_b((Block)this.dropBlock), world.func_72805_g(x, y, z)};
        return data;
    }

    public static boolean canFallBelow(World world, int x, int y, int z) {
        if (world.func_147437_c(x, y, z)) {
            return true;
        }
        Block block = world.func_147439_a(x, y, z);
        if (block == Blocks.field_150480_ab) {
            return true;
        }
        if (block == TFCBlocks.tallGrass) {
            return true;
        }
        if (block == TFCBlocks.torch) {
            return true;
        }
        if (block == TFCBlocks.smokeRack) {
            return true;
        }
        if (block == TFCBlocks.toolRack) {
            return true;
        }
        if (block == Blocks.field_150357_h) {
            return false;
        }
        if (block == TFCBlocks.charcoal) {
            return false;
        }
        if (block == TFCBlocks.molten) {
            return false;
        }
        if (!(block.func_149662_c() || block.func_149686_d() || world.isSideSolid(x, y, z, ForgeDirection.UP))) {
            return true;
        }
        Material material = block.func_149688_o();
        return material == Material.field_151586_h || material == Material.field_151587_i;
    }

    public void dropCarvedStone(World world, int x, int y, int z) {
        if (world.func_147439_a(x + 1, y, z).func_149662_c()) {
            return;
        }
        if (world.func_147439_a(x - 1, y, z).func_149662_c()) {
            return;
        }
        if (world.func_147439_a(x, y, z + 1).func_149662_c()) {
            return;
        }
        if (world.func_147439_a(x, y, z - 1).func_149662_c()) {
            return;
        }
        if (world.func_147439_a(x, y + 1, z).func_149662_c()) {
            return;
        }
        if (world.func_147439_a(x, y - 1, z).func_149662_c()) {
            return;
        }
        this.func_149642_a(world, x, y, z, new ItemStack((Block)this, 1, world.func_72805_g(x, y, z)));
        world.func_147468_f(x, y, z);
    }

    public static Boolean isNearSupport(World world, int i, int j, int k, int range, float collapseChance) {
        for (int y = -1; y <= 1; ++y) {
            for (int x = -range; x <= range; ++x) {
                for (int z = -range; z <= range; ++z) {
                    if (x == 0 && z == 0 && world != null && TFC_Core.isVertSupport(world.func_147439_a(i + x, j + y, k + z))) {
                        return true;
                    }
                    if (world == null || !TFC_Core.isHorizSupport(world.func_147439_a(i + x, j + y, k + z))) continue;
                    if (world.field_73012_v.nextFloat() < collapseChance / 100.0f) {
                        world.func_147468_f(i + x, j + y, k + z);
                        continue;
                    }
                    return true;
                }
            }
        }
        return false;
    }

    public Boolean isUnderLoad(World world, int i, int j, int k) {
        for (int x = 1; x <= TFCOptions.minimumRockLoad; ++x) {
            if (world.func_147439_a(i, j + x, k).func_149662_c()) continue;
            return false;
        }
        return true;
    }

    public Boolean tryToCollapse(World world, int x, int y, int z, float collapseChance) {
        int[] drop = this.getDropBlock(world, x, y, z);
        Block fallingBlock = Block.func_149729_e((int)drop[0]);
        if (world.func_147439_a(x, y, z) == Blocks.field_150357_h || world.func_147439_a(x, y, z) == fallingBlock) {
            return false;
        }
        int fallingBlockMeta = drop[1];
        if (BlockCollapsible.canFallBelow(world, x, y - 1, z) && !BlockCollapsible.isNearSupport(world, x, y, z, 4, collapseChance).booleanValue() && this.isUnderLoad(world, x, y, z).booleanValue() && !world.field_72995_K && fallingBlock != Blocks.field_150350_a) {
            if (fallingBlock != null) {
                EntityFallingBlockTFC ent = new EntityFallingBlockTFC(world, (float)x + 0.5f, (float)y + 0.5f, (float)z + 0.5f, fallingBlock, fallingBlockMeta);
                if (this instanceof BlockStone) {
                    ent = new EntityFallingBlockTFC(world, (float)x + 0.5f, (float)y + 0.5f, (float)z + 0.5f, fallingBlock, fallingBlockMeta + 8);
                }
                ent.aliveTimer = -5000;
                world.func_72838_d((Entity)ent);
                Random r = new Random(x * y + z);
                if (r.nextInt(100) > 90) {
                    world.func_72956_a((Entity)ent, "terrafirmacraft:rock.slide.long", 1.0f, 0.8f + r.nextFloat() / 2.0f);
                }
            }
            if (world.func_147439_a(x, y, z) instanceof BlockOre && !TFCOptions.enableCaveInsDestroyOre) {
                TFC_Core.setBlockToAirWithDrops(world, x, y, z);
            } else {
                world.func_147468_f(x, y, z);
            }
            if (world.func_147439_a(x, y - 1, z) == TFCBlocks.stoneSlabs && ((TEPartial)world.func_147438_o((int)x, (int)(y - 1), (int)z)).field_145854_h == this && ((TEPartial)world.func_147438_o((int)x, (int)(y - 1), (int)z)).metaID == fallingBlockMeta) {
                world.func_147468_f(x, y - 1, z);
                if (world.func_147439_a(x, y - 2, z) == TFCBlocks.stoneSlabs && ((TEPartial)world.func_147438_o((int)x, (int)(y - 2), (int)z)).field_145854_h == this && ((TEPartial)world.func_147438_o((int)x, (int)(y - 2), (int)z)).metaID == fallingBlockMeta) {
                    world.func_147468_f(x, y - 2, z);
                    if (world.func_147439_a(x, y - 3, z) == TFCBlocks.stoneSlabs && ((TEPartial)world.func_147438_o((int)x, (int)(y - 3), (int)z)).field_145854_h == this && ((TEPartial)world.func_147438_o((int)x, (int)(y - 3), (int)z)).metaID == fallingBlockMeta) {
                        world.func_147468_f(x, y - 3, z);
                    }
                }
            }
            return true;
        }
        return false;
    }

    public static void tryToFall(World world, int x, int y, int z, Block block) {
        if (!world.field_72995_K) {
            int meta = world.func_72805_g(x, y, z);
            if (BlockCollapsible.canFallBelow(world, x, y - 1, z) && y >= 0 && (!BlockCollapsible.isNearSupport(world, x, y, z, 4, 0.0f).booleanValue() || block instanceof BlockSand)) {
                int byte0 = 32;
                if (!fallInstantly && world.func_72904_c(x - byte0, y - byte0, z - byte0, x + byte0, y + byte0, z + byte0)) {
                    if (!world.field_72995_K) {
                        EntityFallingBlockTFC entityfallingblock = new EntityFallingBlockTFC(world, (float)x + 0.5f, (float)y + 0.5f, (float)z + 0.5f, block, meta);
                        world.func_72838_d((Entity)entityfallingblock);
                        if (block instanceof BlockCobble) {
                            world.func_72956_a((Entity)entityfallingblock, "terrafirmacraft:rock.slide.short", 1.0f, 0.8f + world.field_73012_v.nextFloat() / 2.0f);
                        } else {
                            world.func_72956_a((Entity)entityfallingblock, "terrafirmacraft:dirt.slide.short", 1.0f, 0.8f + world.field_73012_v.nextFloat() / 2.0f);
                        }
                    }
                } else {
                    world.func_147468_f(x, y, z);
                    while (BlockCollapsible.canFallBelow(world, x, y - 1, z) && y > 0) {
                        --y;
                    }
                    if (y > 0) {
                        world.func_147465_d(x, y, z, block, meta, 2);
                    }
                }
            }
        }
    }

    public void func_149636_a(World world, EntityPlayer entityplayer, int x, int y, int z, int meta) {
        int finalCollapseRatio;
        float softModifier = 0.1f;
        int n = finalCollapseRatio = TFCOptions.initialCollapseRatio > 0 ? TFCOptions.initialCollapseRatio : 10;
        if (entityplayer != null) {
            entityplayer.func_71064_a(StatList.field_75934_C[BlockCollapsible.func_149682_b((Block)this)], 1);
            entityplayer.func_71020_j(0.075f);
        }
        if (this == TFCBlocks.stoneSed) {
            finalCollapseRatio = (int)((float)finalCollapseRatio - (float)finalCollapseRatio * softModifier);
        }
        if (TFCOptions.enableCaveIns && world.field_73012_v.nextInt(finalCollapseRatio) == 0) {
            for (int counter = 0; counter < 100; ++counter) {
                int scanZ;
                int scanY;
                int scanX = -4 + world.field_73012_v.nextInt(9);
                if (!(world.func_147439_a(x + scanX, y + (scanY = -2 + world.field_73012_v.nextInt(5)), z + (scanZ = -4 + world.field_73012_v.nextInt(9))) instanceof BlockCollapsible) || !((BlockCollapsible)world.func_147439_a(x + scanX, y + scanY, z + scanZ)).tryToCollapse(world, x + scanX, y + scanY, z + scanZ, 0.0f).booleanValue()) continue;
                this.triggerCollapse(world, entityplayer, x + scanX, y + scanY, z + scanZ, meta);
                return;
            }
        }
    }

    public void triggerCollapse(World world, EntityPlayer entityplayer, int i, int j, int k, int meta) {
        int height = 4;
        int range = 5 + world.field_73012_v.nextInt(31);
        for (int y = -4; y <= 1; ++y) {
            for (int x = -range; x <= range; ++x) {
                for (int z = -range; z <= range; ++z) {
                    double distSqrd = Math.pow(i - (i + x), 2.0) + Math.pow(j - (j + y), 2.0) + Math.pow(k - (k + z), 2.0);
                    if (world.field_73012_v.nextInt(100) >= TFCOptions.propogateCollapseChance || !(distSqrd < 1225.0) || !(world.func_147439_a(i + x, j + y, k + z) instanceof BlockCollapsible) || !((BlockCollapsible)world.func_147439_a(i + x, j + y, k + z)).tryToCollapse(world, i + x, j + y, k + z, 1.0f).booleanValue()) continue;
                    int done = 0;
                    while (done < height) {
                        ++done;
                        if (world.func_147439_a(i + x, j + y, k + z) instanceof BlockCollapsible && world.field_73012_v.nextInt(100) < TFCOptions.propogateCollapseChance) {
                            ((BlockCollapsible)world.func_147439_a(i + x, j + y, k + z)).tryToCollapse(world, i + x, j + y + done, k + z, 1.0f);
                            continue;
                        }
                        done = height;
                    }
                }
            }
        }
    }

    public List<ByteCoord> getCollapseMap(World world, int i, int j, int k) {
        ArrayList<ByteCoord> map = new ArrayList<ByteCoord>();
        ArrayList<ByteCoord> checkedmap = new ArrayList<ByteCoord>();
        CollapseList<CollapseData> checkQueue = new CollapseList<CollapseData>();
        float incrementChance = 2.5f;
        float incrementChanceDiag = 3.5f;
        map.add(new ByteCoord(0, 0, 0));
        checkQueue.add(new CollapseData(new ByteCoord(1, 0, 0), TFCOptions.propogateCollapseChance, TFCDirection.EAST));
        checkQueue.add(new CollapseData(new ByteCoord(-1, 0, 0), TFCOptions.propogateCollapseChance, TFCDirection.WEST));
        checkQueue.add(new CollapseData(new ByteCoord(1, 0, 1), TFCOptions.propogateCollapseChance, TFCDirection.NORTHEAST));
        checkQueue.add(new CollapseData(new ByteCoord(1, 0, -1), TFCOptions.propogateCollapseChance, TFCDirection.SOUTHEAST));
        checkQueue.add(new CollapseData(new ByteCoord(-1, 0, 1), TFCOptions.propogateCollapseChance, TFCDirection.NORTHWEST));
        checkQueue.add(new CollapseData(new ByteCoord(-1, 0, -1), TFCOptions.propogateCollapseChance, TFCDirection.SOUTHWEST));
        checkQueue.add(new CollapseData(new ByteCoord(0, 0, 1), TFCOptions.propogateCollapseChance, TFCDirection.SOUTH));
        checkQueue.add(new CollapseData(new ByteCoord(0, 0, -1), TFCOptions.propogateCollapseChance, TFCDirection.NORTH));
        while (checkQueue.peek() != null) {
            CollapseData block = (CollapseData)checkQueue.peek();
            if (!checkedmap.contains(block) && world.field_73012_v.nextFloat() < block.collapseChance / 100.0f) {
                int worldX = block.coords.x + i;
                int worldY = block.coords.y + j;
                int worldZ = block.coords.z + k;
                byte localX = block.coords.x;
                byte localY = block.coords.y;
                byte localZ = block.coords.z;
                if (world.func_147437_c(worldX, worldY, worldZ)) {
                    checkQueue.add(checkedmap, new CollapseData(new ByteCoord(localX + 0, localY + 1, localZ + 0), block.collapseChance - 10.0f, TFCDirection.UP));
                } else if (world.func_147439_a(worldX, worldY, worldZ) instanceof BlockCollapsible && ((BlockCollapsible)world.func_147439_a(worldX, worldY, worldZ)).tryToCollapse(world, worldX, worldY, worldZ, block.collapseChance).booleanValue()) {
                    map.add(block.coords);
                    switch (block.direction) {
                        case NORTH: {
                            checkQueue.add(checkedmap, new CollapseData(new ByteCoord(localX + 0, localY + 0, localZ - 1), block.collapseChance - 2.5f, TFCDirection.NORTH));
                            checkQueue.add(checkedmap, new CollapseData(new ByteCoord(localX + 1, localY + 0, localZ + 0), block.collapseChance - 2.5f, TFCDirection.EAST));
                            checkQueue.add(checkedmap, new CollapseData(new ByteCoord(localX - 1, localY + 0, localZ + 0), block.collapseChance - 2.5f, TFCDirection.WEST));
                            break;
                        }
                        case SOUTH: {
                            checkQueue.add(checkedmap, new CollapseData(new ByteCoord(localX + 0, localY + 0, localZ + 1), block.collapseChance - 2.5f, TFCDirection.SOUTH));
                            checkQueue.add(checkedmap, new CollapseData(new ByteCoord(localX + 1, localY + 0, localZ + 0), block.collapseChance - 2.5f, TFCDirection.EAST));
                            checkQueue.add(checkedmap, new CollapseData(new ByteCoord(localX - 1, localY + 0, localZ + 0), block.collapseChance - 2.5f, TFCDirection.WEST));
                            break;
                        }
                        case EAST: {
                            checkQueue.add(checkedmap, new CollapseData(new ByteCoord(localX + 0, localY + 0, localZ + 1), block.collapseChance - 2.5f, TFCDirection.SOUTH));
                            checkQueue.add(checkedmap, new CollapseData(new ByteCoord(localX + 1, localY + 0, localZ + 0), block.collapseChance - 2.5f, TFCDirection.EAST));
                            checkQueue.add(checkedmap, new CollapseData(new ByteCoord(localX + 0, localY + 0, localZ - 1), block.collapseChance - 2.5f, TFCDirection.NORTH));
                            break;
                        }
                        case WEST: {
                            checkQueue.add(checkedmap, new CollapseData(new ByteCoord(localX + 0, localY + 0, localZ + 1), block.collapseChance - 2.5f, TFCDirection.SOUTH));
                            checkQueue.add(checkedmap, new CollapseData(new ByteCoord(localX - 1, localY + 0, localZ + 0), block.collapseChance - 2.5f, TFCDirection.WEST));
                            checkQueue.add(checkedmap, new CollapseData(new ByteCoord(localX + 0, localY + 0, localZ - 1), block.collapseChance - 2.5f, TFCDirection.NORTH));
                            break;
                        }
                        case SOUTHEAST: {
                            checkQueue.add(checkedmap, new CollapseData(new ByteCoord(localX + 1, localY + 0, localZ - 1), block.collapseChance - 3.5f, TFCDirection.SOUTHEAST));
                            checkQueue.add(checkedmap, new CollapseData(new ByteCoord(localX + 0, localY + 0, localZ + 1), block.collapseChance - 2.5f, TFCDirection.SOUTH));
                            checkQueue.add(checkedmap, new CollapseData(new ByteCoord(localX + 1, localY + 0, localZ + 0), block.collapseChance - 2.5f, TFCDirection.EAST));
                            break;
                        }
                        case SOUTHWEST: {
                            checkQueue.add(checkedmap, new CollapseData(new ByteCoord(localX - 1, localY + 0, localZ - 1), block.collapseChance - 3.5f, TFCDirection.SOUTHWEST));
                            checkQueue.add(checkedmap, new CollapseData(new ByteCoord(localX + 0, localY + 0, localZ + 1), block.collapseChance - 2.5f, TFCDirection.SOUTH));
                            checkQueue.add(checkedmap, new CollapseData(new ByteCoord(localX - 1, localY + 0, localZ + 0), block.collapseChance - 2.5f, TFCDirection.WEST));
                            break;
                        }
                        case NORTHEAST: {
                            checkQueue.add(checkedmap, new CollapseData(new ByteCoord(localX + 1, localY + 0, localZ + 1), block.collapseChance - 3.5f, TFCDirection.NORTHEAST));
                            checkQueue.add(checkedmap, new CollapseData(new ByteCoord(localX + 1, localY + 0, localZ + 0), block.collapseChance - 2.5f, TFCDirection.EAST));
                            checkQueue.add(checkedmap, new CollapseData(new ByteCoord(localX + 0, localY + 0, localZ - 1), block.collapseChance - 2.5f, TFCDirection.NORTH));
                            break;
                        }
                        case NORTHWEST: {
                            checkQueue.add(checkedmap, new CollapseData(new ByteCoord(localX - 1, localY + 0, localZ + 1), block.collapseChance - 3.5f, TFCDirection.NORTHWEST));
                            checkQueue.add(checkedmap, new CollapseData(new ByteCoord(localX + 0, localY + 0, localZ - 1), block.collapseChance - 2.5f, TFCDirection.NORTH));
                            checkQueue.add(checkedmap, new CollapseData(new ByteCoord(localX - 1, localY + 0, localZ + 0), block.collapseChance - 2.5f, TFCDirection.WEST));
                            break;
                        }
                        default: {
                            checkQueue.add(checkedmap, new CollapseData(new ByteCoord(localX + 1, localY + 0, localZ + 0), block.collapseChance - 2.5f, TFCDirection.EAST));
                            checkQueue.add(checkedmap, new CollapseData(new ByteCoord(localX - 1, localY + 0, localZ + 0), block.collapseChance - 2.5f, TFCDirection.WEST));
                            checkQueue.add(checkedmap, new CollapseData(new ByteCoord(localX + 1, localY + 0, localZ + 1), block.collapseChance - 3.5f, TFCDirection.NORTHEAST));
                            checkQueue.add(checkedmap, new CollapseData(new ByteCoord(localX + 1, localY + 0, localZ - 1), block.collapseChance - 3.5f, TFCDirection.SOUTHEAST));
                            checkQueue.add(checkedmap, new CollapseData(new ByteCoord(localX - 1, localY + 0, localZ + 1), block.collapseChance - 3.5f, TFCDirection.NORTHWEST));
                            checkQueue.add(checkedmap, new CollapseData(new ByteCoord(localX - 1, localY + 0, localZ - 1), block.collapseChance - 3.5f, TFCDirection.SOUTHWEST));
                            checkQueue.add(checkedmap, new CollapseData(new ByteCoord(localX + 0, localY + 0, localZ + 1), block.collapseChance - 2.5f, TFCDirection.SOUTH));
                            checkQueue.add(checkedmap, new CollapseData(new ByteCoord(localX + 0, localY + 0, localZ - 1), block.collapseChance - 2.5f, TFCDirection.NORTH));
                        }
                    }
                }
            }
            checkedmap.add(block.coords);
            checkQueue.removeFirst();
        }
        return map;
    }

    public void func_149723_a(World world, int x, int y, int z, Explosion ex) {
        this.func_149636_a(world, null, x, y, z, world.func_72805_g(x, y, z));
    }

    @Override
    public boolean canBeReplacedByLeaves(IBlockAccess w, int x, int y, int z) {
        return false;
    }
}

